/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class CommonAbstractStoreTest {
    private static final NullLogProvider LOG = NullLogProvider.getInstance();
    private final IdGeneratorFactory idGeneratorFactory = (IdGeneratorFactory)Mockito.mock(IdGeneratorFactory.class);
    private final PageCache pageCache = (PageCache)Mockito.mock(PageCache.class);
    private final Config config = new Config();
    private final File storeFile = new File("store");
    private final IdType idType = IdType.RELATIONSHIP;

    @Test
    public void shouldCloseStoreFileFirstAndIdGeneratorAfter() throws Throwable {
        PagedFile storePagedFile = (PagedFile)Mockito.mock(PagedFile.class);
        Mockito.when((Object)this.pageCache.map((File)Matchers.eq((Object)this.storeFile), Matchers.anyInt(), new OpenOption[0])).thenReturn((Object)storePagedFile);
        IdGenerator idGenerator = (IdGenerator)Mockito.mock(IdGenerator.class);
        Mockito.when((Object)this.idGeneratorFactory.open((File)Matchers.any(File.class), (IdType)Matchers.eq((Object)this.idType), (long)Matchers.anyInt())).thenReturn((Object)idGenerator);
        TheStore store = new TheStore(this.storeFile, this.config, this.idType, this.idGeneratorFactory, this.pageCache, (LogProvider)LOG);
        store.initialise(false);
        Mockito.reset((Object[])new Object[]{storePagedFile, idGenerator});
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{storePagedFile, idGenerator});
        store.close();
        ((PagedFile)inOrder.verify((Object)storePagedFile, Mockito.times((int)1))).close();
        ((IdGenerator)inOrder.verify((Object)idGenerator, Mockito.times((int)1))).close();
    }

    private static class TheStore
    extends CommonAbstractStore {
        public TheStore(File fileName, Config configuration, IdType idType, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, LogProvider logProvider) {
            super(fileName, configuration, idType, idGeneratorFactory, pageCache, logProvider);
        }

        protected String getTypeDescriptor() {
            return null;
        }

        protected void initialiseNewStoreFile(PagedFile file) throws IOException {
        }

        protected void readAndVerifyBlockSize() throws IOException {
        }

        protected boolean isInUse(byte inUseByte) {
            return false;
        }

        public int getRecordSize() {
            return 10;
        }

        public long scanForHighId() {
            return 42L;
        }
    }
}

