/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;

public class MetaDataStoreTest {
    @ClassRule
    public static final EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    @ClassRule
    public static final PageCacheRule pageCacheRule = new PageCacheRule();

    @Test
    public void getCreationTimeShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = MetaDataStoreTest.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.getCreationTime();
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void getCurrentLogVersionShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = MetaDataStoreTest.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.getCurrentLogVersion();
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void getGraphNextPropShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = MetaDataStoreTest.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.getGraphNextProp();
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void getLastClosedTransactionIdShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = MetaDataStoreTest.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.getLastClosedTransactionId();
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void getLastClosedTransactionShouldFailWhenStoreIsClosed() throws Exception {
        MetaDataStore metaDataStore = MetaDataStoreTest.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.getLastClosedTransaction();
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void getLastCommittedTransactionShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = MetaDataStoreTest.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.getLastCommittedTransaction();
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void getLastCommittedTransactionIdShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = MetaDataStoreTest.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.getLastCommittedTransactionId();
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void getLatestConstraintIntroducingTxShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = MetaDataStoreTest.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.getLatestConstraintIntroducingTx();
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void getRandomNumberShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = MetaDataStoreTest.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.getRandomNumber();
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void getStoreVersionShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = MetaDataStoreTest.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.getStoreVersion();
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void getUpgradeTimeShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = MetaDataStoreTest.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.getUpgradeTime();
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void getUpgradeTransactionShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = MetaDataStoreTest.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.getUpgradeTransaction();
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void nextCommittingTransactionIdShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = MetaDataStoreTest.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.nextCommittingTransactionId();
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void setLastCommittedAndClosedTransactionIdShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = MetaDataStoreTest.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.setLastCommittedAndClosedTransactionId(1L, 1L, 0L, 1L, 1L);
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void transactionCommittedShouldFailWhenStoreIsClosed() throws IOException {
        MetaDataStore metaDataStore = MetaDataStoreTest.newMetaDataStore();
        metaDataStore.close();
        try {
            metaDataStore.transactionCommitted(1L, 1L, 0L);
            Assert.fail((String)"Expected exception reading from MetaDataStore after being closed.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void lastTxCommitTimestampShouldBeBaseInNewStore() throws Exception {
        try (MetaDataStore metaDataStore = MetaDataStoreTest.newMetaDataStore();){
            long timestamp = metaDataStore.getLastCommittedTransaction().commitTimestamp();
            Assert.assertThat((Object)timestamp, (Matcher)Matchers.equalTo((Object)0L));
        }
    }

    private static MetaDataStore newMetaDataStore() throws IOException {
        EphemeralFileSystemAbstraction fs = fsRule.get();
        PageCache pageCache = pageCacheRule.getPageCache((FileSystemAbstraction)fs);
        File dir = new File("store");
        StoreFactory storeFactory = new StoreFactory((FileSystemAbstraction)fs, dir, pageCache, (LogProvider)NullLogProvider.getInstance());
        return storeFactory.openNeoStores(true, new NeoStores.StoreType[]{NeoStores.StoreType.META_DATA}).getMetaDataStore();
    }
}

