/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.cursor.NodeItem;
import org.neo4j.kernel.api.cursor.RelationshipItem;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.core.RelationshipTypeToken;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.NoOpClient;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreNotFoundException;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.transaction.state.PropertyLoader;
import org.neo4j.kernel.impl.transaction.state.TransactionRecordState;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.NeoStoreDataSourceRule;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;

public class NeoStoresTest {
    @Rule
    public PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public TargetDirectory.TestDirectory dir = TargetDirectory.testDirForTestWithEphemeralFS((EphemeralFileSystemAbstraction)this.fs.get(), this.getClass());
    @Rule
    public NeoStoreDataSourceRule dsRule = new NeoStoreDataSourceRule();
    @Rule
    public final ExpectedException exception = ExpectedException.none();
    private PageCache pageCache;
    private File storeDir;
    private PropertyStore pStore;
    private RelationshipTypeTokenStore rtStore;
    private NeoStoreDataSource ds;
    private KernelTransaction tx;
    private TransactionRecordState transaction;
    private StoreReadLayer storeLayer;
    private PropertyLoader propertyLoader;

    @Before
    public void setUpNeoStores() throws Exception {
        this.storeDir = this.dir.graphDbDir();
        Config config = new Config(new HashMap(), new Class[]{GraphDatabaseSettings.class});
        this.pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs.get());
        StoreFactory sf = new StoreFactory(this.storeDir, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory((FileSystemAbstraction)this.fs.get()), this.pageCache, (FileSystemAbstraction)this.fs.get(), (LogProvider)NullLogProvider.getInstance());
        sf.openAllNeoStores(true).close();
    }

    @Test
    public void impossibleToGetStoreFromClosedNeoStoresContainer() {
        Config config = new Config(new HashMap(), new Class[]{GraphDatabaseSettings.class});
        StoreFactory sf = new StoreFactory(this.storeDir, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory((FileSystemAbstraction)this.fs.get()), this.pageCache, (FileSystemAbstraction)this.fs.get(), (LogProvider)NullLogProvider.getInstance());
        NeoStores neoStores = sf.openAllNeoStores(true);
        Assert.assertNotNull((Object)neoStores.getMetaDataStore());
        neoStores.close();
        this.exception.expect(IllegalStateException.class);
        this.exception.expectMessage("Specified store was already closed.");
        neoStores.getMetaDataStore();
    }

    @Test
    public void impossibleToGetNotRequestedStore() {
        Config config = new Config(new HashMap(), new Class[]{GraphDatabaseSettings.class});
        StoreFactory sf = new StoreFactory(this.storeDir, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory((FileSystemAbstraction)this.fs.get()), this.pageCache, (FileSystemAbstraction)this.fs.get(), (LogProvider)NullLogProvider.getInstance());
        NeoStores neoStores = sf.openNeoStores(true, new NeoStores.StoreType[]{NeoStores.StoreType.NODE_LABEL});
        this.exception.expect(IllegalStateException.class);
        this.exception.expectMessage("Specified store was not initialized. Please specify " + NeoStores.StoreType.META_DATA.name() + " as one of the stores types that should be open to be able to use it.");
        neoStores.getMetaDataStore();
    }

    @Test
    public void testCreateStore() throws Exception {
        int i;
        this.initializeStores(this.storeDir, MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        long node1 = this.nextId(Node.class);
        this.transaction.nodeCreate(node1);
        long node2 = this.nextId(Node.class);
        this.transaction.nodeCreate(node2);
        DefinedProperty n1prop1 = this.transaction.nodeAddProperty(node1, this.index("prop1"), (Object)"string1");
        DefinedProperty n1prop2 = this.transaction.nodeAddProperty(node1, this.index("prop2"), (Object)1);
        DefinedProperty n1prop3 = this.transaction.nodeAddProperty(node1, this.index("prop3"), (Object)true);
        DefinedProperty n2prop1 = this.transaction.nodeAddProperty(node2, this.index("prop1"), (Object)"string2");
        DefinedProperty n2prop2 = this.transaction.nodeAddProperty(node2, this.index("prop2"), (Object)2);
        DefinedProperty n2prop3 = this.transaction.nodeAddProperty(node2, this.index("prop3"), (Object)false);
        int relType1 = (int)this.nextId(RelationshipType.class);
        String typeName1 = "relationshiptype1";
        this.transaction.createRelationshipTypeToken(typeName1, relType1);
        int relType2 = (int)this.nextId(RelationshipType.class);
        String typeName2 = "relationshiptype2";
        this.transaction.createRelationshipTypeToken(typeName2, relType2);
        long rel1 = this.nextId(Relationship.class);
        this.transaction.relCreate(rel1, relType1, node1, node2);
        long rel2 = this.nextId(Relationship.class);
        this.transaction.relCreate(rel2, relType2, node2, node1);
        DefinedProperty r1prop1 = this.transaction.relAddProperty(rel1, this.index("prop1"), (Object)"string1");
        DefinedProperty r1prop2 = this.transaction.relAddProperty(rel1, this.index("prop2"), (Object)1);
        DefinedProperty r1prop3 = this.transaction.relAddProperty(rel1, this.index("prop3"), (Object)true);
        DefinedProperty r2prop1 = this.transaction.relAddProperty(rel2, this.index("prop1"), (Object)"string2");
        DefinedProperty r2prop2 = this.transaction.relAddProperty(rel2, this.index("prop2"), (Object)2);
        DefinedProperty r2prop3 = this.transaction.relAddProperty(rel2, this.index("prop3"), (Object)false);
        this.commitTx();
        this.ds.stop();
        this.initializeStores(this.storeDir, MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        this.validateNodeRel1(node1, n1prop1, n1prop2, n1prop3, rel1, rel2, relType1, relType2);
        this.validateNodeRel2(node2, n2prop1, n2prop2, n2prop3, rel1, rel2, relType1, relType2);
        this.validateRel1(rel1, r1prop1, r1prop2, r1prop3, node1, node2, relType1);
        this.validateRel2(rel2, r2prop1, r2prop2, r2prop3, node2, node1, relType2);
        this.validateRelTypes(relType1, relType2);
        this.validateRelTypes(relType1, relType2);
        this.commitTx();
        this.ds.stop();
        this.initializeStores(this.storeDir, MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        this.deleteRel1(rel1, r1prop1, r1prop2, r1prop3, node1, node2, relType1);
        this.deleteRel2(rel2, r2prop1, r2prop2, r2prop3, node2, node1, relType2);
        this.deleteNode1(node1, n1prop1, n1prop2, n1prop3);
        this.deleteNode2(node2, n2prop1, n2prop2, n2prop3);
        this.commitTx();
        this.ds.stop();
        this.initializeStores(this.storeDir, MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        Assert.assertFalse((boolean)this.nodeExists(node1));
        Assert.assertFalse((boolean)this.nodeExists(node2));
        this.testGetRels(new long[]{rel1, rel2});
        long[] nodeIds = new long[10];
        for (i = 0; i < 3; ++i) {
            nodeIds[i] = this.nextId(Node.class);
            this.transaction.nodeCreate(nodeIds[i]);
            this.transaction.nodeAddProperty(nodeIds[i], this.index("nisse"), (Object)new Integer(10 - i));
        }
        for (i = 0; i < 2; ++i) {
            long id = this.nextId(Relationship.class);
            this.transaction.relCreate(id, relType1, nodeIds[i], nodeIds[i + 1]);
            this.transaction.relDelete(id);
        }
        for (i = 0; i < 3; ++i) {
            this.transaction.nodeDelete(nodeIds[i]);
        }
        this.commitTx();
        this.ds.stop();
    }

    @Test
    public void testRels1() throws Exception {
        int i;
        this.initializeStores(this.storeDir, MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        int relType1 = (int)this.nextId(RelationshipType.class);
        String typeName = "relationshiptype1";
        this.transaction.createRelationshipTypeToken(typeName, relType1);
        long[] nodeIds = new long[3];
        for (i = 0; i < 3; ++i) {
            nodeIds[i] = this.nextId(Node.class);
            this.transaction.nodeCreate(nodeIds[i]);
            this.transaction.nodeAddProperty(nodeIds[i], this.index("nisse"), (Object)new Integer(10 - i));
        }
        for (i = 0; i < 2; ++i) {
            this.transaction.relCreate(this.nextId(Relationship.class), relType1, nodeIds[i], nodeIds[i + 1]);
        }
        this.commitTx();
        this.startTx();
        for (i = 0; i < 3; i += 2) {
            try (Cursor nodeCursor = ((KernelStatement)this.tx.acquireStatement()).getStoreStatement().acquireSingleNodeCursor(nodeIds[i]);){
                nodeCursor.next();
                RelationshipIterator relationships = ((NodeItem)nodeCursor.get()).getRelationships(Direction.BOTH);
                while (relationships.hasNext()) {
                    this.transaction.relDelete(relationships.next());
                }
            }
            this.transaction.nodeDelete(nodeIds[i]);
        }
        this.commitTx();
        this.ds.stop();
    }

    @Test
    @Ignore
    public void testRels2() throws Exception {
        int i;
        this.initializeStores(this.storeDir, MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        int relType1 = (int)this.nextId(RelationshipType.class);
        String typeName = "relationshiptype1";
        this.transaction.createRelationshipTypeToken(typeName, relType1);
        long[] nodeIds = new long[3];
        for (i = 0; i < 3; ++i) {
            nodeIds[i] = this.nextId(Node.class);
            this.transaction.nodeCreate(nodeIds[i]);
            this.transaction.nodeAddProperty(nodeIds[i], this.index("nisse"), (Object)new Integer(10 - i));
        }
        for (i = 0; i < 2; ++i) {
            this.transaction.relCreate(this.nextId(Relationship.class), relType1, nodeIds[i], nodeIds[i + 1]);
        }
        this.transaction.relCreate(this.nextId(Relationship.class), relType1, nodeIds[0], nodeIds[2]);
        this.commitTx();
        this.startTx();
        for (i = 0; i < 3; ++i) {
            try (Cursor nodeCursor = ((KernelStatement)this.tx.acquireStatement()).getStoreStatement().acquireSingleNodeCursor(nodeIds[i]);){
                nodeCursor.next();
                RelationshipIterator relationships = ((NodeItem)nodeCursor.get()).getRelationships(Direction.BOTH);
                while (relationships.hasNext()) {
                    this.transaction.relDelete(relationships.next());
                }
            }
            this.transaction.nodeDelete(nodeIds[i]);
        }
        this.commitTx();
        this.ds.stop();
    }

    @Test
    public void testRels3() throws Exception {
        int i;
        this.initializeStores(this.storeDir, MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        int relType1 = (int)this.nextId(RelationshipType.class);
        this.transaction.createRelationshipTypeToken("relationshiptype1", relType1);
        long[] nodeIds = new long[8];
        for (i = 0; i < nodeIds.length; ++i) {
            nodeIds[i] = this.nextId(Node.class);
            this.transaction.nodeCreate(nodeIds[i]);
        }
        for (i = 0; i < nodeIds.length / 2; ++i) {
            this.transaction.relCreate(this.nextId(Relationship.class), relType1, nodeIds[i], nodeIds[i * 2]);
        }
        long rel5 = this.nextId(Relationship.class);
        this.transaction.relCreate(rel5, relType1, nodeIds[0], nodeIds[5]);
        long rel2 = this.nextId(Relationship.class);
        this.transaction.relCreate(rel2, relType1, nodeIds[1], nodeIds[2]);
        long rel3 = this.nextId(Relationship.class);
        this.transaction.relCreate(rel3, relType1, nodeIds[1], nodeIds[3]);
        long rel6 = this.nextId(Relationship.class);
        this.transaction.relCreate(rel6, relType1, nodeIds[1], nodeIds[6]);
        long rel1 = this.nextId(Relationship.class);
        this.transaction.relCreate(rel1, relType1, nodeIds[0], nodeIds[1]);
        long rel4 = this.nextId(Relationship.class);
        this.transaction.relCreate(rel4, relType1, nodeIds[0], nodeIds[4]);
        long rel7 = this.nextId(Relationship.class);
        this.transaction.relCreate(rel7, relType1, nodeIds[0], nodeIds[7]);
        this.commitTx();
        this.startTx();
        this.transaction.relDelete(rel7);
        this.transaction.relDelete(rel4);
        this.transaction.relDelete(rel1);
        this.transaction.relDelete(rel6);
        this.transaction.relDelete(rel3);
        this.transaction.relDelete(rel2);
        this.transaction.relDelete(rel5);
        this.commitTx();
        this.ds.stop();
    }

    @Test
    public void testProps1() throws Exception {
        this.initializeStores(this.storeDir, MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        long nodeId = this.nextId(Node.class);
        this.transaction.nodeCreate(nodeId);
        this.pStore.nextId();
        DefinedProperty prop = this.transaction.nodeAddProperty(nodeId, this.index("nisse"), (Object)new Integer(10));
        this.commitTx();
        this.ds.stop();
        this.initializeStores(this.storeDir, MapUtil.stringMap((String[])new String[0]));
        this.startTx();
        this.transaction.nodeChangeProperty(nodeId, prop.propertyKeyId(), (Object)new Integer(5));
        this.transaction.nodeRemoveProperty(nodeId, prop.propertyKeyId());
        this.transaction.nodeDelete(nodeId);
        this.commitTx();
        this.ds.stop();
    }

    @Test
    public void testSetBlockSize() throws Exception {
        File storeDir = this.dir.directory("small_store");
        this.initializeStores(storeDir, MapUtil.stringMap((String[])new String[]{"string_block_size", "62", "array_block_size", "302"}));
        Assert.assertEquals((long)70L, (long)this.pStore.getStringBlockSize());
        Assert.assertEquals((long)310L, (long)this.pStore.getArrayBlockSize());
        this.ds.stop();
    }

    @Test
    public void setVersion() throws Exception {
        EphemeralFileSystemAbstraction fileSystem = this.fs.get();
        File storeDir = new File("target/test-data/set-version").getAbsoluteFile();
        new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)fileSystem).newImpermanentDatabase(storeDir).shutdown();
        Assert.assertEquals((long)0L, (long)MetaDataStore.setRecord((PageCache)this.pageCache, (File)new File(storeDir, "neostore").getAbsoluteFile(), (MetaDataStore.Position)MetaDataStore.Position.LOG_VERSION, (long)10L));
        Assert.assertEquals((long)10L, (long)MetaDataStore.setRecord((PageCache)this.pageCache, (File)new File(storeDir, "neostore").getAbsoluteFile(), (MetaDataStore.Position)MetaDataStore.Position.LOG_VERSION, (long)12L));
        Config config = new Config(new HashMap(), new Class[]{GraphDatabaseSettings.class});
        StoreFactory sf = new StoreFactory(storeDir, config, (IdGeneratorFactory)new DefaultIdGeneratorFactory((FileSystemAbstraction)fileSystem), this.pageCache, (FileSystemAbstraction)fileSystem, (LogProvider)NullLogProvider.getInstance());
        NeoStores neoStores = sf.openAllNeoStores();
        Assert.assertEquals((long)12L, (long)neoStores.getMetaDataStore().getCurrentLogVersion());
        neoStores.close();
    }

    @Test
    public void shouldNotReadNonRecordDataAsRecord() throws Exception {
        EphemeralFileSystemAbstraction fileSystem = this.fs.get();
        File neoStoreDir = new File("/tmp/graph.db/neostore").getAbsoluteFile();
        StoreFactory factory = new StoreFactory((FileSystemAbstraction)fileSystem, neoStoreDir, this.pageCache, (LogProvider)NullLogProvider.getInstance());
        try (NeoStores neoStores = factory.openAllNeoStores(true);){
            MetaDataStore metaDataStore = neoStores.getMetaDataStore();
            metaDataStore.setCreationTime(3L);
            metaDataStore.setRandomNumber(4L);
            metaDataStore.setCurrentLogVersion(5L);
            metaDataStore.setLastCommittedAndClosedTransactionId(6L, 0L, 0L, 0L, 0L);
            metaDataStore.setStoreVersion(7L);
            metaDataStore.setGraphNextProp(8L);
            metaDataStore.setLatestConstraintIntroducingTx(9L);
        }
        File file = new File(neoStoreDir, "neostore");
        try (StoreChannel channel = fileSystem.open(file, "rw");){
            channel.position(0L);
            channel.write(ByteBuffer.wrap(UTF8.encode((String)"This is some data that is not a record.")));
        }
        var6_6 = null;
        try (NeoStores neoStores = factory.openAllNeoStores();){
            MetaDataStore metaDataStore = neoStores.getMetaDataStore();
            Assert.assertEquals((long)-1L, (long)metaDataStore.getCreationTime());
            Assert.assertEquals((long)-1L, (long)metaDataStore.getRandomNumber());
            Assert.assertEquals((long)-1L, (long)metaDataStore.getCurrentLogVersion());
            Assert.assertEquals((long)-1L, (long)metaDataStore.getLastCommittedTransactionId());
            Assert.assertEquals((long)-1L, (long)metaDataStore.getStoreVersion());
            Assert.assertEquals((long)8L, (long)metaDataStore.getGraphNextProp());
            Assert.assertEquals((long)9L, (long)metaDataStore.getLatestConstraintIntroducingTx());
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testSetLatestConstraintTx() throws Exception {
        Config config = new Config(new HashMap(), new Class[]{GraphDatabaseSettings.class});
        StoreFactory sf = new StoreFactory(this.dir.directory(), config, (IdGeneratorFactory)new DefaultIdGeneratorFactory((FileSystemAbstraction)this.fs.get()), this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs.get()), (FileSystemAbstraction)this.fs.get(), (LogProvider)NullLogProvider.getInstance());
        NeoStores neoStores = sf.openAllNeoStores(true);
        MetaDataStore metaDataStore = neoStores.getMetaDataStore();
        Assert.assertEquals((long)0L, (long)metaDataStore.getLatestConstraintIntroducingTx());
        metaDataStore.setLatestConstraintIntroducingTx(10L);
        Assert.assertEquals((long)10L, (long)metaDataStore.getLatestConstraintIntroducingTx());
        neoStores.flush();
        neoStores.close();
        neoStores = sf.openAllNeoStores();
        Assert.assertEquals((long)10L, (long)neoStores.getMetaDataStore().getLatestConstraintIntroducingTx());
        neoStores.close();
    }

    @Test
    public void shouldInitializeTheTxIdToOne() {
        StoreFactory factory = new StoreFactory((FileSystemAbstraction)this.fs.get(), new File("graph.db/neostore"), this.pageCache, (LogProvider)NullLogProvider.getInstance());
        try (NeoStores neoStores = factory.openAllNeoStores(true);){
            neoStores.getMetaDataStore();
        }
        neoStores = factory.openAllNeoStores();
        var3_3 = null;
        try {
            long lastCommittedTransactionId = neoStores.getMetaDataStore().getLastCommittedTransactionId();
            Assert.assertEquals((long)1L, (long)lastCommittedTransactionId);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (neoStores != null) {
                if (var3_3 != null) {
                    try {
                        neoStores.close();
                    }
                    catch (Throwable x2) {
                        var3_3.addSuppressed(x2);
                    }
                } else {
                    neoStores.close();
                }
            }
        }
    }

    @Test
    public void shouldThrowUnderlyingStorageExceptionWhenFailingToLoadStorage() {
        EphemeralFileSystemAbstraction fileSystem = this.fs.get();
        File neoStoreDir = new File("/tmp/graph.db/neostore").getAbsoluteFile();
        StoreFactory factory = new StoreFactory((FileSystemAbstraction)fileSystem, neoStoreDir, this.pageCache, (LogProvider)NullLogProvider.getInstance());
        try (NeoStores neoStores = factory.openAllNeoStores(true);){
            neoStores.getMetaDataStore();
        }
        File file = new File(neoStoreDir, "neostore");
        fileSystem.deleteFile(file);
        this.exception.expect(StoreNotFoundException.class);
        try (NeoStores neoStores = factory.openAllNeoStores();){
            neoStores.getMetaDataStore();
        }
    }

    @Test
    public void shouldAddUpgradeFieldsToTheNeoStoreIfNotPresent() throws IOException {
        EphemeralFileSystemAbstraction fileSystem = this.fs.get();
        File neoStoreDir = new File("/tmp/graph.db/neostore").getAbsoluteFile();
        StoreFactory factory = new StoreFactory((FileSystemAbstraction)fileSystem, neoStoreDir, this.pageCache, (LogProvider)NullLogProvider.getInstance());
        try (NeoStores neoStores = factory.openAllNeoStores(true);){
            MetaDataStore metaDataStore = neoStores.getMetaDataStore();
            metaDataStore.setCreationTime(3L);
            metaDataStore.setRandomNumber(4L);
            metaDataStore.setCurrentLogVersion(5L);
            metaDataStore.setLastCommittedAndClosedTransactionId(6L, 0L, 0L, 0L, 0L);
            metaDataStore.setStoreVersion(7L);
            metaDataStore.setGraphNextProp(8L);
            metaDataStore.setLatestConstraintIntroducingTx(9L);
        }
        File file = new File(neoStoreDir, "neostore");
        Assert.assertNotEquals((long)10L, (long)MetaDataStore.getRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TRANSACTION_ID));
        Assert.assertNotEquals((long)11L, (long)MetaDataStore.getRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TRANSACTION_CHECKSUM));
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TRANSACTION_ID, (long)10L);
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TRANSACTION_CHECKSUM, (long)11L);
        MetaDataStore.setRecord((PageCache)this.pageCache, (File)file, (MetaDataStore.Position)MetaDataStore.Position.UPGRADE_TIME, (long)12L);
        try (NeoStores neoStores = factory.openAllNeoStores();){
            MetaDataStore metaDataStore = neoStores.getMetaDataStore();
            Assert.assertEquals((long)3L, (long)metaDataStore.getCreationTime());
            Assert.assertEquals((long)4L, (long)metaDataStore.getRandomNumber());
            Assert.assertEquals((long)5L, (long)metaDataStore.getCurrentLogVersion());
            Assert.assertEquals((long)6L, (long)metaDataStore.getLastCommittedTransactionId());
            Assert.assertEquals((long)7L, (long)metaDataStore.getStoreVersion());
            Assert.assertEquals((long)8L, (long)metaDataStore.getGraphNextProp());
            Assert.assertEquals((long)9L, (long)metaDataStore.getLatestConstraintIntroducingTx());
            Assert.assertEquals((Object)new TransactionId(10L, 11L, 0L), (Object)metaDataStore.getUpgradeTransaction());
            Assert.assertEquals((long)12L, (long)metaDataStore.getUpgradeTime());
        }
    }

    @Test
    public void shouldSetHighestTransactionIdWhenNeeded() throws Throwable {
        EphemeralFileSystemAbstraction fileSystem = this.fs.get();
        fileSystem.mkdirs(this.storeDir);
        StoreFactory factory = new StoreFactory((FileSystemAbstraction)fileSystem, this.storeDir, this.pageCache, (LogProvider)NullLogProvider.getInstance());
        try (NeoStores neoStore = factory.openAllNeoStores(true);){
            MetaDataStore store = neoStore.getMetaDataStore();
            store.setLastCommittedAndClosedTransactionId(40L, 4444L, 0L, 16L, 0L);
            store.transactionCommitted(42L, 6666L, 0L);
            Assert.assertEquals((Object)new TransactionId(42L, 6666L, 0L), (Object)store.getLastCommittedTransaction());
        }
    }

    @Test
    public void shouldNotSetHighestTransactionIdWhenNeeded() throws Throwable {
        EphemeralFileSystemAbstraction fileSystem = this.fs.get();
        fileSystem.mkdirs(this.storeDir);
        StoreFactory factory = new StoreFactory((FileSystemAbstraction)fileSystem, this.storeDir, this.pageCache, (LogProvider)NullLogProvider.getInstance());
        try (NeoStores neoStore = factory.openAllNeoStores(true);){
            MetaDataStore store = neoStore.getMetaDataStore();
            store.setLastCommittedAndClosedTransactionId(40L, 4444L, 0L, 16L, 0L);
            store.transactionCommitted(39L, 3333L, 0L);
            Assert.assertEquals((Object)new TransactionId(40L, 4444L, 0L), (Object)store.getLastCommittedTransaction());
        }
    }

    private Token createDummyIndex(int id, String key) {
        MyPropertyKeyToken index = new MyPropertyKeyToken(key, id);
        MyPropertyKeyToken.add(index);
        return index;
    }

    private void initializeStores(File storeDir, Map<String, String> additionalConfig) throws IOException {
        this.ds = this.dsRule.getDataSource(storeDir, (FileSystemAbstraction)this.fs.get(), this.pageCache, additionalConfig);
        this.ds.init();
        this.ds.start();
        NeoStores neoStores = this.ds.get();
        this.pStore = neoStores.getPropertyStore();
        this.rtStore = neoStores.getRelationshipTypeTokenStore();
        this.storeLayer = this.ds.getStoreLayer();
        this.propertyLoader = new PropertyLoader(neoStores);
    }

    private void startTx() throws TransactionFailureException {
        this.tx = this.ds.getKernel().newTransaction();
        this.transaction = ((KernelTransactionImplementation)this.tx).getTransactionRecordState();
        this.transaction.getContext().init((Locks.Client)new NoOpClient());
    }

    private void commitTx() throws TransactionFailureException {
        this.tx.success();
        this.tx.close();
    }

    private int index(String key) {
        Iterator<Token> itr = MyPropertyKeyToken.index(key).iterator();
        if (!itr.hasNext()) {
            int id = (int)this.nextId(PropertyKeyTokenRecord.class);
            this.createDummyIndex(id, key);
            this.transaction.createPropertyKeyToken(key, id);
            return id;
        }
        return itr.next().id();
    }

    private long nextId(Class<?> clazz) {
        NeoStores neoStores = this.ds.get();
        if (clazz.equals(PropertyKeyTokenRecord.class)) {
            return neoStores.getPropertyKeyTokenStore().nextId();
        }
        if (clazz.equals(RelationshipType.class)) {
            return neoStores.getRelationshipTypeTokenStore().nextId();
        }
        if (clazz.equals(Node.class)) {
            return neoStores.getNodeStore().nextId();
        }
        if (clazz.equals(Relationship.class)) {
            return neoStores.getRelationshipStore().nextId();
        }
        throw new IllegalArgumentException(clazz.getName());
    }

    private void validateNodeRel1(long node, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3, long rel1, long rel2, int relType1, int relType2) throws IOException, EntityNotFoundException {
        Assert.assertTrue((boolean)this.nodeExists(node));
        ArrayMap props = new ArrayMap();
        TransactionRecordState.PropertyReceiver receiver = this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props);
        this.propertyLoader.nodeLoadProperties(node, receiver);
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"string1", (Object)data.value());
                this.transaction.nodeChangeProperty(node, prop1.propertyKeyId(), (Object)"-string1");
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)1, (Object)data.value());
                this.transaction.nodeChangeProperty(node, prop2.propertyKeyId(), (Object)new Integer(-1));
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)true, (Object)data.value());
                this.transaction.nodeChangeProperty(node, prop3.propertyKeyId(), (Object)false);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        count = 0;
        try (Cursor nodeCursor = ((KernelStatement)this.tx.acquireStatement()).getStoreStatement().acquireSingleNodeCursor(node);){
            nodeCursor.next();
            try (Cursor relationships = ((NodeItem)nodeCursor.get()).relationships(Direction.BOTH);){
                while (relationships.next()) {
                    long rel = ((RelationshipItem)relationships.get()).id();
                    if (rel == rel1) {
                        Assert.assertEquals((long)node, (long)((RelationshipItem)relationships.get()).startNode());
                        Assert.assertEquals((long)relType1, (long)((RelationshipItem)relationships.get()).type());
                    } else if (rel == rel2) {
                        Assert.assertEquals((long)node, (long)((RelationshipItem)relationships.get()).endNode());
                        Assert.assertEquals((long)relType2, (long)((RelationshipItem)relationships.get()).type());
                    } else {
                        throw new IOException();
                    }
                    ++count;
                }
            }
        }
        Assert.assertEquals((long)2L, (long)count);
    }

    private TransactionRecordState.PropertyReceiver newPropertyReceiver(final ArrayMap<Integer, Pair<DefinedProperty, Long>> props) {
        return new TransactionRecordState.PropertyReceiver(){

            public void receive(DefinedProperty property, long propertyRecordId) {
                props.put((Object)property.propertyKeyId(), (Object)Pair.of((Object)property, (Object)propertyRecordId));
            }
        };
    }

    private void validateNodeRel2(long node, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3, long rel1, long rel2, int relType1, int relType2) throws IOException, EntityNotFoundException, RuntimeException {
        Assert.assertTrue((boolean)this.nodeExists(node));
        ArrayMap props = new ArrayMap();
        this.propertyLoader.nodeLoadProperties(node, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"string2", (Object)data.value());
                this.transaction.nodeChangeProperty(node, prop1.propertyKeyId(), (Object)"-string2");
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)2, (Object)data.value());
                this.transaction.nodeChangeProperty(node, prop2.propertyKeyId(), (Object)new Integer(-2));
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)false, (Object)data.value());
                this.transaction.nodeChangeProperty(node, prop3.propertyKeyId(), (Object)true);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        count = 0;
        try (Cursor nodeCursor = ((KernelStatement)this.tx.acquireStatement()).getStoreStatement().acquireSingleNodeCursor(node);){
            nodeCursor.next();
            try (Cursor relationships = ((NodeItem)nodeCursor.get()).relationships(Direction.BOTH);){
                while (relationships.next()) {
                    long rel = ((RelationshipItem)relationships.get()).id();
                    if (rel == rel1) {
                        Assert.assertEquals((long)node, (long)((RelationshipItem)relationships.get()).endNode());
                        Assert.assertEquals((long)relType1, (long)((RelationshipItem)relationships.get()).type());
                    } else if (rel == rel2) {
                        Assert.assertEquals((long)node, (long)((RelationshipItem)relationships.get()).startNode());
                        Assert.assertEquals((long)relType2, (long)((RelationshipItem)relationships.get()).type());
                    } else {
                        throw new IOException();
                    }
                    ++count;
                }
            }
        }
        Assert.assertEquals((long)2L, (long)count);
    }

    /*
     * Exception decompiling
     */
    private boolean nodeExists(long nodeId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void validateRel1(long rel, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3, long firstNode, long secondNode, int relType) throws IOException {
        ArrayMap props = new ArrayMap();
        this.propertyLoader.relLoadProperties(rel, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"string1", (Object)data.value());
                this.transaction.relChangeProperty(rel, prop1.propertyKeyId(), (Object)"-string1");
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)1, (Object)data.value());
                this.transaction.relChangeProperty(rel, prop2.propertyKeyId(), (Object)new Integer(-1));
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)true, (Object)data.value());
                this.transaction.relChangeProperty(rel, prop3.propertyKeyId(), (Object)false);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        this.assertRelationshipData(rel, firstNode, secondNode, relType);
    }

    private void assertRelationshipData(long rel, final long firstNode, final long secondNode, final int relType) {
        try {
            this.storeLayer.relationshipVisit(rel, (RelationshipVisitor)new RelationshipVisitor<RuntimeException>(){

                public void visit(long relId, int type, long startNode, long endNode) {
                    Assert.assertEquals((long)firstNode, (long)startNode);
                    Assert.assertEquals((long)secondNode, (long)endNode);
                    Assert.assertEquals((long)relType, (long)type);
                }
            });
        }
        catch (EntityNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private void validateRel2(long rel, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3, long firstNode, long secondNode, int relType) throws IOException {
        ArrayMap props = new ArrayMap();
        this.propertyLoader.relLoadProperties(rel, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"string2", (Object)data.value());
                this.transaction.relChangeProperty(rel, prop1.propertyKeyId(), (Object)"-string2");
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)2, (Object)data.value());
                this.transaction.relChangeProperty(rel, prop2.propertyKeyId(), (Object)new Integer(-2));
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)false, (Object)data.value());
                this.transaction.relChangeProperty(rel, prop3.propertyKeyId(), (Object)true);
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        this.assertRelationshipData(rel, firstNode, secondNode, relType);
    }

    private void validateRelTypes(int relType1, int relType2) throws IOException {
        Token data = this.rtStore.getToken(relType1);
        Assert.assertEquals((long)relType1, (long)data.id());
        Assert.assertEquals((Object)"relationshiptype1", (Object)data.name());
        data = this.rtStore.getToken(relType2);
        Assert.assertEquals((long)relType2, (long)data.id());
        Assert.assertEquals((Object)"relationshiptype2", (Object)data.name());
        List allData = this.rtStore.getTokens(Integer.MAX_VALUE);
        Assert.assertEquals((long)2L, (long)allData.size());
        for (int i = 0; i < 2; ++i) {
            if (((RelationshipTypeToken)allData.get(i)).id() == relType1) {
                Assert.assertEquals((long)relType1, (long)((RelationshipTypeToken)allData.get(i)).id());
                Assert.assertEquals((Object)"relationshiptype1", (Object)((RelationshipTypeToken)allData.get(i)).name());
                continue;
            }
            if (((RelationshipTypeToken)allData.get(i)).id() == relType2) {
                Assert.assertEquals((long)relType2, (long)((RelationshipTypeToken)allData.get(i)).id());
                Assert.assertEquals((Object)"relationshiptype2", (Object)((RelationshipTypeToken)allData.get(i)).name());
                continue;
            }
            throw new IOException();
        }
    }

    private void deleteRel1(long rel, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3, long firstNode, long secondNode, int relType) throws IOException {
        ArrayMap props = new ArrayMap();
        this.propertyLoader.relLoadProperties(rel, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"-string1", (Object)data.value());
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)-1, (Object)data.value());
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)false, (Object)data.value());
                this.transaction.relRemoveProperty(rel, prop3.propertyKeyId());
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        CountingPropertyReceiver propertyCounter = new CountingPropertyReceiver();
        this.propertyLoader.relLoadProperties(rel, (TransactionRecordState.PropertyReceiver)propertyCounter);
        Assert.assertEquals((long)3L, (long)propertyCounter.count);
        this.assertRelationshipData(rel, firstNode, secondNode, relType);
        this.transaction.relDelete(rel);
        this.assertHasRelationships(firstNode);
        this.assertHasRelationships(secondNode);
    }

    private void deleteRel2(long rel, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3, long firstNode, long secondNode, int relType) throws IOException {
        ArrayMap props = new ArrayMap();
        this.propertyLoader.relLoadProperties(rel, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"-string2", (Object)data.value());
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)-2, (Object)data.value());
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)true, (Object)data.value());
                this.transaction.relRemoveProperty(rel, prop3.propertyKeyId());
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        CountingPropertyReceiver propertyCounter = new CountingPropertyReceiver();
        this.propertyLoader.relLoadProperties(rel, (TransactionRecordState.PropertyReceiver)propertyCounter);
        Assert.assertEquals((long)3L, (long)propertyCounter.count);
        this.assertRelationshipData(rel, firstNode, secondNode, relType);
        this.transaction.relDelete(rel);
        this.assertHasRelationships(firstNode);
        this.assertHasRelationships(secondNode);
    }

    private void assertHasRelationships(long node) {
        try (Cursor nodeCursor = ((KernelStatement)this.tx.acquireStatement()).getStoreStatement().acquireSingleNodeCursor(node);){
            nodeCursor.next();
            RelationshipIterator rels = ((NodeItem)nodeCursor.get()).getRelationships(Direction.BOTH);
            Assert.assertTrue((boolean)rels.hasNext());
        }
    }

    private void deleteNode1(long node, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3) throws IOException {
        ArrayMap props = new ArrayMap();
        this.propertyLoader.nodeLoadProperties(node, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"-string1", (Object)data.value());
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)-1, (Object)data.value());
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)false, (Object)data.value());
                this.transaction.nodeRemoveProperty(node, prop3.propertyKeyId());
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        CountingPropertyReceiver propertyCounter = new CountingPropertyReceiver();
        this.propertyLoader.nodeLoadProperties(node, (TransactionRecordState.PropertyReceiver)propertyCounter);
        Assert.assertEquals((long)3L, (long)propertyCounter.count);
        this.assertHasRelationships(node);
        this.transaction.nodeDelete(node);
    }

    private void deleteNode2(long node, DefinedProperty prop1, DefinedProperty prop2, DefinedProperty prop3) throws IOException {
        ArrayMap props = new ArrayMap();
        this.propertyLoader.nodeLoadProperties(node, this.newPropertyReceiver((ArrayMap<Integer, Pair<DefinedProperty, Long>>)props));
        int count = 0;
        Iterator i$ = props.keySet().iterator();
        while (i$.hasNext()) {
            int keyId = (Integer)i$.next();
            long id = (Long)((Pair)props.get((Object)keyId)).other();
            PropertyRecord record = this.pStore.getRecord(id);
            PropertyBlock block = record.getPropertyBlock(((DefinedProperty)((Pair)props.get((Object)keyId)).first()).propertyKeyId());
            DefinedProperty data = block.newPropertyData(this.pStore);
            if (data.propertyKeyId() == prop1.propertyKeyId()) {
                Assert.assertEquals((Object)"prop1", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)"-string2", (Object)data.value());
            } else if (data.propertyKeyId() == prop2.propertyKeyId()) {
                Assert.assertEquals((Object)"prop2", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)-2, (Object)data.value());
            } else if (data.propertyKeyId() == prop3.propertyKeyId()) {
                Assert.assertEquals((Object)"prop3", (Object)MyPropertyKeyToken.getIndexFor(keyId).name());
                Assert.assertEquals((Object)true, (Object)data.value());
                this.transaction.nodeRemoveProperty(node, prop3.propertyKeyId());
            } else {
                throw new IOException();
            }
            ++count;
        }
        Assert.assertEquals((long)3L, (long)count);
        CountingPropertyReceiver propertyCounter = new CountingPropertyReceiver();
        this.propertyLoader.nodeLoadProperties(node, (TransactionRecordState.PropertyReceiver)propertyCounter);
        Assert.assertEquals((long)3L, (long)propertyCounter.count);
        this.assertHasRelationships(node);
        this.transaction.nodeDelete(node);
    }

    private void testGetRels(long[] relIds) {
        try (StoreStatement statement = this.storeLayer.acquireStatement();){
            for (long relId : relIds) {
                try (Cursor relationship = statement.acquireSingleRelationshipCursor(relId);){
                    Assert.assertFalse((boolean)relationship.next());
                }
            }
        }
    }

    private static class CountingPropertyReceiver
    implements TransactionRecordState.PropertyReceiver {
        private int count;

        private CountingPropertyReceiver() {
        }

        public void receive(DefinedProperty property, long propertyRecordId) {
            ++this.count;
        }
    }

    private static class MyPropertyKeyToken
    extends Token {
        private static Map<String, Token> stringToIndex = new HashMap<String, Token>();
        private static Map<Integer, Token> intToIndex = new HashMap<Integer, Token>();

        protected MyPropertyKeyToken(String key, int keyId) {
            super(key, keyId);
        }

        public static Iterable<Token> index(String key) {
            if (stringToIndex.containsKey(key)) {
                return Collections.singletonList(stringToIndex.get(key));
            }
            return Collections.emptyList();
        }

        public static Token getIndexFor(int index) {
            return intToIndex.get(index);
        }

        public static void add(MyPropertyKeyToken index) {
            stringToIndex.put(index.name(), index);
            intToIndex.put(index.id(), index);
        }
    }
}

