/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.function.Function;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.Pair;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyFactory;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.ThreadingRule;

public class CountsRotationTest {
    private final Label A = DynamicLabel.label((String)"A");
    private final Label B = DynamicLabel.label((String)"B");
    private final Label C = DynamicLabel.label((String)"C");
    @Rule
    public PageCacheRule pcRule = new PageCacheRule();
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();
    @Rule
    public TargetDirectory.TestDirectory testDir = TargetDirectory.testDirForTestWithEphemeralFS((EphemeralFileSystemAbstraction)this.fsRule.get(), this.getClass());
    @Rule
    public ThreadingRule threadingRule = new ThreadingRule();
    private FileSystemAbstraction fs;
    private File dir;
    private GraphDatabaseBuilder dbBuilder;
    private PageCache pageCache;
    private Config emptyConfig;
    private static final String COUNTS_STORE_BASE = "neostore.counts.db";

    @Before
    public void setup() {
        this.fs = this.fsRule.get();
        this.dir = this.testDir.directory("dir").getAbsoluteFile();
        this.dbBuilder = new TestGraphDatabaseFactory().setFileSystem(this.fs).newImpermanentDatabaseBuilder(this.dir);
        this.pageCache = this.pcRule.getPageCache(this.fs);
        this.emptyConfig = new Config();
    }

    @Test
    public void shouldCreateEmptyCountsTrackerStoreWhenCreatingDatabase() throws IOException {
        CountsTracker store;
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbBuilder.newGraphDatabase();
        db.shutdown();
        Assert.assertTrue((boolean)this.fs.fileExists(this.alphaStoreFile()));
        Assert.assertFalse((boolean)this.fs.fileExists(this.betaStoreFile()));
        try (Lifespan life = new Lifespan(new Lifecycle[0]);){
            store = (CountsTracker)life.add((Lifecycle)this.createCountsTracker(this.pageCache));
            Assert.assertEquals((long)1L, (long)store.txId());
            Assert.assertEquals((long)0L, (long)store.minorVersion());
            Assert.assertEquals((long)0L, (long)store.totalEntriesStored());
            Assert.assertEquals((long)0L, (long)this.allRecords((CountsVisitor.Visitable)store).size());
        }
        life = new Lifespan(new Lifecycle[0]);
        var3_3 = null;
        try {
            store = (CountsTracker)life.add((Lifecycle)this.createCountsTracker(this.pageCache));
            Assert.assertEquals((long)1L, (long)store.txId());
            Assert.assertEquals((long)0L, (long)store.minorVersion());
            Assert.assertEquals((long)0L, (long)store.totalEntriesStored());
            Assert.assertEquals((long)0L, (long)this.allRecords((CountsVisitor.Visitable)store).size());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (life != null) {
                if (var3_3 != null) {
                    try {
                        life.close();
                    }
                    catch (Throwable x2) {
                        var3_3.addSuppressed(x2);
                    }
                } else {
                    life.close();
                }
            }
        }
    }

    @Test
    public void rotationShouldNotCauseUnmappedFileProblem() throws IOException {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbBuilder.newGraphDatabase();
        CountsTracker countStore = ((NeoStores)db.getDependencyResolver().resolveDependency(NeoStores.class)).getCounts();
        AtomicBoolean workerContinueFlag = new AtomicBoolean(true);
        AtomicLong lookupsCounter = new AtomicLong();
        int rotations = 100;
        for (int i = 0; i < 5; ++i) {
            this.threadingRule.execute(CountsRotationTest.countStoreLookup(workerContinueFlag, lookupsCounter), countStore);
        }
        long startTxId = countStore.txId();
        for (int i = 1; i < rotations || lookupsCounter.get() == 0L; ++i) {
            try (Transaction tx = db.beginTx();){
                db.createNode(new Label[]{this.B});
                tx.success();
            }
            this.checkPoint(db);
        }
        workerContinueFlag.set(false);
        Assert.assertEquals((String)"Should perform at least 100 rotations.", (long)rotations, (long)Math.min((long)rotations, countStore.txId() - startTxId));
        Assert.assertTrue((String)"Should perform more then 0 lookups without exceptions.", (lookupsCounter.get() > 0L ? 1 : 0) != 0);
    }

    private static Function<CountsTracker, Void> countStoreLookup(final AtomicBoolean workerContinueFlag, final AtomicLong lookups) {
        return new Function<CountsTracker, Void>(){

            public Void apply(CountsTracker countsTracker) {
                while (workerContinueFlag.get()) {
                    Register.DoubleLongRegister register = Registers.newDoubleLongRegister();
                    countsTracker.get((CountsKey)CountsKeyFactory.nodeKey((int)0), register);
                    lookups.incrementAndGet();
                }
                return null;
            }
        };
    }

    @Test
    public void shouldRotateCountsStoreWhenClosingTheDatabase() throws IOException {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbBuilder.newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.createNode(new Label[]{this.A});
            tx.success();
        }
        db.shutdown();
        Assert.assertTrue((boolean)this.fs.fileExists(this.alphaStoreFile()));
        Assert.assertTrue((boolean)this.fs.fileExists(this.betaStoreFile()));
        var3_3 = null;
        try (Lifespan life = new Lifespan(new Lifecycle[0]);){
            CountsTracker store = (CountsTracker)life.add((Lifecycle)this.createCountsTracker(this.pageCache));
            Assert.assertEquals((long)3L, (long)store.txId());
            Assert.assertEquals((long)0L, (long)store.minorVersion());
            Assert.assertEquals((long)2L, (long)store.totalEntriesStored());
            Assert.assertEquals((long)2L, (long)this.allRecords((CountsVisitor.Visitable)store).size());
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void shouldRotateCountsStoreWhenRotatingLog() throws IOException {
        GraphDatabaseAPI db = (GraphDatabaseAPI)this.dbBuilder.newGraphDatabase();
        try (Transaction tx = db.beginTx();){
            db.createNode(new Label[]{this.B});
            tx.success();
        }
        this.checkPoint(db);
        tx = db.beginTx();
        var3_3 = null;
        try {
            db.createNode(new Label[]{this.C});
            tx.success();
        }
        catch (Throwable x2) {
            var3_3 = x2;
            throw x2;
        }
        finally {
            if (tx != null) {
                if (var3_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var3_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        Assert.assertTrue((boolean)this.fs.fileExists(this.alphaStoreFile()));
        Assert.assertTrue((boolean)this.fs.fileExists(this.betaStoreFile()));
        PageCache pageCache = (PageCache)db.getDependencyResolver().resolveDependency(PageCache.class);
        try (Lifespan life = new Lifespan(new Lifecycle[0]);){
            CountsTracker store = (CountsTracker)life.add((Lifecycle)this.createCountsTracker(pageCache));
            Assert.assertEquals((long)3L, (long)store.txId());
            Assert.assertEquals((long)0L, (long)store.minorVersion());
            Assert.assertEquals((long)2L, (long)store.totalEntriesStored());
            Assert.assertEquals((long)2L, (long)this.allRecords((CountsVisitor.Visitable)store).size());
        }
        CountsTracker tracker = ((NeoStores)db.getDependencyResolver().resolveDependency(NeoStores.class)).getCounts();
        Assert.assertEquals((long)2L, (long)tracker.nodeCount(-1, Registers.newDoubleLongRegister()).readSecond());
        LabelTokenHolder holder = (LabelTokenHolder)db.getDependencyResolver().resolveDependency(LabelTokenHolder.class);
        int labelId = holder.getIdByName(this.C.name());
        Assert.assertEquals((long)1L, (long)tracker.nodeCount(labelId, Registers.newDoubleLongRegister()).readSecond());
        db.shutdown();
    }

    private CountsTracker createCountsTracker(PageCache pageCache) {
        return new CountsTracker((LogProvider)NullLogProvider.getInstance(), this.fs, pageCache, this.emptyConfig, new File(this.dir.getPath(), COUNTS_STORE_BASE));
    }

    private void checkPoint(GraphDatabaseAPI db) throws IOException {
        SimpleTriggerInfo triggerInfo = new SimpleTriggerInfo("test");
        ((CheckPointer)db.getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)triggerInfo);
    }

    private File alphaStoreFile() {
        return new File(this.dir.getPath(), "neostore.counts.db.a");
    }

    private File betaStoreFile() {
        return new File(this.dir.getPath(), "neostore.counts.db.b");
    }

    private Collection<Pair<? extends CountsKey, Long>> allRecords(CountsVisitor.Visitable store) {
        final ArrayList<Pair<? extends CountsKey, Long>> records = new ArrayList<Pair<? extends CountsKey, Long>>();
        store.accept(new CountsVisitor(){

            public void visitNodeCount(int labelId, long count) {
                records.add(Pair.of((Object)CountsKeyFactory.nodeKey((int)labelId), (Object)count));
            }

            public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count) {
                records.add(Pair.of((Object)CountsKeyFactory.relationshipKey((int)startLabelId, (int)typeId, (int)endLabelId), (Object)count));
            }

            public void visitIndexStatistics(int labelId, int propertyKeyId, long updates, long size) {
                records.add(Pair.of((Object)CountsKeyFactory.indexStatisticsKey((int)labelId, (int)propertyKeyId), (Object)size));
            }

            public void visitIndexSample(int labelId, int propertyKeyId, long unique, long size) {
                records.add(Pair.of((Object)CountsKeyFactory.indexSampleKey((int)labelId, (int)propertyKeyId), (Object)size));
            }
        });
        return records;
    }
}

