/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.function.Supplier;
import org.neo4j.helpers.FakeClock;
import org.neo4j.kernel.CommunityIdTypeConfigurationProvider;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.IdTypeConfigurationProvider;
import org.neo4j.kernel.impl.api.KernelTransactionsSnapshot;
import org.neo4j.kernel.impl.store.id.BufferingIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdReuseEligibility;
import org.neo4j.test.EphemeralFileSystemRule;

public class BufferingIdGeneratorFactoryTest {
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    @Test
    public void shouldDelayFreeingOfAggressivelyReusedIds() throws Exception {
        MockedIdGeneratorFactory actual = new MockedIdGeneratorFactory();
        CommunityIdTypeConfigurationProvider idTypeConfigurationProvider = new CommunityIdTypeConfigurationProvider();
        BufferingIdGeneratorFactory bufferingIdGeneratorFactory = new BufferingIdGeneratorFactory((IdGeneratorFactory)actual, (IdTypeConfigurationProvider)idTypeConfigurationProvider);
        ControllableSnapshotSupplier boundaries = new ControllableSnapshotSupplier();
        IdGenerator idGenerator = bufferingIdGeneratorFactory.open(new File("doesnt-matter"), 10, IdType.STRING_BLOCK, 0L);
        bufferingIdGeneratorFactory.initialize((Supplier)boundaries, IdReuseEligibility.ALWAYS);
        idGenerator.freeId(7L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{actual.get(IdType.STRING_BLOCK)});
        bufferingIdGeneratorFactory.maintenance();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{actual.get(IdType.STRING_BLOCK)});
        boundaries.setMostRecentlyReturnedSnapshotToAllClosed();
        bufferingIdGeneratorFactory.maintenance();
        ((IdGenerator)Mockito.verify((Object)actual.get(IdType.STRING_BLOCK))).freeId(7L);
    }

    @Test
    public void shouldDelayFreeingOfAggressivelyReusedIdsConsideringTimeAsWell() throws Exception {
        MockedIdGeneratorFactory actual = new MockedIdGeneratorFactory();
        final FakeClock clock = new FakeClock();
        final long safeZone = TimeUnit.MINUTES.toMillis(1L);
        BufferingIdGeneratorFactory bufferingIdGeneratorFactory = new BufferingIdGeneratorFactory((IdGeneratorFactory)actual, (IdTypeConfigurationProvider)new CommunityIdTypeConfigurationProvider());
        ControllableSnapshotSupplier boundaries = new ControllableSnapshotSupplier();
        IdGenerator idGenerator = bufferingIdGeneratorFactory.open(new File("doesnt-matter"), 10, IdType.STRING_BLOCK, 0L);
        bufferingIdGeneratorFactory.initialize((Supplier)boundaries, new IdReuseEligibility(){

            public boolean isEligible(KernelTransactionsSnapshot t) {
                return clock.currentTimeMillis() - t.snapshotTime() >= safeZone;
            }
        });
        idGenerator.freeId(7L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{actual.get(IdType.STRING_BLOCK)});
        bufferingIdGeneratorFactory.maintenance();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{actual.get(IdType.STRING_BLOCK)});
        boundaries.setMostRecentlyReturnedSnapshotToAllClosed();
        bufferingIdGeneratorFactory.maintenance();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{actual.get(IdType.STRING_BLOCK)});
        clock.forward(70L, TimeUnit.SECONDS);
        bufferingIdGeneratorFactory.maintenance();
        ((IdGenerator)Mockito.verify((Object)actual.get(IdType.STRING_BLOCK))).freeId(7L);
    }

    private static class MockedIdGeneratorFactory
    implements IdGeneratorFactory {
        private final IdGenerator[] generators = new IdGenerator[IdType.values().length];

        private MockedIdGeneratorFactory() {
        }

        public IdGenerator open(File filename, IdType idType, long highId) {
            return this.open(filename, 0, idType, highId);
        }

        public IdGenerator open(File filename, int grabSize, IdType idType, long highId) {
            IdGenerator idGenerator = (IdGenerator)Mockito.mock(IdGenerator.class);
            this.generators[idType.ordinal()] = idGenerator;
            return idGenerator;
        }

        public void create(File filename, long highId, boolean throwIfFileExists) {
        }

        public IdGenerator get(IdType idType) {
            return this.generators[idType.ordinal()];
        }
    }

    private static class ControllableSnapshotSupplier
    implements Supplier<KernelTransactionsSnapshot> {
        KernelTransactionsSnapshot mostRecentlyReturned;

        private ControllableSnapshotSupplier() {
        }

        public KernelTransactionsSnapshot get() {
            this.mostRecentlyReturned = (KernelTransactionsSnapshot)Mockito.mock(KernelTransactionsSnapshot.class);
            return this.mostRecentlyReturned;
        }

        void setMostRecentlyReturnedSnapshotToAllClosed() {
            Mockito.when((Object)this.mostRecentlyReturned.allClosed()).thenReturn((Object)true);
        }
    }
}

