/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.mockito.Mockito;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.logging.SimpleLogService;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.storemigration.legacylogs.LegacyLogs;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.monitoring.SilentMigrationProgressMonitor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.RandomRule;
import org.neo4j.test.TargetDirectory;

public class StoreMigratorTest {
    private final FileSystemAbstraction fs = new DefaultFileSystemAbstraction();
    private final TargetDirectory.TestDirectory directory = TargetDirectory.testDirForTest(this.getClass());
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    private final RandomRule random = new RandomRule();
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.directory).around((TestRule)this.pageCacheRule).around((TestRule)this.random);

    @Test
    public void shouldExtractTransactionInformationFromMetaDataStore() throws Exception {
        long txId = 42L;
        long checksum = 123456789123456789L;
        long timestamp = 919191919191919191L;
        TransactionId expected = new TransactionId(txId, checksum, timestamp);
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs);
        File storeDir = this.directory.graphDbDir();
        File neoStore = new File(storeDir, "neostore");
        neoStore.createNewFile();
        MigrationProgressMonitor progressMonitor = (MigrationProgressMonitor)Mockito.mock(MigrationProgressMonitor.class);
        Config config = (Config)Mockito.mock(Config.class);
        LogService logService = (LogService)Mockito.mock(LogService.class);
        MetaDataStore.setRecord((PageCache)pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_ID, (long)txId);
        MetaDataStore.setRecord((PageCache)pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM, (long)checksum);
        MetaDataStore.setRecord((PageCache)pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_COMMIT_TIMESTAMP, (long)timestamp);
        StoreMigrator migrator = new StoreMigrator(progressMonitor, this.fs, pageCache, config, logService);
        TransactionId actual = migrator.extractTransactionIdInformation(neoStore, storeDir, txId);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldExtractTransactionInformationFromLegacyLogsWhenCantFindInStore() throws Exception {
        long txId = 42L;
        long checksum = 123456789123456789L;
        long timestamp = 919191919191919191L;
        TransactionId expected = new TransactionId(txId, checksum, timestamp);
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs);
        File storeDir = this.directory.graphDbDir();
        File neoStore = new File(storeDir, "neostore");
        neoStore.createNewFile();
        MigrationProgressMonitor progressMonitor = (MigrationProgressMonitor)Mockito.mock(MigrationProgressMonitor.class);
        Config config = (Config)Mockito.mock(Config.class);
        LogService logService = (LogService)Mockito.mock(LogService.class);
        LegacyLogs legacyLogs = (LegacyLogs)Mockito.mock(LegacyLogs.class);
        Mockito.when((Object)legacyLogs.getTransactionInformation(storeDir, txId)).thenReturn((Object)expected);
        StoreMigrator migrator = new StoreMigrator(progressMonitor, this.fs, pageCache, config, logService, legacyLogs);
        TransactionId actual = migrator.extractTransactionIdInformation(neoStore, storeDir, txId);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldGenerateTransactionInformationAsLastOption() throws Exception {
        long txId = 42L;
        TransactionId expected = new TransactionId(txId, -1L, 1L);
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs);
        File storeDir = this.directory.graphDbDir();
        File neoStore = new File(storeDir, "neostore");
        neoStore.createNewFile();
        MigrationProgressMonitor progressMonitor = (MigrationProgressMonitor)Mockito.mock(MigrationProgressMonitor.class);
        Config config = (Config)Mockito.mock(Config.class);
        AssertableLogProvider logProvider = new AssertableLogProvider();
        SimpleLogService logService = new SimpleLogService((LogProvider)NullLogProvider.getInstance(), (LogProvider)logProvider);
        LegacyLogs legacyLogs = (LegacyLogs)Mockito.mock(LegacyLogs.class);
        Assert.assertEquals((long)-1L, (long)MetaDataStore.getRecord((PageCache)pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_ID));
        Assert.assertEquals((long)-1L, (long)MetaDataStore.getRecord((PageCache)pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM));
        Assert.assertEquals((long)-1L, (long)MetaDataStore.getRecord((PageCache)pageCache, (File)neoStore, (MetaDataStore.Position)MetaDataStore.Position.LAST_TRANSACTION_COMMIT_TIMESTAMP));
        Mockito.when((Object)legacyLogs.getTransactionInformation(storeDir, txId)).thenThrow(new Class[]{NoSuchTransactionException.class});
        StoreMigrator migrator = new StoreMigrator(progressMonitor, this.fs, pageCache, config, (LogService)logService, legacyLogs);
        TransactionId actual = migrator.extractTransactionIdInformation(neoStore, storeDir, txId);
        logProvider.assertContainsMessageContaining("Extraction of transaction " + txId + " from legacy logs failed.");
        Assert.assertEquals((long)expected.transactionId(), (long)actual.transactionId());
        Assert.assertEquals((long)1L, (long)actual.checksum());
        Assert.assertEquals((long)expected.commitTimestamp(), (long)actual.commitTimestamp());
    }

    @Test
    public void writeAndReadLastTxInformation() throws IOException {
        StoreMigrator migrator = this.newStoreMigrator();
        TransactionId writtenTxId = new TransactionId(this.random.nextLong(), this.random.nextLong(), this.random.nextLong());
        migrator.writeLastTxInformation(this.directory.graphDbDir(), writtenTxId);
        TransactionId readTxId = migrator.readLastTxInformation(this.directory.graphDbDir());
        Assert.assertEquals((Object)writtenTxId, (Object)readTxId);
    }

    @Test
    public void writeAndReadLastTxLogPosition() throws IOException {
        StoreMigrator migrator = this.newStoreMigrator();
        LogPosition writtenLogPosition = new LogPosition(this.random.nextLong(), this.random.nextLong());
        migrator.writeLastTxLogPosition(this.directory.graphDbDir(), writtenLogPosition);
        LogPosition readLogPosition = migrator.readLastTxLogPosition(this.directory.graphDbDir());
        Assert.assertEquals((Object)writtenLogPosition, (Object)readLogPosition);
    }

    private StoreMigrator newStoreMigrator() {
        return new StoreMigrator((MigrationProgressMonitor)new SilentMigrationProgressMonitor(), this.fs, this.pageCacheRule.getPageCache(this.fs), new Config(), (LogService)NullLogService.getInstance());
    }
}

