/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.command;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.CommandReader;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV1_9;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV2_0;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV2_1;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV2_2_10;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogCommandReaderV2_2_4;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogNeoCommandReaderV2_2;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;

public class PhysicalLogCommandReadersTest {
    private static final long ID = 42L;
    private static final byte IN_USE_FLAG = Record.IN_USE.byteValue();
    private static final short TYPE = -32727;
    private static final int TYPE_AS_INT = 32809;
    private static final long NEXT = 42L;
    private static final long FIRST_OUT = 42L;
    private static final long FIRST_IN = 42L;
    private static final long FIRST_LOOP = 42L;
    private static final long OWNING_NODE = 42L;

    @Test
    public void readRelGroupWithHugeTypeInV1_9() {
        PhysicalLogCommandReadersTest.assertDoesNotKnowAboutRelGroups((CommandReader)new PhysicalLogCommandReaderV1_9());
    }

    @Test
    public void readRelGroupWithHugeTypeInV2_0() {
        PhysicalLogCommandReadersTest.assertDoesNotKnowAboutRelGroups((CommandReader)new PhysicalLogCommandReaderV2_0());
    }

    @Test
    public void readRelGroupWithHugeTypeInV2_1() throws IOException {
        this.assertCanReadRelGroup((CommandReader)new PhysicalLogCommandReaderV2_1());
    }

    @Test
    public void readRelGroupWithHugeTypeInV2_2() throws IOException {
        this.assertCanReadRelGroup((CommandReader)new PhysicalLogNeoCommandReaderV2_2());
    }

    @Test
    public void readRelGroupWithHugeTypeInV2_2_4() throws IOException {
        this.assertCanReadRelGroup((CommandReader)new PhysicalLogCommandReaderV2_2_4());
    }

    @Test
    public void readRelGroupWithHugeTypeInV2_2_10() throws IOException {
        this.assertCanReadRelGroup((CommandReader)new PhysicalLogCommandReaderV2_2_10());
    }

    private static void assertDoesNotKnowAboutRelGroups(CommandReader reader) {
        try {
            reader.read(PhysicalLogCommandReadersTest.channelWithRelGroupRecord());
            Assert.fail((String)"Exception expected");
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"Unknown command type[9]", (Object)e.getMessage());
        }
    }

    private void assertCanReadRelGroup(CommandReader reader) throws IOException {
        Command command = reader.read(PhysicalLogCommandReadersTest.channelWithRelGroupRecord());
        PhysicalLogCommandReadersTest.assertValidRelGroupCommand(command);
    }

    private static void assertValidRelGroupCommand(Command command) {
        Assert.assertThat((Object)command, (Matcher)Matchers.instanceOf(Command.RelationshipGroupCommand.class));
        Command.RelationshipGroupCommand relGroupCommand = (Command.RelationshipGroupCommand)command;
        RelationshipGroupRecord record = relGroupCommand.getRecord();
        Assert.assertEquals((long)42L, (long)record.getId());
        if (IN_USE_FLAG == Record.IN_USE.byteValue()) {
            Assert.assertTrue((boolean)record.inUse());
        } else if (IN_USE_FLAG == Record.NOT_IN_USE.byteValue()) {
            Assert.assertFalse((boolean)record.inUse());
        } else {
            throw new IllegalStateException("Illegal inUse flag: " + IN_USE_FLAG);
        }
        Assert.assertEquals((long)32809L, (long)record.getType());
        Assert.assertEquals((long)42L, (long)record.getNext());
        Assert.assertEquals((long)42L, (long)record.getFirstOut());
        Assert.assertEquals((long)42L, (long)record.getFirstIn());
        Assert.assertEquals((long)42L, (long)record.getNext());
        Assert.assertEquals((long)42L, (long)record.getOwningNode());
    }

    private static ReadableLogChannel channelWithRelGroupRecord() throws IOException {
        return PhysicalLogCommandReadersTest.channelWithRelGroupRecord(42L, IN_USE_FLAG, (short)-32727, 42L, 42L, 42L, 42L, 42L);
    }

    private static ReadableLogChannel channelWithRelGroupRecord(long id, byte inUse, short type, long next, long firstOut, long firstIn, long firstLoop, long owningNode) throws IOException {
        ReadableLogChannel channel = (ReadableLogChannel)Mockito.mock(ReadableLogChannel.class);
        Mockito.when((Object)channel.get()).thenReturn((Object)9).thenReturn((Object)inUse);
        Mockito.when((Object)channel.getLong()).thenReturn((Object)id).thenReturn((Object)next).thenReturn((Object)firstOut).thenReturn((Object)firstIn).thenReturn((Object)firstLoop).thenReturn((Object)owningNode);
        Mockito.when((Object)channel.getShort()).thenReturn((Object)type);
        return channel;
    }
}

