/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.BatchingTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.Commitment;
import org.neo4j.kernel.impl.transaction.log.InMemoryLogChannel;
import org.neo4j.kernel.impl.transaction.log.InMemoryVersionableLogChannel;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.impl.util.SynchronizedArrayIdOrderingQueue;
import org.neo4j.kernel.lifecycle.LifeRule;
import org.neo4j.test.CleanupRule;

public class BatchingTransactionAppenderTest {
    @Rule
    public final LifeRule life = new LifeRule();
    private final InMemoryVersionableLogChannel channel = new InMemoryVersionableLogChannel();
    private final LogAppendEvent logAppendEvent = LogAppendEvent.NULL;
    private final KernelHealth kernelHealth = (KernelHealth)Mockito.mock(KernelHealth.class);
    private final LogFile logFile = (LogFile)Mockito.mock(LogFile.class);
    private final TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
    private final TransactionMetadataCache positionCache = new TransactionMetadataCache(10, 10);
    @Rule
    public final CleanupRule cleanup = new CleanupRule();

    @Test
    public void shouldAppendTransactions() throws Exception {
        Mockito.when((Object)this.logFile.getWriter()).thenReturn((Object)this.channel);
        long txId = 15L;
        Mockito.when((Object)this.transactionIdStore.nextCommittingTransactionId()).thenReturn((Object)txId);
        TransactionAppender appender = (TransactionAppender)this.life.add(new BatchingTransactionAppender(this.logFile, LogRotation.NO_ROTATION, this.positionCache, this.transactionIdStore, IdOrderingQueue.BYPASS, this.kernelHealth));
        this.life.start();
        PhysicalTransactionRepresentation transaction = new PhysicalTransactionRepresentation(this.singleCreateNodeCommand());
        byte[] additionalHeader = new byte[]{1, 2, 5};
        int masterId = 2;
        boolean authorId = true;
        long timeStarted = 12345L;
        long latestCommittedTxWhenStarted = 4545L;
        long timeCommitted = 12355L;
        transaction.setHeader(additionalHeader, 2, 1, 12345L, 4545L, 12355L, -1);
        appender.append((TransactionRepresentation)transaction, this.logAppendEvent);
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader();
        try (PhysicalTransactionCursor reader = new PhysicalTransactionCursor((ReadableLogChannel)this.channel, (LogEntryReader)logEntryReader);){
            reader.next();
            TransactionRepresentation tx = reader.get().getTransactionRepresentation();
            Assert.assertArrayEquals((byte[])additionalHeader, (byte[])tx.additionalHeader());
            Assert.assertEquals((long)2L, (long)tx.getMasterId());
            Assert.assertEquals((long)1L, (long)tx.getAuthorId());
            Assert.assertEquals((long)12345L, (long)tx.getTimeStarted());
            Assert.assertEquals((long)12355L, (long)tx.getTimeCommitted());
            Assert.assertEquals((long)4545L, (long)tx.getLatestCommittedTxWhenStarted());
        }
    }

    @Test
    public void shouldAppendCommittedTransactions() throws Exception {
        Mockito.when((Object)this.logFile.getWriter()).thenReturn((Object)this.channel);
        long nextTxId = 15L;
        Mockito.when((Object)this.transactionIdStore.nextCommittingTransactionId()).thenReturn((Object)nextTxId);
        TransactionAppender appender = (TransactionAppender)this.life.add(new BatchingTransactionAppender(this.logFile, LogRotation.NO_ROTATION, this.positionCache, this.transactionIdStore, IdOrderingQueue.BYPASS, this.kernelHealth));
        this.life.start();
        byte[] additionalHeader = new byte[]{1, 2, 5};
        int masterId = 2;
        boolean authorId = true;
        long timeStarted = 12345L;
        long latestCommittedTxWhenStarted = nextTxId - 5L;
        long timeCommitted = 12355L;
        PhysicalTransactionRepresentation transactionRepresentation = new PhysicalTransactionRepresentation(this.singleCreateNodeCommand());
        transactionRepresentation.setHeader(additionalHeader, 2, 1, 12345L, latestCommittedTxWhenStarted, 12355L, -1);
        LogEntryStart start = new LogEntryStart(0, 0, 0L, latestCommittedTxWhenStarted, null, LogPosition.UNSPECIFIED);
        OnePhaseCommit commit = new OnePhaseCommit(nextTxId, 0L);
        CommittedTransactionRepresentation transaction = new CommittedTransactionRepresentation(start, (TransactionRepresentation)transactionRepresentation, (LogEntryCommit)commit);
        appender.append(transaction.getTransactionRepresentation(), transaction.getCommitEntry().getTxId());
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader();
        try (PhysicalTransactionCursor reader = new PhysicalTransactionCursor((ReadableLogChannel)this.channel, (LogEntryReader)logEntryReader);){
            reader.next();
            TransactionRepresentation result = reader.get().getTransactionRepresentation();
            Assert.assertArrayEquals((byte[])additionalHeader, (byte[])result.additionalHeader());
            Assert.assertEquals((long)2L, (long)result.getMasterId());
            Assert.assertEquals((long)1L, (long)result.getAuthorId());
            Assert.assertEquals((long)12345L, (long)result.getTimeStarted());
            Assert.assertEquals((long)12355L, (long)result.getTimeCommitted());
            Assert.assertEquals((long)latestCommittedTxWhenStarted, (long)result.getLatestCommittedTxWhenStarted());
        }
    }

    @Test
    public void shouldNotAppendCommittedTransactionsWhenTooFarAhead() throws Exception {
        InMemoryLogChannel channel = new InMemoryLogChannel();
        Mockito.when((Object)this.logFile.getWriter()).thenReturn((Object)channel);
        TransactionAppender appender = (TransactionAppender)this.life.add(new BatchingTransactionAppender(this.logFile, LogRotation.NO_ROTATION, this.positionCache, this.transactionIdStore, IdOrderingQueue.BYPASS, this.kernelHealth));
        this.life.start();
        byte[] additionalHeader = new byte[]{1, 2, 5};
        int masterId = 2;
        boolean authorId = true;
        long timeStarted = 12345L;
        long latestCommittedTxWhenStarted = 4545L;
        long timeCommitted = 12355L;
        PhysicalTransactionRepresentation transactionRepresentation = new PhysicalTransactionRepresentation(this.singleCreateNodeCommand());
        transactionRepresentation.setHeader(additionalHeader, 2, 1, 12345L, 4545L, 12355L, -1);
        Mockito.when((Object)this.transactionIdStore.getLastCommittedTransactionId()).thenReturn((Object)4545L);
        LogEntryStart start = new LogEntryStart(0, 0, 0L, 4545L, null, LogPosition.UNSPECIFIED);
        OnePhaseCommit commit = new OnePhaseCommit(4547L, 0L);
        CommittedTransactionRepresentation transaction = new CommittedTransactionRepresentation(start, (TransactionRepresentation)transactionRepresentation, (LogEntryCommit)commit);
        try {
            appender.append(transaction.getTransactionRepresentation(), transaction.getCommitEntry().getTxId());
            Assert.fail((String)"should have thrown");
        }
        catch (Throwable e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"to be applied, but appending it ended up generating an"));
        }
    }

    @Test
    public void shouldNotCallTransactionCommittedOnFailedAppendedTransaction() throws Exception {
        long txId = 3L;
        String failureMessage = "Forces a failure";
        WritableLogChannel channel = (WritableLogChannel)Mockito.spy((Object)new InMemoryLogChannel());
        IOException failure = new IOException(failureMessage);
        Mockito.when((Object)channel.putInt(Matchers.anyInt())).thenThrow(new Throwable[]{failure});
        Mockito.when((Object)this.logFile.getWriter()).thenReturn((Object)channel);
        Mockito.when((Object)this.transactionIdStore.nextCommittingTransactionId()).thenReturn((Object)txId);
        Mockito.reset((Object[])new KernelHealth[]{this.kernelHealth});
        TransactionAppender appender = (TransactionAppender)this.life.add(new BatchingTransactionAppender(this.logFile, LogRotation.NO_ROTATION, this.positionCache, this.transactionIdStore, IdOrderingQueue.BYPASS, this.kernelHealth));
        this.life.start();
        TransactionRepresentation transaction = (TransactionRepresentation)Mockito.mock(TransactionRepresentation.class);
        Mockito.when((Object)transaction.additionalHeader()).thenReturn((Object)new byte[0]);
        try {
            appender.append(transaction, this.logAppendEvent);
            Assert.fail((String)"Expected append to fail. Something is wrong with the test itself");
        }
        catch (IOException e) {
            Assert.assertSame((Object)failure, (Object)e);
            ((TransactionIdStore)Mockito.verify((Object)this.transactionIdStore, (VerificationMode)Mockito.times((int)1))).nextCommittingTransactionId();
            ((TransactionIdStore)Mockito.verify((Object)this.transactionIdStore, (VerificationMode)Mockito.times((int)1))).transactionClosed(Matchers.eq((long)txId), Matchers.anyLong(), Matchers.anyLong());
            ((KernelHealth)Mockito.verify((Object)this.kernelHealth)).panic((Throwable)failure);
        }
    }

    @Test
    public void shouldNotCallTransactionCommittedOnFailedForceLogToDisk() throws Exception {
        long txId = 3L;
        String failureMessage = "Forces a failure";
        WritableLogChannel channel = (WritableLogChannel)Mockito.spy((Object)new InMemoryLogChannel());
        IOException failure = new IOException(failureMessage);
        final Flushable flushable = (Flushable)Mockito.mock(Flushable.class);
        ((WritableLogChannel)Mockito.doAnswer((Answer)new Answer<Flushable>(){

            public Flushable answer(InvocationOnMock invocation) throws Throwable {
                invocation.callRealMethod();
                return flushable;
            }
        }).when((Object)channel)).emptyBufferIntoChannelAndClearIt();
        ((Flushable)Mockito.doThrow((Throwable)failure).when((Object)flushable)).flush();
        LogFile logFile = (LogFile)Mockito.mock(LogFile.class);
        Mockito.when((Object)logFile.getWriter()).thenReturn((Object)channel);
        TransactionMetadataCache metadataCache = new TransactionMetadataCache(10, 10);
        TransactionIdStore transactionIdStore = (TransactionIdStore)Mockito.mock(TransactionIdStore.class);
        Mockito.when((Object)transactionIdStore.nextCommittingTransactionId()).thenReturn((Object)txId);
        Mockito.reset((Object[])new KernelHealth[]{this.kernelHealth});
        TransactionAppender appender = (TransactionAppender)this.life.add(new BatchingTransactionAppender(logFile, LogRotation.NO_ROTATION, metadataCache, transactionIdStore, IdOrderingQueue.BYPASS, this.kernelHealth));
        this.life.start();
        TransactionRepresentation transaction = (TransactionRepresentation)Mockito.mock(TransactionRepresentation.class);
        Mockito.when((Object)transaction.additionalHeader()).thenReturn((Object)new byte[0]);
        try {
            appender.append(transaction, this.logAppendEvent);
            Assert.fail((String)"Expected append to fail. Something is wrong with the test itself");
        }
        catch (IOException e) {
            Assert.assertSame((Object)failure, (Object)e);
            ((TransactionIdStore)Mockito.verify((Object)transactionIdStore, (VerificationMode)Mockito.times((int)1))).nextCommittingTransactionId();
            ((TransactionIdStore)Mockito.verify((Object)transactionIdStore, (VerificationMode)Mockito.times((int)1))).transactionClosed(Matchers.eq((long)txId), Matchers.anyLong(), Matchers.anyLong());
            ((KernelHealth)Mockito.verify((Object)this.kernelHealth)).panic((Throwable)failure);
        }
    }

    @Test
    public void shouldOrderTransactionsMakingLegacyIndexChanges() throws Exception {
        InMemoryLogChannel channel = new InMemoryLogChannel();
        Mockito.when((Object)this.logFile.getWriter()).thenReturn((Object)channel);
        Mockito.when((Object)this.transactionIdStore.nextCommittingTransactionId()).thenReturn((Object)1L, (Object[])new Long[]{2L, 3L, 4L, 5L});
        SynchronizedArrayIdOrderingQueue legacyIndexOrdering = new SynchronizedArrayIdOrderingQueue(5);
        TransactionAppender appender = (TransactionAppender)this.life.add(new BatchingTransactionAppender(this.logFile, LogRotation.NO_ROTATION, this.positionCache, this.transactionIdStore, (IdOrderingQueue)legacyIndexOrdering, this.kernelHealth));
        this.life.start();
        boolean[] transactions = new boolean[]{true, false, true, false, true};
        Future[] committers = this.committersStartYourEngines(appender, transactions);
        boolean[] completed = new boolean[transactions.length];
        for (int i = 0; i < transactions.length; ++i) {
            if (transactions[i]) continue;
            Assert.assertNotNull((Object)this.tryComplete(committers[i], 1000));
            completed[i] = true;
        }
        while (this.anyBoolean(completed, false)) {
            Long doneTx = null;
            for (int attempt = 0; attempt < 5 && doneTx == null; ++attempt) {
                for (int i = 0; i < completed.length; ++i) {
                    Commitment commitment;
                    if (completed[i] || (commitment = this.tryComplete(committers[i], 100)) == null) continue;
                    Assert.assertNull((String)"Multiple legacy index transactions seems to have moved on from append at the same time", (Object)doneTx);
                    doneTx = commitment.transactionId();
                    completed[i] = true;
                }
            }
            Assert.assertNotNull((String)"None done this round", doneTx);
            legacyIndexOrdering.removeChecked(doneTx.longValue());
        }
    }

    @Test
    public void shouldCloseTransactionThatWasAppendedAndMarkedAsCommittedButFailedAfterThat() throws Exception {
        long txId = 3L;
        String failureMessage = "Forces a failure";
        InMemoryLogChannel channel = new InMemoryLogChannel();
        Mockito.when((Object)this.logFile.getWriter()).thenReturn((Object)channel);
        Mockito.when((Object)this.transactionIdStore.nextCommittingTransactionId()).thenReturn((Object)txId);
        IdOrderingQueue idOrderingQueue = (IdOrderingQueue)Mockito.mock(IdOrderingQueue.class);
        ((IdOrderingQueue)Mockito.doThrow((Throwable)new RuntimeException(failureMessage)).when((Object)idOrderingQueue)).waitFor(Matchers.anyLong());
        TransactionAppender appender = (TransactionAppender)this.life.add(new BatchingTransactionAppender(this.logFile, LogRotation.NO_ROTATION, this.positionCache, this.transactionIdStore, idOrderingQueue, this.kernelHealth));
        this.life.start();
        TransactionRepresentation transaction = this.transactionWithLegacyIndexCommand();
        try {
            appender.append(transaction, this.logAppendEvent);
            Assert.fail((String)"Expected append to fail. Something is wrong with the test itself");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)Exceptions.contains((Throwable)e, (String)failureMessage, (Class[])new Class[]{RuntimeException.class}));
            ((TransactionIdStore)Mockito.verify((Object)this.transactionIdStore, (VerificationMode)Mockito.times((int)1))).nextCommittingTransactionId();
            ((TransactionIdStore)Mockito.verify((Object)this.transactionIdStore, (VerificationMode)Mockito.times((int)1))).transactionCommitted(Matchers.eq((long)txId), Matchers.anyLong(), Matchers.eq((long)0L));
            ((TransactionIdStore)Mockito.verify((Object)this.transactionIdStore, (VerificationMode)Mockito.times((int)1))).transactionClosed(Matchers.eq((long)txId), Matchers.anyLong(), Matchers.anyLong());
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.transactionIdStore});
        }
    }

    @Test
    public void shouldBeAbleToWriteACheckPoint() throws Throwable {
        BatchingTransactionAppender appender = new BatchingTransactionAppender(this.logFile, LogRotation.NO_ROTATION, this.positionCache, this.transactionIdStore, IdOrderingQueue.BYPASS, this.kernelHealth);
        WritableLogChannel channel = (WritableLogChannel)Mockito.mock(WritableLogChannel.class, (Answer)Mockito.RETURNS_MOCKS);
        Flushable flushable = (Flushable)Mockito.mock(Flushable.class);
        Mockito.when((Object)channel.emptyBufferIntoChannelAndClearIt()).thenReturn((Object)flushable);
        Mockito.when((Object)channel.putLong(Matchers.anyLong())).thenReturn((Object)channel);
        Mockito.when((Object)this.logFile.getWriter()).thenReturn((Object)channel);
        appender.start();
        appender.checkPoint(new LogPosition(1L, 2L), LogCheckPointEvent.NULL);
        ((WritableLogChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).putLong(1L);
        ((WritableLogChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).putLong(2L);
        ((WritableLogChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).emptyBufferIntoChannelAndClearIt();
        ((Flushable)Mockito.verify((Object)flushable, (VerificationMode)Mockito.times((int)1))).flush();
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.kernelHealth});
    }

    @Test
    public void shouldKernelPanicIfNotAbleToWriteACheckPoint() throws Throwable {
        BatchingTransactionAppender appender = new BatchingTransactionAppender(this.logFile, LogRotation.NO_ROTATION, this.positionCache, this.transactionIdStore, IdOrderingQueue.BYPASS, this.kernelHealth);
        IOException ioex = new IOException("boom!");
        WritableLogChannel channel = (WritableLogChannel)Mockito.mock(WritableLogChannel.class, (Answer)Mockito.RETURNS_MOCKS);
        Mockito.when((Object)channel.putLong(Matchers.anyLong())).thenThrow(new Throwable[]{ioex});
        Mockito.when((Object)this.logFile.getWriter()).thenReturn((Object)channel);
        appender.start();
        try {
            appender.checkPoint(new LogPosition(0L, 0L), LogCheckPointEvent.NULL);
            Assert.fail((String)"should have thrown ");
        }
        catch (IOException ex) {
            Assert.assertEquals((Object)ioex, (Object)ex);
        }
        ((KernelHealth)Mockito.verify((Object)this.kernelHealth, (VerificationMode)Mockito.times((int)1))).panic((Throwable)ioex);
    }

    private TransactionRepresentation transactionWithLegacyIndexCommand() {
        ArrayList<IndexDefineCommand> commands = new ArrayList<IndexDefineCommand>();
        IndexDefineCommand command = new IndexDefineCommand();
        command.init(new HashMap(), new HashMap());
        commands.add(command);
        PhysicalTransactionRepresentation transaction = new PhysicalTransactionRepresentation(commands);
        transaction.setHeader(new byte[0], 0, 0, 0L, 0L, 0L, 0);
        return transaction;
    }

    private Commitment tryComplete(Future<?> future, int millis) {
        try {
            return (Commitment)future.get(millis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("A committer that was expected to be done wasn't", e);
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    private boolean anyBoolean(boolean[] array, boolean lookFor) {
        for (boolean item : array) {
            if (item != lookFor) continue;
            return true;
        }
        return false;
    }

    private Future[] committersStartYourEngines(final TransactionAppender appender, boolean ... transactions) {
        ExecutorService executor = this.cleanup.add(Executors.newCachedThreadPool());
        Future[] futures = new Future[transactions.length];
        for (int i = 0; i < transactions.length; ++i) {
            final TransactionRepresentation transaction = this.createTransaction(transactions[i], i);
            futures[i] = executor.submit(new Callable<Commitment>(){

                @Override
                public Commitment call() throws IOException {
                    return appender.append(transaction, BatchingTransactionAppenderTest.this.logAppendEvent);
                }
            });
        }
        return futures;
    }

    private TransactionRepresentation createTransaction(boolean includeLegacyIndexCommands, int i) {
        ArrayList<Object> commands = new ArrayList<Object>();
        if (includeLegacyIndexCommands) {
            IndexDefineCommand defineCommand = new IndexDefineCommand();
            defineCommand.init(MapUtil.genericMap((Object[])new Object[]{"one", 1}), MapUtil.genericMap((Object[])new Object[]{"two", 2}));
            commands.add(defineCommand);
        } else {
            Command.NodeCommand nodeCommand = new Command.NodeCommand();
            NodeRecord record = new NodeRecord((long)(1 + i));
            record.setInUse(true);
            nodeCommand.init(new NodeRecord(record.getId()), record);
            commands.add(nodeCommand);
        }
        PhysicalTransactionRepresentation transaction = new PhysicalTransactionRepresentation(commands);
        transaction.setHeader(new byte[0], 0, 0, 0L, 0L, 0L, -1);
        return transaction;
    }

    private Collection<Command> singleCreateNodeCommand() {
        ArrayList<Command> commands = new ArrayList<Command>();
        Command.NodeCommand command = new Command.NodeCommand();
        long id = 0L;
        NodeRecord before = new NodeRecord(id);
        NodeRecord after = new NodeRecord(id);
        after.setInUse(true);
        command.init(before, after);
        commands.add((Command)command);
        return commands;
    }
}

