/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.transaction.command.CommandReader;
import org.neo4j.kernel.impl.transaction.log.CommandWriter;
import org.neo4j.kernel.impl.transaction.log.InMemoryLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;

public class CommandWriterTest {
    @Test
    public void shouldWriteIndexDefineCommandIfMapWithinShortRange() throws IOException {
        InMemoryLogChannel channel = new InMemoryLogChannel(10000);
        CommandWriter commandWriter = new CommandWriter((WritableLogChannel)channel);
        IndexDefineCommand command = this.initIndexDefineCommand(300);
        boolean b = commandWriter.visitIndexDefineCommand(command);
        TestCase.assertFalse((boolean)b);
        CommandReader commandReader = LogEntryVersion.CURRENT.newCommandReader();
        IndexDefineCommand read = (IndexDefineCommand)commandReader.read((ReadableLogChannel)channel);
        TestCase.assertEquals((Object)command.getIndexNameIdRange(), (Object)read.getIndexNameIdRange());
        TestCase.assertEquals((Object)command.getKeyIdRange(), (Object)read.getKeyIdRange());
    }

    @Test
    public void shouldFailToWriteIndexDefineCommandIfMapIsLargerThanShort() throws IOException {
        InMemoryLogChannel channel = new InMemoryLogChannel(1000);
        CommandWriter commandWriter = new CommandWriter((WritableLogChannel)channel);
        IndexDefineCommand command = (IndexDefineCommand)Mockito.mock(IndexDefineCommand.class);
        Map<String, Integer> largeMap = this.initMap(65536);
        Mockito.when((Object)command.getIndexNameIdRange()).thenReturn(largeMap);
        Mockito.when((Object)command.getKeyIdRange()).thenReturn(largeMap);
        try {
            commandWriter.visitIndexDefineCommand(command);
            TestCase.fail((String)"Expected an AssertionError");
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    private IndexDefineCommand initIndexDefineCommand(int nbrOfEntries) {
        IndexDefineCommand command = new IndexDefineCommand();
        Map<String, Integer> indexNames = this.initMap(nbrOfEntries);
        Map<String, Integer> keys = this.initMap(nbrOfEntries);
        command.init(indexNames, keys);
        return command;
    }

    private Map<String, Integer> initMap(int nbrOfEntries) {
        HashMap<String, Integer> toReturn = new HashMap<String, Integer>();
        while (nbrOfEntries-- > 0) {
            toReturn.put("key" + nbrOfEntries, nbrOfEntries);
        }
        return toReturn;
    }
}

