/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Predicates;
import org.neo4j.kernel.impl.transaction.log.ArrayIOCursor;
import org.neo4j.kernel.impl.transaction.log.FilteringIOCursor;

public class FilteringIOCursorTest {
    @Test
    public void shouldNotFilterWhenNothingToFilter() throws IOException {
        String[] strings = new String[]{"a", "b", "c"};
        ArrayIOCursor<String> delegate = new ArrayIOCursor<String>(strings);
        FilteringIOCursor cursor = new FilteringIOCursor(delegate, Predicates.TRUE());
        Assert.assertEquals(Arrays.asList(strings), this.extractCursorContent(cursor));
    }

    @Test
    public void shouldFilterFirstObject() throws IOException {
        String[] strings = new String[]{"a", "b", "c"};
        ArrayIOCursor<String> delegate = new ArrayIOCursor<String>(strings);
        FilteringIOCursor cursor = new FilteringIOCursor(delegate, Predicates.not((Predicate)Predicates.in((Object[])new String[]{"a"})));
        Assert.assertEquals(this.exclude(Arrays.asList(strings), "a"), this.extractCursorContent(cursor));
    }

    @Test
    public void shouldFilterMiddleObject() throws IOException {
        String[] strings = new String[]{"a", "b", "c"};
        ArrayIOCursor<String> delegate = new ArrayIOCursor<String>(strings);
        FilteringIOCursor cursor = new FilteringIOCursor(delegate, Predicates.not((Predicate)Predicates.in((Object[])new String[]{"b"})));
        Assert.assertEquals(this.exclude(Arrays.asList(strings), "b"), this.extractCursorContent(cursor));
    }

    @Test
    public void shouldFilterLastObject() throws IOException {
        String[] strings = new String[]{"a", "b", "c"};
        ArrayIOCursor<String> delegate = new ArrayIOCursor<String>(strings);
        FilteringIOCursor cursor = new FilteringIOCursor(delegate, Predicates.not((Predicate)Predicates.in((Object[])new String[]{"c"})));
        Assert.assertEquals(this.exclude(Arrays.asList(strings), "c"), this.extractCursorContent(cursor));
    }

    private <T> List<T> exclude(List<T> list, T ... toExclude) {
        ArrayList<T> toReturn = new ArrayList<T>(list);
        for (T item : toExclude) {
            while (toReturn.remove(item)) {
            }
        }
        return toReturn;
    }

    private <T> List<T> extractCursorContent(FilteringIOCursor<T> cursor) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        while (cursor.next()) {
            list.add(cursor.get());
        }
        return list;
    }
}

