/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadPastEndException;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;

public class InMemoryLogChannel
implements WritableLogChannel,
ReadableLogChannel {
    private final byte[] bytes;
    private final ByteBuffer asWriter;
    private final ByteBuffer asReader;
    private static final Flushable NO_OP_FLUSHABLE = new Flushable(){

        @Override
        public void flush() throws IOException {
        }
    };

    public InMemoryLogChannel() {
        this(1000);
    }

    public InMemoryLogChannel(int bufferSize) {
        this.bytes = new byte[bufferSize];
        this.asWriter = ByteBuffer.wrap(this.bytes);
        this.asReader = ByteBuffer.wrap(this.bytes);
    }

    public void reset() {
        this.asWriter.clear();
        this.asReader.clear();
        Arrays.fill(this.bytes, (byte)0);
    }

    public InMemoryLogChannel put(byte b) throws IOException {
        this.asWriter.put(b);
        return this;
    }

    public InMemoryLogChannel putShort(short s) throws IOException {
        this.asWriter.putShort(s);
        return this;
    }

    public InMemoryLogChannel putInt(int i) throws IOException {
        this.asWriter.putInt(i);
        return this;
    }

    public InMemoryLogChannel putLong(long l) throws IOException {
        this.asWriter.putLong(l);
        return this;
    }

    public InMemoryLogChannel putFloat(float f) throws IOException {
        this.asWriter.putFloat(f);
        return this;
    }

    public InMemoryLogChannel putDouble(double d) throws IOException {
        this.asWriter.putDouble(d);
        return this;
    }

    public InMemoryLogChannel put(byte[] bytes, int length) throws IOException {
        this.asWriter.put(bytes, 0, length);
        return this;
    }

    public StoreChannel getFileChannel() {
        throw new UnsupportedOperationException();
    }

    public boolean isOpen() {
        return true;
    }

    public void close() throws IOException {
    }

    public Flushable emptyBufferIntoChannelAndClearIt() {
        return NO_OP_FLUSHABLE;
    }

    public byte get() throws ReadPastEndException {
        this.ensureAvailableToRead(1);
        return this.asReader.get();
    }

    public short getShort() throws ReadPastEndException {
        this.ensureAvailableToRead(2);
        return this.asReader.getShort();
    }

    public int getInt() throws ReadPastEndException {
        this.ensureAvailableToRead(4);
        return this.asReader.getInt();
    }

    public long getLong() throws ReadPastEndException {
        this.ensureAvailableToRead(8);
        return this.asReader.getLong();
    }

    public float getFloat() throws ReadPastEndException {
        this.ensureAvailableToRead(4);
        return this.asReader.getFloat();
    }

    public double getDouble() throws ReadPastEndException {
        this.ensureAvailableToRead(8);
        return this.asReader.getDouble();
    }

    public void get(byte[] bytes, int length) throws ReadPastEndException {
        this.ensureAvailableToRead(length);
        this.asReader.get(bytes, 0, length);
    }

    private void ensureAvailableToRead(int i) throws ReadPastEndException {
        if (this.asReader.remaining() < i || this.asReader.position() + i > this.asWriter.position()) {
            throw ReadPastEndException.INSTANCE;
        }
    }

    public LogPositionMarker getCurrentPosition(LogPositionMarker positionMarker) {
        positionMarker.mark(0L, (long)this.asWriter.position());
        return positionMarker;
    }

    public int positionWriter(int position) {
        int previous = this.asWriter.position();
        this.asWriter.position(position);
        return previous;
    }

    public int positionReader(int position) {
        int previous = this.asReader.position();
        this.asReader.position(position);
        return previous;
    }

    public int readerPosition() {
        return this.asReader.position();
    }

    public int writerPosition() {
        return this.asWriter.position();
    }

    public void truncateTo(int bytesSuccessfullyWritten) {
        this.asReader.limit(bytesSuccessfullyWritten);
    }

    public int capacity() {
        return this.bytes.length;
    }

    public int availableBytesToRead() {
        return this.asReader.remaining();
    }

    public int availableBytesToWrite() {
        return this.asWriter.remaining();
    }
}

