/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointScheduler;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.OnDemandJobScheduler;

public class CheckPointSchedulerTest {
    private final CheckPointer checkPointer = (CheckPointer)Mockito.mock(CheckPointer.class);
    private final OnDemandJobScheduler jobScheduler = (OnDemandJobScheduler)((Object)Mockito.spy((Object)((Object)new OnDemandJobScheduler())));

    @Test
    public void shouldScheduleTheCheckPointerJobOnStart() throws Throwable {
        CheckPointScheduler scheduler = new CheckPointScheduler(this.checkPointer, (JobScheduler)this.jobScheduler, 20L);
        Assert.assertNull((Object)this.jobScheduler.getJob());
        scheduler.start();
        Assert.assertNotNull((Object)this.jobScheduler.getJob());
        ((OnDemandJobScheduler)((Object)Mockito.verify((Object)((Object)this.jobScheduler), (VerificationMode)Mockito.times((int)1)))).schedule((JobScheduler.Group)Matchers.eq((Object)JobScheduler.Groups.checkPoint), (Runnable)Matchers.any(Runnable.class), Matchers.eq((long)20L), (TimeUnit)((Object)Matchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
    }

    @Test
    public void shouldRescheduleTheJobAfterARun() throws Throwable {
        CheckPointScheduler scheduler = new CheckPointScheduler(this.checkPointer, (JobScheduler)this.jobScheduler, 20L);
        Assert.assertNull((Object)this.jobScheduler.getJob());
        scheduler.start();
        Runnable scheduledJob = this.jobScheduler.getJob();
        Assert.assertNotNull((Object)scheduledJob);
        this.jobScheduler.runJob();
        ((OnDemandJobScheduler)((Object)Mockito.verify((Object)((Object)this.jobScheduler), (VerificationMode)Mockito.times((int)2)))).schedule((JobScheduler.Group)Matchers.eq((Object)JobScheduler.Groups.checkPoint), (Runnable)Matchers.any(Runnable.class), Matchers.eq((long)20L), (TimeUnit)((Object)Matchers.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        ((CheckPointer)Mockito.verify((Object)this.checkPointer, (VerificationMode)Mockito.times((int)1))).checkPointIfNeeded((TriggerInfo)Matchers.any(TriggerInfo.class));
        Assert.assertEquals((Object)scheduledJob, (Object)this.jobScheduler.getJob());
    }

    @Test
    public void shouldNotRescheduleAJobWhenStopped() throws Throwable {
        CheckPointScheduler scheduler = new CheckPointScheduler(this.checkPointer, (JobScheduler)this.jobScheduler, 20L);
        Assert.assertNull((Object)this.jobScheduler.getJob());
        scheduler.start();
        Assert.assertNotNull((Object)this.jobScheduler.getJob());
        scheduler.stop();
        Assert.assertNull((Object)this.jobScheduler.getJob());
    }

    @Test
    public void stoppedJobCantBeInvoked() throws Throwable {
        CheckPointScheduler scheduler = new CheckPointScheduler(this.checkPointer, (JobScheduler)this.jobScheduler, 10L);
        scheduler.start();
        this.jobScheduler.runJob();
        ((CheckPointer)Mockito.verify((Object)this.checkPointer)).checkPointIfNeeded((TriggerInfo)Matchers.any(TriggerInfo.class));
        scheduler.stop();
        scheduler.start();
        this.jobScheduler.runJob();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.checkPointer});
    }

    @Test
    public void shouldWaitOnStopUntilTheRunningCheckpointIsDone() throws Throwable {
        final AtomicReference ex = new AtomicReference();
        final AtomicBoolean stoppedCompleted = new AtomicBoolean();
        final DoubleLatch checkPointerLatch = new DoubleLatch(1);
        CheckPointer checkPointer = new CheckPointer(){

            public long checkPointIfNeeded(TriggerInfo triggerInfo) throws IOException {
                checkPointerLatch.start();
                checkPointerLatch.awaitFinish();
                return 42L;
            }

            public long tryCheckPoint(TriggerInfo triggerInfo) throws IOException {
                throw new RuntimeException("this should have not been called");
            }

            public long forceCheckPoint(TriggerInfo triggerInfo) throws IOException {
                throw new RuntimeException("this should have not been called");
            }
        };
        final CheckPointScheduler scheduler = new CheckPointScheduler(checkPointer, (JobScheduler)this.jobScheduler, 20L);
        scheduler.start();
        Thread runCheckPointer = new Thread(){

            @Override
            public void run() {
                CheckPointSchedulerTest.this.jobScheduler.runJob();
            }
        };
        runCheckPointer.start();
        checkPointerLatch.awaitStart();
        Thread stopper = new Thread(){

            @Override
            public void run() {
                try {
                    scheduler.stop();
                    stoppedCompleted.set(true);
                }
                catch (Throwable throwable) {
                    ex.set(throwable);
                }
            }
        };
        stopper.start();
        Thread.sleep(10L);
        Assert.assertFalse((boolean)stoppedCompleted.get());
        checkPointerLatch.finish();
        runCheckPointer.join();
        Thread.sleep(150L);
        Assert.assertTrue((boolean)stoppedCompleted.get());
        stopper.join();
        Assert.assertNull(ex.get());
    }
}

