/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.FakeClock;
import org.neo4j.kernel.impl.transaction.log.checkpoint.DefaultCheckPointerTracer;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;

public class DefaultCheckPointerTracerTest {
    private final FakeClock clock = new FakeClock();

    @Test
    public void shouldCountEventsAnAccumulatedTotalTime() throws Throwable {
        DefaultCheckPointerTracer tracer = new DefaultCheckPointerTracer((Clock)this.clock);
        this.clock.forward(10L, TimeUnit.MILLISECONDS);
        try (LogCheckPointEvent event = tracer.beginCheckPoint();){
            this.clock.forward(20L, TimeUnit.MILLISECONDS);
        }
        Assert.assertEquals((long)1L, (long)tracer.numberOfCheckPointEvents());
        Assert.assertEquals((long)20L, (long)tracer.checkPointAccumulatedTotalTimeMillis());
        this.clock.forward(200L, TimeUnit.MILLISECONDS);
        event = tracer.beginCheckPoint();
        var3_3 = null;
        try {
            this.clock.forward(30L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (event != null) {
                if (var3_3 != null) {
                    try {
                        event.close();
                    }
                    catch (Throwable x2) {
                        var3_3.addSuppressed(x2);
                    }
                } else {
                    event.close();
                }
            }
        }
        Assert.assertEquals((long)2L, (long)tracer.numberOfCheckPointEvents());
        Assert.assertEquals((long)50L, (long)tracer.checkPointAccumulatedTotalTimeMillis());
    }

    @Test
    public void shouldReturnZeroIfNoDataIsAvailable() throws Throwable {
        DefaultCheckPointerTracer tracer = new DefaultCheckPointerTracer((Clock)this.clock);
        Assert.assertEquals((long)0L, (long)tracer.numberOfCheckPointEvents());
        Assert.assertEquals((long)0L, (long)tracer.checkPointAccumulatedTotalTimeMillis());
    }
}

