/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.File;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestTxEntries {
    private final File storeDir = new File("dir");
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    @Test
    public void testStartEntryWrittenOnceOnRollback() throws Exception {
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)this.fs.get()).newImpermanentDatabase(this.storeDir);
        this.createSomeTransactions(db);
        EphemeralFileSystemAbstraction snapshot = this.fs.snapshot(EphemeralFileSystemRule.shutdownDbAction(db));
        new TestGraphDatabaseFactory().setFileSystem((FileSystemAbstraction)snapshot).newImpermanentDatabase(this.storeDir).shutdown();
    }

    private void createSomeTransactions(GraphDatabaseService db) {
        Transaction tx = db.beginTx();
        Node node1 = db.createNode();
        Node node2 = db.createNode();
        node1.createRelationshipTo(node2, (RelationshipType)DynamicRelationshipType.withName((String)"relType1"));
        tx.success();
        tx.close();
        tx = db.beginTx();
        node1.delete();
        tx.success();
        try {
            tx.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        tx = db.beginTx();
        node1.setProperty("foo", (Object)"bar");
        tx.success();
        tx.close();
    }
}

