/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.CommandWriter;
import org.neo4j.kernel.impl.transaction.log.InMemoryLogChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.IdentifiableLogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;

public class VersionAwareLogEntryReaderTest {
    private final VersionAwareLogEntryReader<ReadableLogChannel> logEntryReader = new VersionAwareLogEntryReader();

    @Test
    public void shouldReadAStartLogEntry() throws IOException {
        LogEntryVersion version = LogEntryVersion.CURRENT;
        LogEntryStart start = new LogEntryStart(version, 1, 2, 3L, 4L, new byte[]{5}, new LogPosition(0L, 31L));
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.put(version.byteCode());
        channel.put((byte)1);
        channel.putInt(start.getMasterId());
        channel.putInt(start.getLocalId());
        channel.putLong(start.getTimeWritten());
        channel.putLong(start.getLastCommittedTxWhenTransactionStarted());
        channel.putInt(start.getAdditionalHeader().length);
        channel.put(start.getAdditionalHeader(), start.getAdditionalHeader().length);
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel);
        Assert.assertEquals((Object)start, (Object)logEntry);
    }

    @Test
    public void shouldReadACommitLogEntry() throws IOException {
        LogEntryVersion version = LogEntryVersion.CURRENT;
        OnePhaseCommit commit = new OnePhaseCommit(version, 42L, 21L);
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.put(version.byteCode());
        channel.put((byte)5);
        channel.putLong(commit.getTxId());
        channel.putLong(commit.getTimeWritten());
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel);
        Assert.assertEquals((Object)commit, (Object)logEntry);
    }

    @Test
    public void shouldReadACommandLogEntry() throws IOException {
        LogEntryVersion version = LogEntryVersion.CURRENT;
        Command.NodeCommand nodeCommand = new Command.NodeCommand();
        nodeCommand.init(new NodeRecord(11L), new NodeRecord(11L));
        LogEntryCommand command = new LogEntryCommand(version, (Command)nodeCommand);
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.put(version.byteCode());
        channel.put((byte)3);
        new CommandWriter((WritableLogChannel)channel).visitNodeCommand(nodeCommand);
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel);
        Assert.assertEquals((Object)command, (Object)logEntry);
    }

    @Test
    public void shouldReadACheckPointLogEntry() throws IOException {
        LogEntryVersion version = LogEntryVersion.CURRENT;
        LogPosition logPosition = new LogPosition(42L, 43L);
        CheckPoint checkPoint = new CheckPoint(version, logPosition);
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.put(version.byteCode());
        channel.put((byte)7);
        channel.putLong(logPosition.getLogVersion());
        channel.putLong(logPosition.getByteOffset());
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel);
        Assert.assertEquals((Object)checkPoint, (Object)logEntry);
    }

    @Test
    public void shouldReturnNullWhenThereIsNoCommand() throws IOException {
        LogEntryVersion version = LogEntryVersion.CURRENT;
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.put(version.byteCode());
        channel.put((byte)3);
        channel.put((byte)0);
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel);
        Assert.assertNull((Object)logEntry);
    }

    @Test
    public void shouldReturnNullWhenLogEntryIsEmpty() throws IOException {
        LogEntryVersion version = LogEntryVersion.CURRENT;
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.put(version.byteCode());
        channel.put((byte)0);
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel);
        Assert.assertNull((Object)logEntry);
    }

    @Test
    public void shouldReturnNullWhenNotEnoughDataInTheChannel() throws IOException {
        LogEntryVersion version = LogEntryVersion.CURRENT;
        InMemoryLogChannel channel = new InMemoryLogChannel();
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel);
        Assert.assertNull((Object)logEntry);
    }

    @Test
    public void shouldParseOldStartEntry() throws IOException {
        LogEntryVersion version = LogEntryVersion.V2_1;
        InMemoryLogChannel channel = new InMemoryLogChannel();
        LogEntryStart start = new LogEntryStart(1, 2, 3L, 4L, new byte[0], new LogPosition(0L, 37L));
        channel.put(version.byteCode());
        channel.put((byte)1);
        channel.put((byte)1);
        channel.put((byte)0);
        channel.put(new byte[]{7}, 1);
        channel.put(new byte[0], 0);
        channel.putInt(123);
        channel.putInt(456);
        channel.putInt(start.getMasterId());
        channel.putInt(start.getLocalId());
        channel.putLong(start.getTimeWritten());
        channel.putLong(start.getLastCommittedTxWhenTransactionStarted());
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel);
        Assert.assertTrue((boolean)(logEntry instanceof IdentifiableLogEntry));
        Assert.assertEquals((Object)start, (Object)((IdentifiableLogEntry)logEntry).getEntry());
    }

    @Test
    public void shouldParseOldOnePhaseCommit() throws IOException {
        LogEntryVersion version = LogEntryVersion.V2_1;
        InMemoryLogChannel channel = new InMemoryLogChannel();
        OnePhaseCommit commit = new OnePhaseCommit(42L, 456L);
        channel.put(version.byteCode());
        channel.put((byte)5);
        channel.putInt(123);
        channel.putLong(commit.getTxId());
        channel.putLong(commit.getTimeWritten());
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel);
        Assert.assertTrue((boolean)(logEntry instanceof IdentifiableLogEntry));
        Assert.assertEquals((Object)commit, (Object)((IdentifiableLogEntry)logEntry).getEntry());
    }

    @Test
    public void shouldParseOldTwoPhaseCommit() throws IOException {
        LogEntryVersion version = LogEntryVersion.V2_1;
        InMemoryLogChannel channel = new InMemoryLogChannel();
        OnePhaseCommit commit = new OnePhaseCommit(42L, 456L);
        channel.put(version.byteCode());
        channel.put((byte)6);
        channel.putInt(123);
        channel.putLong(commit.getTxId());
        channel.putLong(commit.getTimeWritten());
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel);
        Assert.assertTrue((boolean)(logEntry instanceof IdentifiableLogEntry));
        Assert.assertEquals((Object)commit, (Object)((IdentifiableLogEntry)logEntry).getEntry());
    }

    @Test
    public void shouldParseOldPrepareSkipItAndReadTheOneAfter() throws IOException {
        LogEntryVersion version = LogEntryVersion.V2_1;
        InMemoryLogChannel channel = new InMemoryLogChannel();
        OnePhaseCommit commit = new OnePhaseCommit(42L, 456L);
        channel.put(version.byteCode());
        channel.put((byte)2);
        channel.putInt(123);
        channel.putLong(456L);
        channel.put(version.byteCode());
        channel.put((byte)6);
        channel.putInt(123);
        channel.putLong(commit.getTxId());
        channel.putLong(commit.getTimeWritten());
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel);
        Assert.assertTrue((boolean)(logEntry instanceof IdentifiableLogEntry));
        Assert.assertEquals((Object)commit, (Object)((IdentifiableLogEntry)logEntry).getEntry());
    }

    @Test
    public void shouldParseOldDoneSkipItAndReadTheOneAfter() throws IOException {
        LogEntryVersion version = LogEntryVersion.V2_1;
        InMemoryLogChannel channel = new InMemoryLogChannel();
        OnePhaseCommit commit = new OnePhaseCommit(42L, 456L);
        channel.put(version.byteCode());
        channel.put((byte)4);
        channel.putInt(123);
        channel.put(version.byteCode());
        channel.put((byte)6);
        channel.putInt(123);
        channel.putLong(commit.getTxId());
        channel.putLong(commit.getTimeWritten());
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel);
        Assert.assertTrue((boolean)(logEntry instanceof IdentifiableLogEntry));
        Assert.assertEquals((Object)commit, (Object)((IdentifiableLogEntry)logEntry).getEntry());
    }

    @Test
    public void shouldParseAnOldCommandLogEntry() throws IOException {
        LogEntryVersion version = LogEntryVersion.V2_1;
        Command.NodeCommand nodeCommand = new Command.NodeCommand();
        nodeCommand.init(new NodeRecord(10L), new NodeRecord(10L));
        LogEntryCommand command = new LogEntryCommand(version, (Command)nodeCommand);
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.put(version.byteCode());
        channel.put((byte)3);
        channel.putInt(42);
        new CommandWriter((WritableLogChannel)channel).visitNodeCommand(nodeCommand);
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel);
        Assert.assertTrue((boolean)(logEntry instanceof IdentifiableLogEntry));
        Assert.assertEquals((Object)command, (Object)((IdentifiableLogEntry)logEntry).getEntry());
    }

    @Test
    public void shouldReturnNullWhenThereIsNoCommandOldVersion() throws IOException {
        LogEntryVersion version = LogEntryVersion.V2_1;
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.put(version.byteCode());
        channel.put((byte)3);
        channel.put((byte)0);
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel);
        Assert.assertNull((Object)logEntry);
    }

    @Test
    public void shouldParseOldLogEntryEmptyANdReturnNull() throws IOException {
        LogEntryVersion version = LogEntryVersion.V2_1;
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.put(version.byteCode());
        channel.put((byte)0);
        LogEntry logEntry = this.logEntryReader.readLogEntry((ReadableLogChannel)channel);
        Assert.assertNull((Object)logEntry);
    }
}

