/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.stresstest;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.function.BooleanSupplier;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReaderLogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.stresstest.workload.Runner;
import org.neo4j.test.TargetDirectory;

public class TransactionAppenderStressTest {
    @Rule
    public final TargetDirectory.TestDirectory directory = TargetDirectory.testDirForTest(this.getClass());

    @Test
    public void concurrentTransactionAppendingTest() throws Exception {
        int threads = 10;
        File workingDirectory = this.directory.directory("work");
        Callable<Long> runner = new Builder().with(Builder.untilTimeExpired(10L, TimeUnit.SECONDS)).withWorkingDirectory(workingDirectory).withNumThreads(threads).build();
        long appendedTxs = runner.call();
        Assert.assertEquals((long)new TransactionIdChecker(workingDirectory).parseAllTxLogs(), (long)appendedTxs);
    }

    public static class TransactionIdChecker {
        private File workingDirectory;

        public TransactionIdChecker(File workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        public long parseAllTxLogs() throws IOException {
            DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
            long txId = -1L;
            try (ReadableLogChannel channel = this.openLogFile((FileSystemAbstraction)fs, 0);){
                VersionAwareLogEntryReader reader = new VersionAwareLogEntryReader(LogEntryVersion.CURRENT.byteCode());
                LogEntry logEntry = reader.readLogEntry(channel);
                while (logEntry != null) {
                    if (logEntry.getType() == 5) {
                        txId = ((OnePhaseCommit)logEntry.as()).getTxId();
                    }
                    logEntry = reader.readLogEntry(channel);
                }
            }
            return txId;
        }

        private ReadableLogChannel openLogFile(FileSystemAbstraction fs, int version) throws IOException {
            PhysicalLogFiles logFiles = new PhysicalLogFiles(this.workingDirectory, fs);
            PhysicalLogVersionedStoreChannel channel = PhysicalLogFile.openForVersion((PhysicalLogFiles)logFiles, (FileSystemAbstraction)fs, (long)version);
            return new ReadAheadLogChannel((LogVersionedStoreChannel)channel, (LogVersionBridge)new ReaderLogVersionBridge(fs, logFiles), 4096);
        }
    }

    public static class Builder {
        private BooleanSupplier condition;
        private File workingDirectory;
        private int threads;

        public static BooleanSupplier untilTimeExpired(long duration, TimeUnit unit) {
            final long endTimeInMilliseconds = System.currentTimeMillis() + unit.toMillis(duration);
            return new BooleanSupplier(){

                public boolean getAsBoolean() {
                    return System.currentTimeMillis() <= endTimeInMilliseconds;
                }
            };
        }

        public Builder with(BooleanSupplier condition) {
            this.condition = condition;
            return this;
        }

        public Builder withWorkingDirectory(File workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public Builder withNumThreads(int threads) {
            this.threads = threads;
            return this;
        }

        public Callable<Long> build() {
            return new Runner(this.workingDirectory, this.condition, this.threads);
        }
    }
}

