/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.stresstest.workload;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ThreadLocalRandom;
import org.neo4j.kernel.impl.api.TransactionHeaderInformation;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;

class TransactionRepresentationFactory {
    private final CommandGenerator commandGenerator = new CommandGenerator();

    TransactionRepresentationFactory() {
    }

    public TransactionRepresentation nextTransaction(long txId) {
        PhysicalTransactionRepresentation representation = new PhysicalTransactionRepresentation(this.createRandomCommands());
        TransactionHeaderInformation headerInfo = TransactionHeaderInformationFactory.DEFAULT.create();
        representation.setHeader(headerInfo.getAdditionalHeader(), headerInfo.getMasterId(), headerInfo.getAuthorId(), (long)headerInfo.getAuthorId(), txId, System.currentTimeMillis(), 42);
        return representation;
    }

    private Collection<Command> createRandomCommands() {
        int commandNum = ThreadLocalRandom.current().nextInt(1, 17);
        ArrayList<Command> commands = new ArrayList<Command>(commandNum);
        for (int i = 0; i < commandNum; ++i) {
            commands.add(this.commandGenerator.nextCommand());
        }
        return commands;
    }

    private static class NodeRecordGenerator {
        private NodeRecordGenerator() {
        }

        public NodeRecord nextRecord() {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            return new NodeRecord(random.nextLong(), random.nextBoolean(), random.nextBoolean(), random.nextLong(), random.nextLong(), random.nextLong());
        }
    }

    private static class CommandGenerator {
        private NodeRecordGenerator nodeRecordGenerator = new NodeRecordGenerator();

        private CommandGenerator() {
        }

        public Command nextCommand() {
            Command.NodeCommand nodeCommand = new Command.NodeCommand();
            nodeCommand.init(this.nodeRecordGenerator.nextRecord(), this.nodeRecordGenerator.nextRecord());
            return nodeCommand;
        }
    }
}

