/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.locking.Lock;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.transaction.state.NeoStoreIndexStoreView;
import org.neo4j.test.EmbeddedDatabaseRule;

public class NeoStoreIndexStoreViewTest {
    @Rule
    public EmbeddedDatabaseRule dbRule = new EmbeddedDatabaseRule(this.getClass());
    Label label = DynamicLabel.label((String)"Person");
    GraphDatabaseAPI graphDb;
    NeoStoreIndexStoreView storeView;
    int labelId;
    int propertyKeyId;
    Node alistair;
    Node stefan;
    LockService locks;
    NeoStores neoStores;
    CountsTracker counts;
    Map<Long, Lock> lockMocks = new HashMap<Long, Lock>();

    @Test
    public void shouldScanExistingNodesForALabel() throws Exception {
        NodeUpdateCollectingVisitor visitor = new NodeUpdateCollectingVisitor();
        Visitor labelVisitor = (Visitor)Mockito.mock(Visitor.class);
        StoreScan storeScan = this.storeView.visitNodes(new int[]{this.labelId}, new int[]{this.propertyKeyId}, (Visitor)visitor, labelVisitor);
        storeScan.run();
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new NodePropertyUpdate[]{NodePropertyUpdate.add((long)this.alistair.getId(), (int)this.propertyKeyId, (Object)"Alistair", (long[])new long[]{this.labelId}), NodePropertyUpdate.add((long)this.stefan.getId(), (int)this.propertyKeyId, (Object)"Stefan", (long[])new long[]{this.labelId})}), visitor.getUpdates());
    }

    @Test
    public void shouldIgnoreDeletedNodesDuringScan() throws Exception {
        this.deleteAlistairAndStefanNodes();
        NodeUpdateCollectingVisitor visitor = new NodeUpdateCollectingVisitor();
        Visitor labelVisitor = (Visitor)Mockito.mock(Visitor.class);
        StoreScan storeScan = this.storeView.visitNodes(new int[]{this.labelId}, new int[]{this.propertyKeyId}, (Visitor)visitor, labelVisitor);
        storeScan.run();
        Assert.assertEquals((Object)IteratorUtil.emptySetOf(NodePropertyUpdate.class), visitor.getUpdates());
    }

    @Test
    public void shouldLockNodesWhileReadingThem() throws Exception {
        Visitor visitor = (Visitor)Mockito.mock(Visitor.class);
        StoreScan storeScan = this.storeView.visitNodesWithPropertyAndLabel(new IndexDescriptor(this.labelId, this.propertyKeyId), visitor);
        storeScan.run();
        Assert.assertEquals((String)("allocated locks: " + this.lockMocks.keySet()), (long)2L, (long)this.lockMocks.size());
        Lock lock0 = this.lockMocks.get(0L);
        Lock lock1 = this.lockMocks.get(1L);
        Assert.assertNotNull((String)"Lock[node=0] never acquired", (Object)lock0);
        Assert.assertNotNull((String)"Lock[node=1] never acquired", (Object)lock1);
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.locks, lock0, lock1});
        ((LockService)order.verify((Object)this.locks)).acquireNodeLock(0L, LockService.LockType.READ_LOCK);
        ((Lock)order.verify((Object)lock0)).release();
        ((LockService)order.verify((Object)this.locks)).acquireNodeLock(1L, LockService.LockType.READ_LOCK);
        ((Lock)order.verify((Object)lock1)).release();
        order.verifyNoMoreInteractions();
    }

    @Test
    public void shouldReadProperties() throws PropertyNotFoundException, EntityNotFoundException {
        Property property = this.storeView.getProperty(this.alistair.getId(), this.propertyKeyId);
        Assert.assertTrue((boolean)property.valueEquals((Object)"Alistair"));
    }

    @Before
    public void before() throws KernelException {
        this.graphDb = this.dbRule.getGraphDatabaseAPI();
        this.createAlistairAndStefanNodes();
        this.getOrCreateIds();
        this.neoStores = new StoreAccess(this.graphDb).getRawNeoStores();
        this.counts = this.neoStores.getCounts();
        this.locks = (LockService)Mockito.mock(LockService.class, (Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                Long nodeId = (Long)invocation.getArguments()[0];
                Lock lock = NeoStoreIndexStoreViewTest.this.lockMocks.get(nodeId);
                if (lock == null) {
                    lock = (Lock)Mockito.mock(Lock.class);
                    NeoStoreIndexStoreViewTest.this.lockMocks.put(nodeId, lock);
                }
                return lock;
            }
        });
        this.storeView = new NeoStoreIndexStoreView(this.locks, this.neoStores);
    }

    private void createAlistairAndStefanNodes() {
        try (Transaction tx = this.graphDb.beginTx();){
            this.alistair = this.graphDb.createNode(new Label[]{this.label});
            this.alistair.setProperty("name", (Object)"Alistair");
            this.stefan = this.graphDb.createNode(new Label[]{this.label});
            this.stefan.setProperty("name", (Object)"Stefan");
            tx.success();
        }
    }

    private void deleteAlistairAndStefanNodes() {
        try (Transaction tx = this.graphDb.beginTx();){
            this.alistair.delete();
            this.stefan.delete();
            tx.success();
        }
    }

    private void getOrCreateIds() throws KernelException {
        try (Transaction tx = this.graphDb.beginTx();){
            ThreadToStatementContextBridge bridge = (ThreadToStatementContextBridge)this.graphDb.getDependencyResolver().resolveDependency(ThreadToStatementContextBridge.class);
            try (Statement statement = bridge.get();){
                this.labelId = statement.dataWriteOperations().labelGetOrCreateForName("Person");
                this.propertyKeyId = statement.dataWriteOperations().propertyKeyGetOrCreateForName("name");
            }
            tx.success();
        }
    }

    class NodeUpdateCollectingVisitor
    implements Visitor<NodePropertyUpdate, Exception> {
        private final Set<NodePropertyUpdate> updates = new HashSet<NodePropertyUpdate>();

        NodeUpdateCollectingVisitor() {
        }

        public boolean visit(NodePropertyUpdate element) throws Exception {
            this.updates.add(element);
            return false;
        }

        Set<NodePropertyUpdate> getUpdates() {
            return this.updates;
        }
    }
}

