/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.store.AbstractRecordStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.id.IdSequence;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.transaction.state.Loaders;
import org.neo4j.kernel.impl.transaction.state.PropertyCreator;
import org.neo4j.kernel.impl.transaction.state.PropertyTraverser;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;
import org.neo4j.unsafe.batchinsert.DirectRecordAccess;
import org.neo4j.unsafe.impl.batchimport.store.BatchingIdSequence;

public class PropertyCreatorTest {
    private final IdSequence idGenerator = new BatchingIdSequence();
    private final PropertyCreator creator = new PropertyCreator(null, null, this.idGenerator, new PropertyTraverser());
    private final RecordAccess<Long, PropertyRecord, PrimitiveRecord> records = new DirectRecordAccess((AbstractRecordStore)Mockito.mock(AbstractRecordStore.class), (RecordAccess.Loader)new PropertyRecordLoader());
    private final MyPrimitiveProxy primitive = new MyPrimitiveProxy();

    @Test
    public void shouldAddPropertyToEmptyChain() throws Exception {
        this.existingChain(new ExpectedRecord[0]);
        this.setProperty(1, "value");
        this.assertChain(this.record(PropertyCreatorTest.property(1, "value")));
    }

    @Test
    public void shouldAddPropertyToChainContainingOtherFullRecords() throws Exception {
        this.existingChain(this.record(PropertyCreatorTest.property(0, 0), PropertyCreatorTest.property(1, 1), PropertyCreatorTest.property(2, 2), PropertyCreatorTest.property(3, 3)), this.record(PropertyCreatorTest.property(4, 4), PropertyCreatorTest.property(5, 5), PropertyCreatorTest.property(6, 6), PropertyCreatorTest.property(7, 7)));
        this.setProperty(10, 10);
        this.assertChain(this.record(PropertyCreatorTest.property(10, 10)), this.record(PropertyCreatorTest.property(0, 0), PropertyCreatorTest.property(1, 1), PropertyCreatorTest.property(2, 2), PropertyCreatorTest.property(3, 3)), this.record(PropertyCreatorTest.property(4, 4), PropertyCreatorTest.property(5, 5), PropertyCreatorTest.property(6, 6), PropertyCreatorTest.property(7, 7)));
    }

    @Test
    public void shouldAddPropertyToChainContainingOtherNonFullRecords() throws Exception {
        this.existingChain(this.record(PropertyCreatorTest.property(0, 0), PropertyCreatorTest.property(1, 1), PropertyCreatorTest.property(2, 2), PropertyCreatorTest.property(3, 3)), this.record(PropertyCreatorTest.property(4, 4), PropertyCreatorTest.property(5, 5), PropertyCreatorTest.property(6, 6)));
        this.setProperty(10, 10);
        this.assertChain(this.record(PropertyCreatorTest.property(0, 0), PropertyCreatorTest.property(1, 1), PropertyCreatorTest.property(2, 2), PropertyCreatorTest.property(3, 3)), this.record(PropertyCreatorTest.property(4, 4), PropertyCreatorTest.property(5, 5), PropertyCreatorTest.property(6, 6), PropertyCreatorTest.property(10, 10)));
    }

    @Test
    public void shouldAddPropertyToChainContainingOtherNonFullRecordsInMiddle() throws Exception {
        this.existingChain(this.record(PropertyCreatorTest.property(0, 0), PropertyCreatorTest.property(1, 1), PropertyCreatorTest.property(2, 2)), this.record(PropertyCreatorTest.property(3, 3), PropertyCreatorTest.property(4, 4), PropertyCreatorTest.property(5, 5), PropertyCreatorTest.property(6, 6)));
        this.setProperty(10, 10);
        this.assertChain(this.record(PropertyCreatorTest.property(0, 0), PropertyCreatorTest.property(1, 1), PropertyCreatorTest.property(2, 2), PropertyCreatorTest.property(10, 10)), this.record(PropertyCreatorTest.property(3, 3), PropertyCreatorTest.property(4, 4), PropertyCreatorTest.property(5, 5), PropertyCreatorTest.property(6, 6)));
    }

    @Test
    public void shouldChangeOnlyProperty() throws Exception {
        this.existingChain(this.record(PropertyCreatorTest.property(0, "one")));
        this.setProperty(0, "two");
        this.assertChain(this.record(PropertyCreatorTest.property(0, "two")));
    }

    @Test
    public void shouldChangePropertyInChainWithOthersBeforeIt() throws Exception {
        this.existingChain(this.record(PropertyCreatorTest.property(0, "one"), PropertyCreatorTest.property(1, 1)), this.record(PropertyCreatorTest.property(2, "two"), PropertyCreatorTest.property(3, 3)));
        this.setProperty(2, "two*");
        this.assertChain(this.record(PropertyCreatorTest.property(0, "one"), PropertyCreatorTest.property(1, 1)), this.record(PropertyCreatorTest.property(2, "two*"), PropertyCreatorTest.property(3, 3)));
    }

    @Test
    public void shouldChangePropertyInChainWithOthersAfterIt() throws Exception {
        this.existingChain(this.record(PropertyCreatorTest.property(0, "one"), PropertyCreatorTest.property(1, 1)), this.record(PropertyCreatorTest.property(2, "two"), PropertyCreatorTest.property(3, 3)));
        this.setProperty(0, "one*");
        this.assertChain(this.record(PropertyCreatorTest.property(0, "one*"), PropertyCreatorTest.property(1, 1)), this.record(PropertyCreatorTest.property(2, "two"), PropertyCreatorTest.property(3, 3)));
    }

    @Test
    public void shouldChangePropertyToBiggerInFullChain() throws Exception {
        this.existingChain(this.record(PropertyCreatorTest.property(0, 0), PropertyCreatorTest.property(1, 1), PropertyCreatorTest.property(2, 2), PropertyCreatorTest.property(3, 3)));
        this.setProperty(1, Long.MAX_VALUE);
        this.assertChain(this.record(PropertyCreatorTest.property(1, Long.MAX_VALUE)), this.record(PropertyCreatorTest.property(0, 0), PropertyCreatorTest.property(2, 2), PropertyCreatorTest.property(3, 3)));
    }

    @Test
    public void shouldChangePropertyToBiggerInChainWithHoleAfter() throws Exception {
        this.existingChain(this.record(PropertyCreatorTest.property(0, 0), PropertyCreatorTest.property(1, 1), PropertyCreatorTest.property(2, 2), PropertyCreatorTest.property(3, 3)), this.record(PropertyCreatorTest.property(4, 4), PropertyCreatorTest.property(5, 5)));
        this.setProperty(1, Long.MAX_VALUE);
        this.assertChain(this.record(PropertyCreatorTest.property(0, 0), PropertyCreatorTest.property(2, 2), PropertyCreatorTest.property(3, 3)), this.record(PropertyCreatorTest.property(4, 4), PropertyCreatorTest.property(5, 5), PropertyCreatorTest.property(1, Long.MAX_VALUE)));
    }

    @Test
    public void shouldChangePropertyToBiggerInChainWithHoleBefore() throws Exception {
        this.existingChain(this.record(PropertyCreatorTest.property(0, 0), PropertyCreatorTest.property(1, 1)), this.record(PropertyCreatorTest.property(2, 2), PropertyCreatorTest.property(3, 3), PropertyCreatorTest.property(4, 4), PropertyCreatorTest.property(5, 5)));
        this.setProperty(2, Long.MAX_VALUE);
        this.assertChain(this.record(PropertyCreatorTest.property(0, 0), PropertyCreatorTest.property(1, 1), PropertyCreatorTest.property(2, Long.MAX_VALUE)), this.record(PropertyCreatorTest.property(3, 3), PropertyCreatorTest.property(4, 4), PropertyCreatorTest.property(5, 5)));
    }

    private void existingChain(ExpectedRecord ... initialRecords) {
        PropertyRecord prev = null;
        for (ExpectedRecord initialRecord : initialRecords) {
            PropertyRecord record = (PropertyRecord)this.records.create((Object)this.idGenerator.nextId(), (Object)this.primitive.record).forChangingData();
            record.setInUse(true);
            this.existingRecord(record, initialRecord);
            if (prev == null) {
                this.primitive.record.setNextProp(record.getId());
            } else {
                record.setPrevProp(prev.getId());
                prev.setNextProp(record.getId());
            }
            prev = record;
        }
    }

    private void existingRecord(PropertyRecord record, ExpectedRecord initialRecord) {
        for (ExpectedProperty initialProperty : initialRecord.properties) {
            PropertyBlock block = new PropertyBlock();
            PropertyStore.encodeValue((PropertyBlock)block, (int)initialProperty.key, (Object)initialProperty.value, null, null);
            record.addPropertyBlock(block);
        }
        Assert.assertTrue((record.size() <= PropertyType.getPayloadSize() ? 1 : 0) != 0);
    }

    private void setProperty(int key, Object value) {
        this.creator.primitiveSetProperty((RecordAccess.RecordProxy)this.primitive, key, value, this.records);
    }

    private void assertChain(ExpectedRecord ... expectedRecords) {
        long nextProp = this.primitive.forReadingLinkage().getNextProp();
        int expectedRecordCursor = 0;
        while (!Record.NO_NEXT_PROPERTY.is(nextProp)) {
            PropertyRecord record = (PropertyRecord)this.records.getIfLoaded((Object)nextProp).forReadingData();
            this.assertRecord(record, expectedRecords[expectedRecordCursor++]);
            nextProp = record.getNextProp();
        }
    }

    private void assertRecord(PropertyRecord record, ExpectedRecord expectedRecord) {
        Assert.assertEquals((long)expectedRecord.properties.length, (long)record.numberOfProperties());
        for (ExpectedProperty expectedProperty : expectedRecord.properties) {
            PropertyBlock block = record.getPropertyBlock(expectedProperty.key);
            Assert.assertNotNull((Object)block);
            Assert.assertEquals((Object)expectedProperty.value, (Object)block.getType().getValue(block, null));
        }
    }

    static ExpectedProperty property(int key, Object value) {
        return new ExpectedProperty(key, value);
    }

    private ExpectedRecord record(ExpectedProperty ... properties) {
        return new ExpectedRecord(properties);
    }

    private static class PropertyRecordLoader
    implements RecordAccess.Loader<Long, PropertyRecord, PrimitiveRecord> {
        private final RecordAccess.Loader<Long, PropertyRecord, PrimitiveRecord> actual = Loaders.propertyLoader(null);

        private PropertyRecordLoader() {
        }

        public PropertyRecord newUnused(Long key, PrimitiveRecord additionalData) {
            return (PropertyRecord)this.actual.newUnused((Object)key, (Object)additionalData);
        }

        public PropertyRecord load(Long key, PrimitiveRecord additionalData) {
            return null;
        }

        public void ensureHeavy(PropertyRecord record) {
        }

        public PropertyRecord clone(PropertyRecord record) {
            return record.clone();
        }
    }

    private static class MyPrimitiveProxy
    implements RecordAccess.RecordProxy<Long, NodeRecord, Void> {
        private final NodeRecord record = new NodeRecord(5L);
        private boolean changed;

        MyPrimitiveProxy() {
            this.record.setInUse(true);
        }

        public Long getKey() {
            return this.record.getId();
        }

        public NodeRecord forChangingLinkage() {
            this.changed = true;
            return this.record;
        }

        public NodeRecord forChangingData() {
            this.changed = true;
            return this.record;
        }

        public NodeRecord forReadingLinkage() {
            return this.record;
        }

        public NodeRecord forReadingData() {
            return this.record;
        }

        public Void getAdditionalData() {
            return null;
        }

        public NodeRecord getBefore() {
            return this.record;
        }

        public boolean isChanged() {
            return this.changed;
        }

        public boolean isCreated() {
            return false;
        }
    }

    private static class ExpectedRecord {
        private final ExpectedProperty[] properties;

        ExpectedRecord(ExpectedProperty ... properties) {
            this.properties = properties;
        }
    }

    private static class ExpectedProperty {
        private final int key;
        private final Object value;

        ExpectedProperty(int key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

