/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.concurrent.CountDownLatch;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.neo4j.kernel.impl.util.DebugUtil;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.OtherThreadRule;

public class DebugUtilTest {
    private static final String THE_OTHER_THREAD_NAME = "TheOtherThread";
    @Rule
    public final TestName testName = new TestName();
    @Rule
    public final OtherThreadRule<Void> t2 = new OtherThreadRule("TheOtherThread");

    @Test
    public void shouldFigureOutThatThisIsATest() {
        Assert.assertThat((Object)DebugUtil.trackTest(), (Matcher)CoreMatchers.containsString((String)this.testName.getMethodName()));
        Assert.assertThat((Object)DebugUtil.trackTest(), (Matcher)CoreMatchers.containsString((String)this.getClass().getSimpleName()));
    }

    @Test
    public void shouldFigureOutThatWeStartedInATest() throws Exception {
        new Noise().white();
    }

    @Test
    public void shouldDumpThreads() throws Exception {
        ByteArrayOutputStream capturedOut = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(capturedOut);
        final CountDownLatch latch = new CountDownLatch(1);
        this.t2.execute(new OtherThreadExecutor.WorkerCommand<Void, Void>(){

            @Override
            public Void doWork(Void state) throws Exception {
                DoubleLatch.awaitLatch(latch);
                return null;
            }
        });
        this.t2.get().waitUntilThreadState(Thread.State.WAITING, Thread.State.TIMED_WAITING);
        DebugUtil.dumpThreads((PrintStream)out);
        latch.countDown();
        out.flush();
        String dump = capturedOut.toString();
        Assert.assertTrue((boolean)dump.contains("main"));
        Assert.assertTrue((boolean)dump.contains(DebugUtilTest.class.getName()));
        Assert.assertTrue((boolean)dump.contains(this.testName.getMethodName()));
        Assert.assertTrue((boolean)dump.contains(THE_OTHER_THREAD_NAME));
        Assert.assertTrue((boolean)dump.contains("doWork"));
    }

    private class Noise {
        private Noise() {
        }

        void white() {
            Assert.assertThat((Object)DebugUtil.trackTest(), (Matcher)CoreMatchers.containsString((String)DebugUtilTest.this.testName.getMethodName()));
            Assert.assertThat((Object)DebugUtil.trackTest(), (Matcher)CoreMatchers.containsString((String)DebugUtilTest.class.getSimpleName()));
        }
    }
}

