/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.dbstructure;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.util.dbstructure.DbStructureArgumentFormatter;

public class DbStructureArgumentFormatterTest {
    @Test
    public void shouldFormatNull() {
        Assert.assertEquals((Object)"null", (Object)this.formatArgument(null));
    }

    @Test
    public void shouldFormatInts() {
        Assert.assertEquals((Object)"0", (Object)this.formatArgument(0));
        Assert.assertEquals((Object)"1", (Object)this.formatArgument(1));
        Assert.assertEquals((Object)"-1", (Object)this.formatArgument(-1));
    }

    @Test
    public void shouldFormatLongs() {
        Assert.assertEquals((Object)"0l", (Object)this.formatArgument(0L));
        Assert.assertEquals((Object)"-1l", (Object)this.formatArgument(-1L));
        Assert.assertEquals((Object)"1l", (Object)this.formatArgument(1L));
    }

    @Test
    public void shouldFormatDoubles() {
        Assert.assertEquals((Object)"1.0d", (Object)this.formatArgument(1.0));
        Assert.assertEquals((Object)"Double.NaN", (Object)this.formatArgument(Double.NaN));
        Assert.assertEquals((Object)"Double.POSITIVE_INFINITY", (Object)this.formatArgument(Double.POSITIVE_INFINITY));
        Assert.assertEquals((Object)"Double.NEGATIVE_INFINITY", (Object)this.formatArgument(Double.NEGATIVE_INFINITY));
    }

    @Test
    public void shouldFormatIndexDescriptors() {
        Assert.assertEquals((Object)"new IndexDescriptor( 23, 42 )", (Object)this.formatArgument(new IndexDescriptor(23, 42)));
    }

    @Test
    public void shouldFormatUniquenessConstraints() {
        Assert.assertEquals((Object)"new UniquenessConstraint( 23, 42 )", (Object)this.formatArgument(new UniquenessConstraint(23, 42)));
    }

    private String formatArgument(Object arg) {
        StringBuilder builder = new StringBuilder();
        try {
            DbStructureArgumentFormatter.INSTANCE.formatArgument((Appendable)builder, arg);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return builder.toString();
    }
}

