/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableVersionableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.CheckPoint;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;
import org.neo4j.kernel.recovery.LatestCheckPointFinder;

@RunWith(value=Parameterized.class)
public class LatestCheckPointFinderTest {
    private final PhysicalLogFiles logFiles = (PhysicalLogFiles)Mockito.mock(PhysicalLogFiles.class);
    private final FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
    private final LogEntryReader<ReadableLogChannel> reader = (LogEntryReader)Mockito.mock(LogEntryReader.class);
    private final int startLogVersion;
    private final int endLogVersion;

    public LatestCheckPointFinderTest(Integer startLogVersion, Integer endLogVersion) {
        this.startLogVersion = startLogVersion;
        this.endLogVersion = endLogVersion;
    }

    @Parameterized.Parameters(name="{0},{1}")
    public static Collection<Object[]> params() {
        return Arrays.asList({0, 1}, {42, 43});
    }

    @Test
    public void noLogFilesFound() throws Throwable {
        int logVersion = this.startLogVersion;
        Mockito.when((Object)this.logFiles.getLogFileForVersion((long)logVersion)).thenReturn(Mockito.mock(File.class));
        Mockito.when((Object)this.fs.fileExists((File)Matchers.any(File.class))).thenReturn((Object)false);
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find((long)logVersion);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(null, false, -1L), (Object)latestCheckPoint);
    }

    @Test
    public void oneLogFileNoCheckPoints() throws Throwable {
        int logVersion = this.startLogVersion;
        this.setupLogFiles(logVersion, logVersion);
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find((long)logVersion);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(null, false, (long)logVersion), (Object)latestCheckPoint);
    }

    @Test
    public void oneLogFileNoCheckPointsOneStart() throws Throwable {
        int logVersion = this.startLogVersion;
        this.setupLogFiles(logVersion, logVersion);
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        LogEntryStart start = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition((long)logVersion, 16L));
        Mockito.when((Object)this.reader.readLogEntry((ReadableLogChannel)Matchers.any(ReadableLogChannel.class))).thenReturn((Object)start, (Object[])new LogEntry[]{null});
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find((long)logVersion);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(null, true, (long)logVersion), (Object)latestCheckPoint);
    }

    @Test
    public void twoLogFilesNoCheckPoints() throws Throwable {
        this.setupLogFiles(this.startLogVersion, this.endLogVersion);
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find((long)this.endLogVersion);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(null, false, (long)this.startLogVersion), (Object)latestCheckPoint);
    }

    @Test
    public void twoLogFilesNoCheckPointsOneStart() throws Throwable {
        this.setupLogFiles(this.startLogVersion, this.endLogVersion);
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        LogEntryStart start = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition((long)this.endLogVersion, 16L));
        Mockito.when((Object)this.reader.readLogEntry((ReadableLogChannel)Matchers.any(ReadableLogChannel.class))).thenReturn((Object)start, null);
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find((long)this.endLogVersion);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(null, true, (long)this.startLogVersion), (Object)latestCheckPoint);
    }

    @Test
    public void latestLogFileContainingACheckPointOnly() throws Throwable {
        this.setupLogFiles(this.startLogVersion, this.endLogVersion);
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        CheckPoint checkPoint = new CheckPoint(new LogPosition((long)this.endLogVersion, 33L));
        Mockito.when((Object)this.reader.readLogEntry((ReadableLogChannel)Matchers.any(ReadableVersionableLogChannel.class))).thenReturn((Object)checkPoint, null);
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find((long)this.endLogVersion);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(checkPoint, false, (long)this.endLogVersion), (Object)latestCheckPoint);
    }

    @Test
    public void latestLogFileContainingACheckPointAndAStartBefore() throws Throwable {
        this.setupLogFiles(this.startLogVersion, this.endLogVersion);
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        LogEntryStart start = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition((long)this.endLogVersion, 16L));
        CheckPoint checkPoint = new CheckPoint(new LogPosition((long)this.endLogVersion, 33L));
        Mockito.when((Object)this.reader.readLogEntry((ReadableLogChannel)Matchers.any(ReadableLogChannel.class))).thenReturn((Object)start, (Object[])new LogEntry[]{checkPoint, null});
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find((long)this.endLogVersion);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(checkPoint, false, (long)this.endLogVersion), (Object)latestCheckPoint);
    }

    @Test
    public void latestLogFileContainingACheckPointAndAStartAfter() throws Throwable {
        this.setupLogFiles(this.startLogVersion, this.endLogVersion);
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        CheckPoint checkPoint = new CheckPoint(new LogPosition((long)this.endLogVersion, 16L));
        LogEntryStart start = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition((long)this.endLogVersion, 33L));
        Mockito.when((Object)this.reader.readLogEntry((ReadableLogChannel)Matchers.any(ReadableLogChannel.class))).thenReturn((Object)start, (Object[])new LogEntry[]{checkPoint, null});
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find((long)this.endLogVersion);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(checkPoint, true, (long)this.endLogVersion), (Object)latestCheckPoint);
    }

    @Test
    public void latestLogFileContainingACheckPointAndAStartAtSamePosition() throws Throwable {
        this.setupLogFiles(this.startLogVersion, this.endLogVersion);
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        CheckPoint checkPoint = new CheckPoint(new LogPosition((long)this.endLogVersion, 16L));
        LogEntryStart start = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition((long)this.endLogVersion, 16L));
        Mockito.when((Object)this.reader.readLogEntry((ReadableLogChannel)Matchers.any(ReadableLogChannel.class))).thenReturn((Object)start, (Object[])new LogEntry[]{checkPoint, null});
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find((long)this.endLogVersion);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(checkPoint, true, (long)this.endLogVersion), (Object)latestCheckPoint);
    }

    @Test
    public void latestLogFileContainingMultipleCheckPointsOneStartInBetween() throws Throwable {
        this.setupLogFiles(this.startLogVersion, this.endLogVersion);
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        LogEntryStart start = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition((long)this.endLogVersion, 22L));
        CheckPoint checkPoint = new CheckPoint(new LogPosition((long)this.endLogVersion, 33L));
        Mockito.when((Object)this.reader.readLogEntry((ReadableLogChannel)Matchers.any(ReadableVersionableLogChannel.class))).thenReturn(Mockito.mock(CheckPoint.class), (Object[])new LogEntry[]{start, checkPoint, null});
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find((long)this.endLogVersion);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(checkPoint, false, (long)this.endLogVersion), (Object)latestCheckPoint);
    }

    @Test
    public void latestLogFileContainingMultipleCheckPointsOneStartAfterBoth() throws Throwable {
        this.setupLogFiles(this.startLogVersion, this.endLogVersion);
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        CheckPoint checkPoint = new CheckPoint(new LogPosition((long)this.endLogVersion, 22L));
        LogEntryStart start = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition((long)this.endLogVersion, 33L));
        Mockito.when((Object)this.reader.readLogEntry((ReadableLogChannel)Matchers.any(ReadableVersionableLogChannel.class))).thenReturn(Mockito.mock(CheckPoint.class), (Object[])new LogEntry[]{checkPoint, start, null});
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find((long)this.endLogVersion);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(checkPoint, true, (long)this.endLogVersion), (Object)latestCheckPoint);
    }

    @Test
    public void olderLogFileContainingACheckPointAndNewerFileContainingAStart() throws Throwable {
        this.setupLogFiles(this.startLogVersion, this.endLogVersion);
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        LogEntryStart start1 = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition((long)this.endLogVersion, 22L));
        LogEntryStart start2 = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition((long)this.startLogVersion, 16L));
        CheckPoint checkPoint = new CheckPoint(new LogPosition((long)this.startLogVersion, 33L));
        Mockito.when((Object)this.reader.readLogEntry((ReadableLogChannel)Matchers.any(ReadableVersionableLogChannel.class))).thenReturn((Object)start1, (Object[])new LogEntry[]{null, start2, checkPoint, null});
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find((long)this.endLogVersion);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(checkPoint, true, (long)this.startLogVersion), (Object)latestCheckPoint);
    }

    @Test
    public void olderLogFileContainingACheckPointAndNewerFileIsEmpty() throws Throwable {
        this.setupLogFiles(this.startLogVersion, this.endLogVersion);
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        LogEntryStart start = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition((long)this.startLogVersion, 16L));
        CheckPoint checkPoint = new CheckPoint(new LogPosition((long)this.startLogVersion, 33L));
        Mockito.when((Object)this.reader.readLogEntry((ReadableLogChannel)Matchers.any(ReadableVersionableLogChannel.class))).thenReturn(null, (Object[])new LogEntry[]{start, checkPoint, null});
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find((long)this.endLogVersion);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(checkPoint, false, (long)this.startLogVersion), (Object)latestCheckPoint);
    }

    @Test
    public void olderLogFileContainingAStartAndNewerFileContainingACheckPointPointingToAPreviousPositionThanStart() throws Throwable {
        this.setupLogFiles(this.startLogVersion, this.endLogVersion);
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        LogEntryStart start = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition((long)this.startLogVersion, 22L));
        CheckPoint checkPoint = new CheckPoint(new LogPosition((long)this.startLogVersion, 16L));
        Mockito.when((Object)this.reader.readLogEntry((ReadableLogChannel)Matchers.any(ReadableVersionableLogChannel.class))).thenReturn((Object)checkPoint, (Object[])new LogEntry[]{start, null});
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find((long)this.endLogVersion);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(checkPoint, true, (long)this.endLogVersion), (Object)latestCheckPoint);
    }

    @Test
    public void olderLogFileContainingAStartAndNewerFileContainingACheckPointPointingToALaterPositionThanStart() throws Throwable {
        this.setupLogFiles(this.startLogVersion, this.endLogVersion);
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        LogEntryStart start = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition((long)this.startLogVersion, 22L));
        CheckPoint checkPoint = new CheckPoint(new LogPosition((long)this.startLogVersion, 25L));
        Mockito.when((Object)this.reader.readLogEntry((ReadableLogChannel)Matchers.any(ReadableVersionableLogChannel.class))).thenReturn((Object)checkPoint, (Object[])new LogEntry[]{start, null});
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find((long)this.endLogVersion);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(checkPoint, false, (long)this.endLogVersion), (Object)latestCheckPoint);
    }

    @Test
    public void latestLogEmptyStartEntryBeforeAndAfterCheckPointInTheLastButOneLog() throws Throwable {
        this.setupLogFiles(this.startLogVersion, this.endLogVersion);
        LatestCheckPointFinder finder = new LatestCheckPointFinder(this.logFiles, this.fs, this.reader);
        LogEntryStart firstStart = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition((long)this.startLogVersion, 20L));
        LogEntryStart secondStart = new LogEntryStart(0, 0, 0L, 0L, new byte[0], new LogPosition((long)this.startLogVersion, 27L));
        CheckPoint checkPoint = new CheckPoint(new LogPosition((long)this.startLogVersion, 25L));
        Mockito.when((Object)this.reader.readLogEntry((ReadableLogChannel)Matchers.any(ReadableLogChannel.class))).thenReturn(null, (Object[])new LogEntry[]{firstStart, checkPoint, secondStart, null});
        LatestCheckPointFinder.LatestCheckPoint latestCheckPoint = finder.find((long)this.endLogVersion);
        Assert.assertEquals((Object)new LatestCheckPointFinder.LatestCheckPoint(checkPoint, true, (long)this.startLogVersion), (Object)latestCheckPoint);
    }

    private void setupLogFiles(int startLogVersion, int endLogVersion) throws IOException {
        Mockito.when((Object)this.fs.fileExists((File)Matchers.any(File.class))).thenReturn((Object)false);
        int i = startLogVersion;
        while (i <= endLogVersion) {
            File file = (File)Mockito.mock(File.class);
            Mockito.when((Object)this.fs.fileExists(file)).thenReturn((Object)true);
            Mockito.when((Object)this.logFiles.getLogFileForVersion((long)i)).thenReturn((Object)file);
            StoreChannel channel = (StoreChannel)Mockito.mock(StoreChannel.class);
            Mockito.when((Object)this.fs.open((File)Matchers.eq((Object)file), Matchers.anyString())).thenReturn((Object)channel);
            final int version = i++;
            Mockito.when((Object)channel.read((ByteBuffer)Matchers.any(ByteBuffer.class))).thenAnswer((Answer)new Answer<Object>(){

                public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                    ByteBuffer buffer = (ByteBuffer)invocationOnMock.getArguments()[0];
                    buffer.putLong(LogHeaderWriter.encodeLogVersion((long)version));
                    buffer.putLong(33L);
                    return 16;
                }
            });
        }
        if (startLogVersion > 0) {
            File file = (File)Mockito.mock(File.class);
            Mockito.when((Object)this.logFiles.getLogFileForVersion((long)(startLogVersion - 1))).thenReturn((Object)file);
        }
    }
}

