/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.junit.rules.ExternalResource;

public class CleanupRule
extends ExternalResource {
    private static final String[] COMMON_CLOSE_METHOD_NAMES = new String[]{"close", "stop", "shutdown", "shutDown"};
    private final LinkedList<AutoCloseable> toCloseAfterwards = new LinkedList();

    protected void after() {
        for (AutoCloseable toClose : this.toCloseAfterwards) {
            try {
                toClose.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public <T extends AutoCloseable> T add(T toClose) {
        this.toCloseAfterwards.addFirst(toClose);
        return toClose;
    }

    public <T> T add(T toClose) {
        Class<?> cls = toClose.getClass();
        for (String methodName : COMMON_CLOSE_METHOD_NAMES) {
            try {
                Method method = cls.getMethod(methodName, new Class[0]);
                method.setAccessible(true);
                this.add(this.closeable(method, toClose));
                return toClose;
            }
            catch (NoSuchMethodException e) {
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("No suitable close method found on " + toClose + ", which is a " + cls);
    }

    private AutoCloseable closeable(final Method method, final Object target) {
        return new AutoCloseable(){

            @Override
            public void close() throws IOException {
                try {
                    method.invoke(target, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

