/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class FailureOutput
implements TestRule {
    private final ByteArrayOutputStream output = new ByteArrayOutputStream();
    private final PrintStream stream = new PrintStream(this.output);
    private final PrintStream target;

    public FailureOutput() {
        this(System.out);
    }

    public FailureOutput(PrintStream target) {
        this.target = target;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    base.evaluate();
                }
                catch (Throwable failure) {
                    FailureOutput.this.printOutput();
                    throw failure;
                }
            }
        };
    }

    private void printOutput() throws IOException {
        this.target.write(this.output.toByteArray());
        this.target.flush();
    }

    public PrintStream stream() {
        return this.stream;
    }

    public PrintWriter writer() {
        return new PrintWriter(this.stream);
    }
}

