/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.Iterator;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.neo4j.helpers.collection.Iterables;

public class IterableMatcher<T>
extends TypeSafeMatcher<Iterable<T>> {
    private final Iterable<T> toMatch;

    private IterableMatcher(Iterable<T> toMatch) {
        this.toMatch = toMatch;
    }

    protected boolean matchesSafely(Iterable<T> objects) {
        if (Iterables.count(this.toMatch) != Iterables.count(objects)) {
            return false;
        }
        Iterator<T> original = this.toMatch.iterator();
        Iterator<T> matched = objects.iterator();
        while (original.hasNext() && matched.hasNext()) {
            T fromToMatch;
            T fromOriginal = original.next();
            if (fromOriginal.equals(fromToMatch = matched.next())) continue;
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendValueList("Iterable [", ",", "]", this.toMatch);
    }

    public static <T> IterableMatcher<T> matchesIterable(Iterable<T> toMatch) {
        return new IterableMatcher<T>(toMatch);
    }
}

