/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.neo4j.test.AsciiDocGenerator;
import org.neo4j.test.GraphDefinition;
import org.neo4j.test.TestData;

public class JavaTestDocsGenerator
extends AsciiDocGenerator {
    public static final TestData.Producer<JavaTestDocsGenerator> PRODUCER = new TestData.Producer<JavaTestDocsGenerator>(){

        @Override
        public JavaTestDocsGenerator create(GraphDefinition graph, String title, String documentation) {
            return (JavaTestDocsGenerator)new JavaTestDocsGenerator(title).description(documentation);
        }

        @Override
        public void destroy(JavaTestDocsGenerator product, boolean successful) {
        }
    };

    public JavaTestDocsGenerator(String title) {
        super(title, "docs");
    }

    public void document(String directory, String sectionName) {
        this.setSection(sectionName);
        String name = this.title.replace(" ", "-").toLowerCase();
        File dir = new File(new File(directory), this.section);
        String filename = name + ".asciidoc";
        Writer fw = JavaTestDocsGenerator.getFW(dir, filename);
        this.description = this.replaceSnippets(this.description, dir, name);
        try {
            this.line(fw, "[[" + sectionName + "-" + name.replaceAll("\\(|\\)", "") + "]]");
            String firstChar = this.title.substring(0, 1).toUpperCase();
            this.line(fw, firstChar + this.title.substring(1));
            for (int i = 0; i < this.title.length(); ++i) {
                fw.append("=");
            }
            fw.append("\n");
            this.line(fw, "");
            this.line(fw, this.description);
            this.line(fw, "");
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addImageSnippet(String tagName, String imageName, String title) {
        this.addSnippet(tagName, "\nimage:" + imageName + "[" + title + "]\n");
    }
}

