/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.Closeable;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.neo4j.function.Predicate;
import org.neo4j.logging.Logger;

public class OtherThreadExecutor<T>
implements ThreadFactory,
Closeable {
    private final ExecutorService commandExecutor = Executors.newSingleThreadExecutor(this);
    protected final T state;
    private volatile Thread thread;
    private volatile ExecutionState executionState;
    private final String name;
    private final long timeout;
    private Exception lastExecutionTrigger;

    public static Predicate<Thread> anyThreadState(Thread.State ... possibleStates) {
        return new AnyThreadState(possibleStates);
    }

    public Predicate<Thread> orExecutionCompleted(final Predicate<Thread> actual) {
        return new Predicate<Thread>(){

            public boolean test(Thread thread) {
                return actual.test((Object)thread) || OtherThreadExecutor.this.executionState == ExecutionState.EXECUTED;
            }

            public String toString() {
                return "(" + actual.toString() + ") or execution completed.";
            }
        };
    }

    public OtherThreadExecutor(String name, T initialState) {
        this(name, 10L, TimeUnit.SECONDS, initialState);
    }

    public OtherThreadExecutor(String name, long timeout, TimeUnit unit, T initialState) {
        this.name = name;
        this.state = initialState;
        this.timeout = TimeUnit.MILLISECONDS.convert(timeout, unit);
    }

    public <R> Future<R> executeDontWait(final WorkerCommand<T, R> cmd) {
        this.lastExecutionTrigger = new Exception();
        this.executionState = ExecutionState.REQUESTED_EXECUTION;
        return this.commandExecutor.submit(new Callable<R>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public R call() throws Exception {
                OtherThreadExecutor.this.executionState = ExecutionState.EXECUTING;
                try {
                    Object r = cmd.doWork(OtherThreadExecutor.this.state);
                    return r;
                }
                finally {
                    OtherThreadExecutor.this.executionState = ExecutionState.EXECUTED;
                }
            }
        });
    }

    public <R> R execute(WorkerCommand<T, R> cmd) throws Exception {
        return this.executeDontWait(cmd).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R execute(WorkerCommand<T, R> cmd, long timeout, TimeUnit unit) throws Exception {
        Future<R> future = this.executeDontWait(cmd);
        boolean success = false;
        try {
            this.awaitStartExecuting();
            R result = future.get(timeout, unit);
            success = true;
            R r = result;
            return r;
        }
        finally {
            if (!success) {
                future.cancel(true);
            }
        }
    }

    void awaitStartExecuting() throws InterruptedException {
        while (this.executionState == ExecutionState.REQUESTED_EXECUTION) {
            Thread.sleep(10L);
        }
    }

    public <R> R awaitFuture(Future<R> future) throws InterruptedException, ExecutionException, TimeoutException {
        return future.get(this.timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread;
        this.thread = thread = new Thread(r, this.getClass().getName() + ":" + this.name){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    super.run();
                }
                finally {
                    OtherThreadExecutor.this.thread = null;
                }
            }
        };
        return thread;
    }

    public String toString() {
        Thread thread = this.thread;
        return String.format("%s[%s,state=%s]", this.getClass().getSimpleName(), this.name, thread == null ? "dead" : thread.getState());
    }

    public WaitDetails waitUntilWaiting() throws TimeoutException {
        return this.waitUntilThreadState(Thread.State.WAITING, Thread.State.TIMED_WAITING);
    }

    public WaitDetails waitUntilBlocked() throws TimeoutException {
        return this.waitUntilThreadState(Thread.State.BLOCKED);
    }

    public WaitDetails waitUntilThreadState(Thread.State ... possibleStates) throws TimeoutException {
        return this.waitUntil(new AnyThreadState(possibleStates));
    }

    public WaitDetails waitUntil(Predicate<Thread> condition) throws TimeoutException {
        long end = System.currentTimeMillis() + this.timeout;
        Thread thread = this.getThread();
        while (!condition.test((Object)thread) || this.executionState == ExecutionState.REQUESTED_EXECUTION) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (System.currentTimeMillis() <= end) continue;
            throw new TimeoutException("The executor didn't meet condition '" + condition + "' inside an executing command for " + this.timeout + " ms");
        }
        if (this.executionState == ExecutionState.EXECUTED) {
            throw new IllegalStateException("Would have wanted " + thread + " to wait for " + condition + " but that never happened within the duration of executed task");
        }
        return new WaitDetails(thread.getStackTrace());
    }

    public Thread.State state() {
        return this.thread.getState();
    }

    private Thread getThread() {
        Thread thread = null;
        while (thread == null) {
            thread = this.thread;
        }
        return thread;
    }

    @Override
    public void close() {
        this.commandExecutor.shutdown();
        try {
            this.commandExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (!this.commandExecutor.isTerminated()) {
            this.commandExecutor.shutdownNow();
        }
    }

    public void dump(Logger logger) {
        logger.log(this.getClass().getName() + ", " + this + " state:" + this.state + " thread:" + this.thread + " execution:" + (Object)((Object)this.executionState));
        if (this.thread != null) {
            logger.log("Thread state:" + (Object)((Object)this.thread.getState()));
            logger.log("");
            for (StackTraceElement element : this.thread.getStackTrace()) {
                logger.log(element.toString());
            }
        } else {
            logger.log("No operations performed yet, so no thread");
        }
        if (this.lastExecutionTrigger != null) {
            logger.log("");
            logger.log("Last execution triggered from:");
            for (StackTraceElement element : this.lastExecutionTrigger.getStackTrace()) {
                logger.log(element.toString());
            }
        }
    }

    public void interrupt() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    void printStackTrace(PrintStream out) {
        Thread thread = this.getThread();
        out.println(thread);
        for (StackTraceElement trace : thread.getStackTrace()) {
            out.println("\tat " + trace);
        }
    }

    public static class WaitDetails {
        private final StackTraceElement[] stackTrace;

        public WaitDetails(StackTraceElement[] stackTrace) {
            this.stackTrace = stackTrace;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (StackTraceElement element : this.stackTrace) {
                builder.append(String.format(element.toString() + "%n", new Object[0]));
            }
            return builder.toString();
        }

        public boolean isAt(Class<?> clz, String method) {
            for (StackTraceElement element : this.stackTrace) {
                if (!element.getClassName().equals(clz.getName()) || !element.getMethodName().equals(method)) continue;
                return true;
            }
            return false;
        }
    }

    public static interface WorkerCommand<T, R> {
        public R doWork(T var1) throws Exception;
    }

    private static enum ExecutionState {
        REQUESTED_EXECUTION,
        EXECUTING,
        EXECUTED;

    }

    private static final class AnyThreadState
    implements Predicate<Thread> {
        private final Set<Thread.State> possibleStates;
        private final Set<Thread.State> seenStates = new HashSet<Thread.State>();

        private AnyThreadState(Thread.State ... possibleStates) {
            this.possibleStates = new HashSet<Thread.State>(Arrays.asList(possibleStates));
        }

        public boolean test(Thread thread) {
            Thread.State threadState = thread.getState();
            this.seenStates.add(threadState);
            return this.possibleStates.contains((Object)threadState);
        }

        public String toString() {
            return "Any of thread states " + this.possibleStates + ", but saw " + this.seenStates;
        }
    }
}

