/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.neo4j.helpers.FutureAdapter;
import org.neo4j.test.ProcessStreamHandler;

public class ProcessUtil {
    public static void executeSubProcess(Class<?> mainClass, long timeout, TimeUnit unit, String ... arguments) throws Exception {
        Future<Integer> future = ProcessUtil.startSubProcess(mainClass, arguments);
        int result = future.get(timeout, unit);
        if (result != 0) {
            throw new RuntimeException("Process for " + mainClass + " with arguments " + Arrays.toString(arguments) + " failed, returned exit value " + result);
        }
    }

    public static Future<Integer> startSubProcess(Class<?> mainClass, String ... arguments) throws IOException {
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList("java", "-cp", System.getProperty("java.class.path"), mainClass.getName()));
        args.addAll(Arrays.asList(arguments));
        Process process = Runtime.getRuntime().exec(args.toArray(new String[args.size()]));
        final ProcessStreamHandler processOutput = new ProcessStreamHandler(process, false);
        processOutput.launch();
        final Future realFuture = FutureAdapter.processFuture((Process)process);
        return new Future<Integer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                try {
                    boolean bl = realFuture.cancel(mayInterruptIfRunning);
                    return bl;
                }
                finally {
                    processOutput.done();
                }
            }

            @Override
            public boolean isCancelled() {
                return realFuture.isCancelled();
            }

            @Override
            public boolean isDone() {
                return realFuture.isDone();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer get() throws InterruptedException, ExecutionException {
                try {
                    Integer n = (Integer)realFuture.get();
                    return n;
                }
                finally {
                    processOutput.done();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Integer get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                try {
                    Integer n = (Integer)realFuture.get(timeout, unit);
                    return n;
                }
                finally {
                    processOutput.done();
                }
            }
        };
    }
}

