/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import org.junit.Ignore;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.test.GraphDefinition;
import org.neo4j.test.GraphDescription;

@Ignore(value="this is not a test, it is a testing utility")
public class TestData<T>
implements TestRule {
    private final Producer<T> producer;
    private final ThreadLocal<Lazy> product = new InheritableThreadLocal<Lazy>();
    private static final String EMPTY = "";

    public static <T> TestData<T> producedThrough(Producer<T> transformation) {
        transformation.getClass();
        return new TestData<T>(transformation);
    }

    public T get() {
        return this.get(true);
    }

    private TestData(Producer<T> producer) {
        this.producer = producer;
    }

    public Statement apply(final Statement base, final Description description) {
        final Title title = (Title)description.getAnnotation(Title.class);
        final Documented doc = (Documented)description.getAnnotation(Documented.class);
        GraphDescription.Graph g = (GraphDescription.Graph)description.getAnnotation(GraphDescription.Graph.class);
        if (g == null) {
            g = description.getTestClass().getAnnotation(GraphDescription.Graph.class);
        }
        final GraphDescription graph = GraphDescription.create(g);
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                TestData.this.product.set(TestData.create(graph, title == null ? null : title.value(), doc == null ? null : doc.value(), description.getMethodName()));
                try {
                    try {
                        base.evaluate();
                    }
                    catch (Throwable err) {
                        try {
                            TestData.this.destroy(TestData.this.get(false), false);
                        }
                        catch (Throwable sub) {
                            ArrayList<Throwable> failures = new ArrayList<Throwable>();
                            if (err instanceof MultipleFailureException) {
                                failures.addAll(((MultipleFailureException)err).getFailures());
                            } else {
                                failures.add(err);
                            }
                            failures.add(sub);
                            throw new MultipleFailureException(failures);
                        }
                        throw err;
                    }
                    TestData.this.destroy(TestData.this.get(false), false);
                }
                finally {
                    TestData.this.product.set(null);
                }
            }
        };
    }

    private void destroy(T product, boolean successful) {
        if (product != null) {
            this.producer.destroy(product, successful);
        }
    }

    private T get(boolean create) {
        Lazy lazy = this.product.get();
        if (lazy == null) {
            if (create) {
                throw new IllegalStateException("Not in test case");
            }
            return null;
        }
        return lazy.get(this.producer, create);
    }

    private static Lazy create(GraphDescription graph, String title, String doc, String methodName) {
        if (doc != null) {
            int dot;
            if (title == null && (dot = doc.indexOf(46)) > 0) {
                title = doc.substring(0, dot);
                if (title.contains("\n")) {
                    title = null;
                } else {
                    title = title.trim();
                    doc = doc.substring(dot + 1);
                }
            }
            String[] lines = doc.split("\n");
            int indent = Integer.MAX_VALUE;
            int start = 0;
            int end = 0;
            for (int i = 0; i < lines.length; ++i) {
                if (EMPTY.equals(lines[i].trim())) {
                    lines[i] = EMPTY;
                    if (start != i) continue;
                    end = ++start;
                    continue;
                }
                for (int j = 0; j < lines[i].length(); ++j) {
                    if (Character.isWhitespace(lines[i].charAt(j))) continue;
                    indent = Math.min(indent, j);
                    break;
                }
                end = i;
            }
            if (end == lines.length) {
                --end;
            }
            if (title == null && start < end && EMPTY.equals(lines[start + 1])) {
                title = lines[start].trim();
                start += 2;
            }
            StringBuilder documentation = new StringBuilder();
            for (int i = start; i <= end; ++i) {
                documentation.append(EMPTY.equals(lines[i]) ? EMPTY : lines[i].substring(indent)).append("\n");
            }
            doc = documentation.toString();
        } else {
            doc = EMPTY;
        }
        if (title == null) {
            title = methodName.replace("_", " ");
        }
        return new Lazy(graph, title, doc);
    }

    private static final class Factory {
        private final GraphDefinition graph;
        private final String title;
        private final String documentation;

        Factory(GraphDefinition graph, String title, String documentation) {
            this.graph = graph;
            this.title = title;
            this.documentation = documentation;
        }

        Object create(Producer<?> producer, boolean create) {
            return create ? producer.create(this.graph, this.title, this.documentation) : null;
        }
    }

    private static final class Lazy {
        private volatile Object productOrFactory;

        Lazy(GraphDefinition graph, String title, String documentation) {
            this.productOrFactory = new Factory(graph, title, documentation);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <T> T get(Producer<T> producer, boolean create) {
            Object result = this.productOrFactory;
            if (result instanceof Factory) {
                Lazy lazy = this;
                synchronized (lazy) {
                    result = this.productOrFactory;
                    if (result instanceof Factory) {
                        this.productOrFactory = result = ((Factory)result).create(producer, create);
                    }
                }
            }
            return (T)result;
        }
    }

    public static interface Producer<T> {
        public T create(GraphDefinition var1, String var2, String var3);

        public void destroy(T var1, boolean var2);
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Title {
        public String value();
    }
}

