/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.util.Map;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseFactoryState;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.security.URLAccessRule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.factory.CommunityFacadeFactory;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.impl.logging.AbstractLogService;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.TestGraphDatabaseBuilder;
import org.neo4j.test.TestGraphDatabaseFactoryState;
import org.neo4j.udc.UsageDataKeys;

public class TestGraphDatabaseFactory
extends GraphDatabaseFactory {
    public TestGraphDatabaseFactory() {
        super((GraphDatabaseFactoryState)new TestGraphDatabaseFactoryState());
        this.setUserLogProvider((LogProvider)NullLogProvider.getInstance());
    }

    public GraphDatabaseService newImpermanentDatabase() {
        return this.newImpermanentDatabaseBuilder().newGraphDatabase();
    }

    public GraphDatabaseService newImpermanentDatabase(File storeDir) {
        return this.newImpermanentDatabaseBuilder(storeDir).newGraphDatabase();
    }

    public GraphDatabaseService newImpermanentDatabase(Map<Setting<?>, String> config) {
        GraphDatabaseBuilder builder = this.newImpermanentDatabaseBuilder();
        for (Map.Entry<Setting<?>, String> entry : config.entrySet()) {
            builder.setConfig(entry.getKey(), entry.getValue());
        }
        return builder.newGraphDatabase();
    }

    public GraphDatabaseBuilder newImpermanentDatabaseBuilder() {
        return this.newImpermanentDatabaseBuilder(ImpermanentGraphDatabase.PATH);
    }

    protected void configure(GraphDatabaseBuilder builder) {
        super.configure(builder);
        builder.setConfig(GraphDatabaseSettings.pagecache_memory, "8m");
    }

    protected TestGraphDatabaseFactoryState getCurrentState() {
        return (TestGraphDatabaseFactoryState)super.getCurrentState();
    }

    protected TestGraphDatabaseFactoryState getStateCopy() {
        return new TestGraphDatabaseFactoryState(this.getCurrentState());
    }

    public FileSystemAbstraction getFileSystem() {
        return this.getCurrentState().getFileSystem();
    }

    public TestGraphDatabaseFactory setFileSystem(FileSystemAbstraction fileSystem) {
        this.getCurrentState().setFileSystem(fileSystem);
        return this;
    }

    public GraphDatabaseFactory setMonitors(Monitors monitors) {
        this.getCurrentState().setMonitors(monitors);
        return this;
    }

    public TestGraphDatabaseFactory setUserLogProvider(LogProvider logProvider) {
        return (TestGraphDatabaseFactory)super.setUserLogProvider(logProvider);
    }

    public TestGraphDatabaseFactory setInternalLogProvider(LogProvider logProvider) {
        this.getCurrentState().setInternalLogProvider(logProvider);
        return this;
    }

    public TestGraphDatabaseFactory addKernelExtensions(Iterable<KernelExtensionFactory<?>> newKernelExtensions) {
        return (TestGraphDatabaseFactory)super.addKernelExtensions(newKernelExtensions);
    }

    public TestGraphDatabaseFactory addKernelExtension(KernelExtensionFactory<?> newKernelExtension) {
        return (TestGraphDatabaseFactory)super.addKernelExtension(newKernelExtension);
    }

    public TestGraphDatabaseFactory addURLAccessRule(String protocol, URLAccessRule rule) {
        return (TestGraphDatabaseFactory)super.addURLAccessRule(protocol, rule);
    }

    public GraphDatabaseBuilder newImpermanentDatabaseBuilder(File storeDir) {
        TestGraphDatabaseFactoryState state = this.getStateCopy();
        GraphDatabaseBuilder.DatabaseCreator creator = this.createImpermanentDatabaseCreator(storeDir, state);
        TestGraphDatabaseBuilder builder = this.createImpermanentGraphDatabaseBuilder(creator);
        this.configure(builder);
        return builder;
    }

    protected TestGraphDatabaseBuilder createImpermanentGraphDatabaseBuilder(GraphDatabaseBuilder.DatabaseCreator creator) {
        return new TestGraphDatabaseBuilder(creator);
    }

    protected GraphDatabaseBuilder.DatabaseCreator createImpermanentDatabaseCreator(final File storeDir, final TestGraphDatabaseFactoryState state) {
        return new GraphDatabaseBuilder.DatabaseCreator(){

            public GraphDatabaseService newDatabase(Map<String, String> config) {
                return new CommunityFacadeFactory(){

                    protected PlatformModule createPlatform(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies, GraphDatabaseFacade graphDatabaseFacade, UsageDataKeys.OperationalMode operationalMode) {
                        return new ImpermanentGraphDatabase.ImpermanentPlatformModule(storeDir, params, dependencies, graphDatabaseFacade){

                            @Override
                            protected FileSystemAbstraction createFileSystemAbstraction() {
                                FileSystemAbstraction fs = state.getFileSystem();
                                if (fs != null) {
                                    return fs;
                                }
                                return super.createFileSystemAbstraction();
                            }

                            @Override
                            protected LogService createLogService(LogProvider logProvider) {
                                final LogProvider internalLogProvider = state.getInternalLogProvider();
                                if (internalLogProvider == null) {
                                    return super.createLogService(logProvider);
                                }
                                final LogProvider userLogProvider = state.databaseDependencies().userLogProvider();
                                return new AbstractLogService(){

                                    public LogProvider getUserLogProvider() {
                                        return userLogProvider;
                                    }

                                    public LogProvider getInternalLogProvider() {
                                        return internalLogProvider;
                                    }
                                };
                            }
                        };
                    }
                }.newFacade(storeDir, config, (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies((GraphDatabaseFacadeFactory.Dependencies)state.databaseDependencies()));
            }
        };
    }
}

