/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.unsafe.impl.batchimport.CalculateDenseNodesStep;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.staging.Step;

public class CalculateDenseNodesStepTest {
    @Test
    public void shouldPreventMultipleConcurrentProcessorsForAnyGivenRadixBatchSparse() throws Exception {
        StageControl control = new StageControl(){

            public void panic(Throwable cause) {
                cause.printStackTrace();
            }
        };
        Configuration config = Configuration.DEFAULT;
        NodeRelationshipCache cache = new NodeRelationshipCache(NumberArrayFactory.HEAP, -1);
        CalculateDenseNodesStep step = new CalculateDenseNodesStep(control, config, cache);
        step.start(0);
        this.maxOutNumberOfProcessors((Step<?>)step);
        long[] ids = this.batchOfIdsWithRadix(3);
        int numberOfBatches = 100;
        for (int i = 0; i < numberOfBatches; ++i) {
            step.receive((long)i, (Object)ids);
        }
        step.endOfUpstream();
        this.waitUntilCompleted((Step<?>)step);
        for (long id : ids) {
            Assert.assertEquals((long)numberOfBatches, (long)cache.getCount(id, 0, null));
        }
    }

    private void waitUntilCompleted(Step<?> step) throws InterruptedException {
        while (!step.isCompleted()) {
            Thread.sleep(1L);
        }
    }

    private long[] batchOfIdsWithRadix(int radixOutOfTen) {
        long[] ids = new long[1000];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = i * 10 + radixOutOfTen;
        }
        return ids;
    }

    private void maxOutNumberOfProcessors(Step<?> step) {
        for (int i = 0; i < 100 && step.incrementNumberOfProcessors(); ++i) {
        }
    }
}

