/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.ParallelizeByNodeIdStep;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.Configuration;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class ParallelizeByNodeIdStepTest {
    private final StageControl control = (StageControl)Mockito.mock(StageControl.class);
    private final BatchSender sender = (BatchSender)Mockito.mock(BatchSender.class);

    @Test
    public void shouldDetectABA() throws Throwable {
        ParallelizeByNodeIdStep step = new ParallelizeByNodeIdStep(this.control, Configuration.DEFAULT);
        int batchSize = Configuration.DEFAULT.batchSize();
        Batch a = new Batch((Object[])new InputRelationship[batchSize]);
        this.setIds(a, 0L, 2L, batchSize * 2);
        Batch b = new Batch((Object[])new InputRelationship[batchSize]);
        this.setIds(b, 1L, 2L, batchSize * 2);
        Batch aa = new Batch((Object[])new InputRelationship[batchSize]);
        this.setIds(aa, 0L, 2L, batchSize * 2);
        Batch bb = new Batch((Object[])new InputRelationship[batchSize]);
        this.setIds(bb, 1L, 2L, batchSize * 2);
        step.process((Object)a, this.sender);
        step.process((Object)b, this.sender);
        step.process((Object)aa, this.sender);
        step.process((Object)bb, this.sender);
        Assert.assertTrue((boolean)a.parallelizableWithPrevious);
        Assert.assertTrue((boolean)b.parallelizableWithPrevious);
        Assert.assertFalse((boolean)aa.parallelizableWithPrevious);
        Assert.assertTrue((boolean)bb.parallelizableWithPrevious);
    }

    @Test
    public void shouldSkipReservervedId() throws Throwable {
        ParallelizeByNodeIdStep step = new ParallelizeByNodeIdStep(this.control, Configuration.DEFAULT, 4294843839L);
        int batchSize = Configuration.DEFAULT.batchSize();
        Batch batch = new Batch((Object[])new InputRelationship[batchSize]);
        batch.ids = new long[]{1L};
        batch.sortedIds = (long[])batch.ids.clone();
        while (batch.firstRecordId < 0xFFFFFFFFL) {
            step.process((Object)batch, this.sender);
            Assert.assertFalse((String)("Batch got first id " + batch.firstRecordId + " which contains the reserved id"), (boolean)this.idWithin(0xFFFFFFFFL, batch.firstRecordId, batch.firstRecordId + (long)batchSize));
        }
        Assert.assertTrue((batch.firstRecordId > 0xFFFFFFFFL ? 1 : 0) != 0);
    }

    private boolean idWithin(long id, long low, long high) {
        return id >= low && id <= high;
    }

    private void setIds(Batch<?, ?> batch, long first, long stride, int count) {
        batch.ids = new long[count];
        long value = first;
        for (int i = 0; i < count; ++i) {
            batch.ids[i] = value;
            value += stride;
        }
        batch.sortedIds = (long[])batch.ids.clone();
        Arrays.sort(batch.sortedIds);
    }
}

