/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.EmbeddedDatabaseRule;

public class IdReuseTest {
    @Rule
    public EmbeddedDatabaseRule dbRule = new EmbeddedDatabaseRule(IdReuseTest.class);

    @Test
    public void shouldReuseNodeIdsFromRolledBackTransaction() throws Exception {
        Node node;
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.failure();
        }
        db = this.dbRule.restartDatabase();
        try (Transaction tx = db.beginTx();){
            node = db.createNode();
            tx.success();
        }
        Assert.assertThat((Object)node.getId(), (Matcher)Matchers.equalTo((Object)0L));
    }

    @Test
    public void shouldReuseRelationshipIdsFromRolledBackTransaction() throws Exception {
        Relationship relationship;
        Node node2;
        Node node1;
        GraphDatabaseService db = this.dbRule.getGraphDatabaseService();
        try (Transaction tx = db.beginTx();){
            node1 = db.createNode();
            node2 = db.createNode();
            tx.success();
        }
        tx = db.beginTx();
        var5_3 = null;
        try {
            node1.createRelationshipTo(node2, (RelationshipType)DynamicRelationshipType.withName((String)"LIKE"));
            tx.failure();
        }
        catch (Throwable throwable) {
            var5_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var5_3.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
        db = this.dbRule.restartDatabase();
        try (Transaction tx = db.beginTx();){
            node1 = db.getNodeById(node1.getId());
            node2 = db.getNodeById(node2.getId());
            relationship = node1.createRelationshipTo(node2, (RelationshipType)DynamicRelationshipType.withName((String)"LIKE"));
            tx.success();
        }
        Assert.assertThat((Object)relationship.getId(), (Matcher)Matchers.equalTo((Object)0L));
    }
}

