/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Iterator;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Resource;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.util.PrimitiveLongResourceIterator;

public class Neo4jMockitoHelpers {
    public static final Resource NO_RESOURCE = new Resource(){

        public void close() {
        }
    };

    public static <T> Answer<Iterator<T>> answerAsIteratorFrom(final Iterable<T> values) {
        return new Answer<Iterator<T>>(){

            public Iterator<T> answer(InvocationOnMock invocation) throws Throwable {
                return values.iterator();
            }
        };
    }

    public static Answer<PrimitiveLongIterator> answerAsPrimitiveLongIteratorFrom(final Iterable<Long> values) {
        return new Answer<PrimitiveLongIterator>(){

            public PrimitiveLongResourceIterator answer(InvocationOnMock invocation) throws Throwable {
                return IteratorUtil.resourceIterator((PrimitiveLongIterator)PrimitiveLongCollections.toPrimitiveIterator(values.iterator()), (Resource)NO_RESOURCE);
            }
        };
    }

    public static Answer<PrimitiveIntIterator> answerAsPrimitiveIntIteratorFrom(final Iterable<Integer> values) {
        return new Answer<PrimitiveIntIterator>(){

            public PrimitiveIntIterator answer(InvocationOnMock invocation) throws Throwable {
                return PrimitiveIntCollections.toPrimitiveIterator(values.iterator());
            }
        };
    }
}

