/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.function.BiFunction;
import org.neo4j.function.Function;
import org.neo4j.function.Function2;
import org.neo4j.helpers.Functions;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Settings;

public class FunctionsTest {
    @Test
    public void testMap() throws Exception {
        Assert.assertThat((Object)Functions.map((Map)MapUtil.stringMap((String[])new String[]{"foo", "bar"})).apply((Object)"foo"), (Matcher)CoreMatchers.equalTo((Object)"bar"));
    }

    @Test
    public void testWithDefaults() throws Exception {
        Assert.assertThat((Object)org.neo4j.function.Functions.withDefaults((Function)Functions.map((Map)MapUtil.stringMap((String[])new String[]{"foo", "bar"})), (Function)org.neo4j.function.Functions.nullFunction()).apply((Object)"foo"), (Matcher)CoreMatchers.equalTo((Object)"bar"));
        Assert.assertThat((Object)org.neo4j.function.Functions.withDefaults((Function)Functions.map((Map)MapUtil.stringMap((String[])new String[]{"foo", "bar"})), (Function)Functions.map((Map)MapUtil.stringMap((String[])new String[]{"foo", "xyzzy"}))).apply((Object)"foo"), (Matcher)CoreMatchers.equalTo((Object)"xyzzy"));
    }

    @Test
    public void testNullFunction() throws Exception {
        Assert.assertThat((Object)org.neo4j.function.Functions.nullFunction().apply((Object)"foo"), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void testConstant() throws Exception {
        Assert.assertThat((Object)org.neo4j.function.Functions.constant((Object)"foo").apply((Object)"bar"), (Matcher)CoreMatchers.equalTo((Object)"foo"));
    }

    @Test
    public void testCompose2() throws Exception {
        BiFunction<Integer, Integer, Integer> add = new BiFunction<Integer, Integer, Integer>(){

            public Integer apply(Integer from1, Integer from2) {
                return from1 + from2;
            }
        };
        BiFunction<Integer, Integer, Integer> mult = new BiFunction<Integer, Integer, Integer>(){

            public Integer apply(Integer from1, Integer from2) {
                return from1 * from2;
            }
        };
        Assert.assertThat((Object)((Function2)org.neo4j.function.Functions.compose2().apply((Object)add, (Object)mult)).apply((Object)2, (Object)3), (Matcher)CoreMatchers.equalTo((Object)9));
    }

    @Test
    public void testCompose() throws Exception {
        Function<Integer, Integer> inc = new Function<Integer, Integer>(){

            public Integer apply(Integer value) {
                return value + 1;
            }
        };
        Assert.assertThat((Object)((Function)org.neo4j.function.Functions.compose().apply((Object)Settings.INTEGER, (Object)inc)).apply((Object)"3"), (Matcher)CoreMatchers.equalTo((Object)4));
    }
}

