/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.collection;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.collection.MultiSet;

public class MultiSetTest {
    @Test
    public void anEmptySetContainsNothing() {
        Object aValue = new Object();
        MultiSet emptyMultiSet = new MultiSet();
        Assert.assertTrue((boolean)emptyMultiSet.isEmpty());
        Assert.assertEquals((long)0L, (long)emptyMultiSet.size());
        Assert.assertEquals((long)0L, (long)emptyMultiSet.uniqueSize());
        Assert.assertFalse((boolean)emptyMultiSet.contains(aValue));
        Assert.assertEquals((long)0L, (long)emptyMultiSet.count(aValue));
    }

    @Test
    public void shouldAddAnElementToTheMultiSet() {
        MultiSet multiSet = new MultiSet();
        Object value = new Object();
        long count = multiSet.add(value);
        Assert.assertEquals((long)1L, (long)count);
        Assert.assertFalse((boolean)multiSet.isEmpty());
        Assert.assertEquals((long)1L, (long)multiSet.size());
        Assert.assertEquals((long)1L, (long)multiSet.uniqueSize());
        Assert.assertTrue((boolean)multiSet.contains(value));
        Assert.assertEquals((long)1L, (long)multiSet.count(value));
    }

    @Test
    public void shouldRemoveAnElementFromTheMultiSet() {
        MultiSet multiSet = new MultiSet();
        Object value = new Object();
        multiSet.add(value);
        long count = multiSet.remove(value);
        Assert.assertEquals((long)0L, (long)count);
        Assert.assertTrue((boolean)multiSet.isEmpty());
        Assert.assertEquals((long)0L, (long)multiSet.size());
        Assert.assertEquals((long)0L, (long)multiSet.uniqueSize());
        Assert.assertFalse((boolean)multiSet.contains(value));
        Assert.assertEquals((long)0L, (long)multiSet.count(value));
    }

    @Test
    public void shouldAddAnElementTwice() {
        MultiSet multiSet = new MultiSet();
        Object value = new Object();
        multiSet.add(value);
        long count = multiSet.add(value);
        Assert.assertEquals((long)2L, (long)count);
        Assert.assertFalse((boolean)multiSet.isEmpty());
        Assert.assertEquals((long)2L, (long)multiSet.size());
        Assert.assertEquals((long)1L, (long)multiSet.uniqueSize());
        Assert.assertTrue((boolean)multiSet.contains(value));
        Assert.assertEquals((long)2L, (long)multiSet.count(value));
    }

    @Test
    public void shouldRemoveAnElementWhenMultiElementArePresentInTheMultiSet() {
        MultiSet multiSet = new MultiSet();
        Object value = new Object();
        multiSet.add(value);
        multiSet.add(value);
        long count = multiSet.remove(value);
        Assert.assertEquals((long)1L, (long)count);
        Assert.assertFalse((boolean)multiSet.isEmpty());
        Assert.assertEquals((long)1L, (long)multiSet.size());
        Assert.assertEquals((long)1L, (long)multiSet.uniqueSize());
        Assert.assertTrue((boolean)multiSet.contains(value));
        Assert.assertEquals((long)1L, (long)multiSet.count(value));
    }

    @Test
    public void shouldClearTheMultiSet() {
        MultiSet multiSet = new MultiSet();
        Object value = new Object();
        multiSet.add(value);
        multiSet.add(value);
        multiSet.add(new Object());
        multiSet.clear();
        Assert.assertTrue((boolean)multiSet.isEmpty());
        Assert.assertEquals((long)0L, (long)multiSet.size());
        Assert.assertEquals((long)0L, (long)multiSet.uniqueSize());
        Assert.assertFalse((boolean)multiSet.contains(value));
        Assert.assertEquals((long)0L, (long)multiSet.count(value));
    }
}

