/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.IOException;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Logger;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.NeoStoreDataSourceRule;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.TargetDirectory;

public class NeoStoreDataSourceTest {
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public TargetDirectory.TestDirectory dir = TargetDirectory.testDirForTestWithEphemeralFS((EphemeralFileSystemAbstraction)this.fs.get(), this.getClass());
    @Rule
    public NeoStoreDataSourceRule ds = new NeoStoreDataSourceRule();
    @Rule
    public PageCacheRule pageCacheRule = new PageCacheRule();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void kernelHealthShouldBeHealedOnStart() throws Throwable {
        NeoStoreDataSource theDataSource = null;
        try {
            KernelHealth kernelHealth = new KernelHealth((KernelPanicEventGenerator)Mockito.mock(KernelPanicEventGenerator.class), NullLogProvider.getInstance().getLog(KernelHealth.class));
            theDataSource = this.ds.getDataSource(this.dir.graphDbDir(), (FileSystemAbstraction)this.fs.get(), this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fs.get()), MapUtil.stringMap((String[])new String[0]), kernelHealth);
            kernelHealth.panic(new Throwable());
            theDataSource.start();
            kernelHealth.assertHealthy(Throwable.class);
        }
        finally {
            if (theDataSource != null) {
                theDataSource.stop();
                theDataSource.shutdown();
            }
        }
    }

    @Test
    public void shouldLogCorrectTransactionLogDiagnosticsForNoTransactionLogs() throws Exception {
        NeoStoreDataSource dataSource = this.neoStoreDataSourceWithLogFilesContainingLowestTxId(this.noLogs());
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Logger logger = logProvider.getLog(this.getClass()).infoLogger();
        NeoStoreDataSource.Diagnostics.TRANSACTION_RANGE.dump(dataSource, logger);
        logProvider.assertContainsMessageContaining("No transactions");
    }

    @Test
    public void shouldLogCorrectTransactionLogDiagnosticsForTransactionsInOldestLog() throws Exception {
        long logVersion = 2L;
        long prevLogLastTxId = 45L;
        NeoStoreDataSource dataSource = this.neoStoreDataSourceWithLogFilesContainingLowestTxId(this.logWithTransactions(logVersion, prevLogLastTxId));
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Logger logger = logProvider.getLog(this.getClass()).infoLogger();
        NeoStoreDataSource.Diagnostics.TRANSACTION_RANGE.dump(dataSource, logger);
        logProvider.assertContainsMessageContaining("transaction " + (prevLogLastTxId + 1L));
        logProvider.assertContainsMessageContaining("version " + logVersion);
    }

    @Test
    public void shouldLogCorrectTransactionLogDiagnosticsForTransactionsInSecondOldestLog() throws Exception {
        long logVersion = 2L;
        long prevLogLastTxId = 45L;
        NeoStoreDataSource dataSource = this.neoStoreDataSourceWithLogFilesContainingLowestTxId(this.logWithTransactionsInNextToOldestLog(logVersion, prevLogLastTxId));
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Logger logger = logProvider.getLog(this.getClass()).infoLogger();
        NeoStoreDataSource.Diagnostics.TRANSACTION_RANGE.dump(dataSource, logger);
        logProvider.assertContainsMessageContaining("transaction " + (prevLogLastTxId + 1L));
        logProvider.assertContainsMessageContaining("version " + (logVersion + 1L));
    }

    private NeoStoreDataSource neoStoreDataSourceWithLogFilesContainingLowestTxId(PhysicalLogFiles files) {
        DependencyResolver resolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        Mockito.when((Object)resolver.resolveDependency(PhysicalLogFiles.class)).thenReturn((Object)files);
        NeoStoreDataSource dataSource = (NeoStoreDataSource)Mockito.mock(NeoStoreDataSource.class);
        Mockito.when((Object)dataSource.getDependencyResolver()).thenReturn((Object)resolver);
        return dataSource;
    }

    private PhysicalLogFiles noLogs() {
        PhysicalLogFiles files = (PhysicalLogFiles)Mockito.mock(PhysicalLogFiles.class);
        Mockito.when((Object)files.getLowestLogVersion()).thenReturn((Object)-1L);
        return files;
    }

    private PhysicalLogFiles logWithTransactions(long logVersion, long headerTxId) throws IOException {
        PhysicalLogFiles files = (PhysicalLogFiles)Mockito.mock(PhysicalLogFiles.class);
        Mockito.when((Object)files.getLowestLogVersion()).thenReturn((Object)logVersion);
        Mockito.when((Object)files.hasAnyTransaction(logVersion)).thenReturn((Object)true);
        Mockito.when((Object)files.versionExists(logVersion)).thenReturn((Object)true);
        Mockito.when((Object)files.extractHeader(logVersion)).thenReturn((Object)new LogHeader(LogEntryVersion.CURRENT.byteCode(), logVersion, headerTxId));
        return files;
    }

    private PhysicalLogFiles logWithTransactionsInNextToOldestLog(long logVersion, long prevLogLastTxId) throws IOException {
        PhysicalLogFiles files = this.logWithTransactions(logVersion + 1L, prevLogLastTxId);
        Mockito.when((Object)files.getLowestLogVersion()).thenReturn((Object)logVersion);
        Mockito.when((Object)files.hasAnyTransaction(logVersion)).thenReturn((Object)false);
        Mockito.when((Object)files.versionExists(logVersion)).thenReturn((Object)true);
        return files;
    }
}

