/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.IndexConfiguration;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.sampling.OnlineIndexSamplingJob;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.register.Register;

public class OnlineIndexSamplingJobTest {
    private final LogProvider logProvider = NullLogProvider.getInstance();
    private final IndexProxy indexProxy = (IndexProxy)Mockito.mock(IndexProxy.class);
    private final IndexStoreView indexStoreView = (IndexStoreView)Mockito.mock(IndexStoreView.class);
    private final IndexDescriptor indexDescriptor = new IndexDescriptor(1, 2);
    private final IndexReader indexReader = (IndexReader)Mockito.mock(IndexReader.class);
    private final long indexUniqueValues = 21L;
    private final long indexSize = 23L;

    @Test
    public void shouldSampleTheIndexAndStoreTheValueWhenTheIndexIsOnline() {
        OnlineIndexSamplingJob job = new OnlineIndexSamplingJob(this.indexProxy, this.indexStoreView, "Foo", this.logProvider);
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.ONLINE);
        job.run();
        ((IndexStoreView)Mockito.verify((Object)this.indexStoreView)).replaceIndexCounts(this.indexDescriptor, 21L, 23L, 23L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.indexStoreView});
    }

    @Test
    public void shouldSampleTheIndexButDoNotStoreTheValuesIfTheIndexIsNotOnline() {
        OnlineIndexSamplingJob job = new OnlineIndexSamplingJob(this.indexProxy, this.indexStoreView, "Foo", this.logProvider);
        Mockito.when((Object)this.indexProxy.getState()).thenReturn((Object)InternalIndexState.FAILED);
        job.run();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.indexStoreView});
    }

    @Before
    public void setup() throws IndexNotFoundKernelException {
        Mockito.when((Object)this.indexProxy.getDescriptor()).thenReturn((Object)this.indexDescriptor);
        Mockito.when((Object)this.indexProxy.config()).thenReturn((Object)new IndexConfiguration(false));
        Mockito.when((Object)this.indexProxy.newReader()).thenReturn((Object)this.indexReader);
        ((IndexReader)Mockito.doAnswer(this.answerWith(21L, 23L)).when((Object)this.indexReader)).sampleIndex((Register.DoubleLong.Out)Matchers.any(Register.DoubleLong.Out.class));
    }

    private Answer<Long> answerWith(final long indexUniqueValues, final long indexSize) {
        return new Answer<Long>(){

            public Long answer(InvocationOnMock invocationOnMock) throws Throwable {
                Register.DoubleLong.Out result = (Register.DoubleLong.Out)invocationOnMock.getArguments()[0];
                result.write(indexUniqueValues, indexSize);
                return indexSize;
            }
        };
    }
}

