/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.integrationtest;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import junit.framework.TestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.Neo4jTypes;
import org.neo4j.kernel.api.SchemaWriteOperations;
import org.neo4j.kernel.api.exceptions.schema.ProcedureConstraintViolation;
import org.neo4j.kernel.api.procedures.ProcedureSignature;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;

public class ProceduresKernelIT
extends KernelIntegrationTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private final ProcedureSignature signature = ProcedureSignature.procedureSignature((String[])new String[]{"example", "exampleProc"}).in("name", (Neo4jTypes.AnyType)Neo4jTypes.NTText).out("name", (Neo4jTypes.AnyType)Neo4jTypes.NTText).build();

    @Test
    public void shouldCreateProcedure() throws Throwable {
        SchemaWriteOperations ops = this.schemaWriteOperationsInNewTransaction();
        ops.procedureCreate(this.signature, "javascript", "emit(1);");
        Iterator all = ops.proceduresGetAll();
        MatcherAssert.assertThat((Object)IteratorUtil.asCollection((Iterator)all), (Matcher)Matchers.equalTo(Arrays.asList(this.signature)));
        this.commit();
        MatcherAssert.assertThat((Object)IteratorUtil.asCollection((Iterator)this.readOperationsInNewTransaction().proceduresGetAll()), (Matcher)Matchers.equalTo(Arrays.asList(this.signature)));
    }

    @Test
    public void shouldDropProcedure() throws Throwable {
        SchemaWriteOperations ops = this.schemaWriteOperationsInNewTransaction();
        ops.procedureCreate(this.signature, "javascript", "emit(1);");
        this.commit();
        ops = this.schemaWriteOperationsInNewTransaction();
        ops.procedureDrop(this.signature.name());
        Iterator all = ops.proceduresGetAll();
        MatcherAssert.assertThat((Object)IteratorUtil.asCollection((Iterator)all), (Matcher)Matchers.equalTo(Collections.emptyList()));
        this.commit();
        MatcherAssert.assertThat((Object)IteratorUtil.asCollection((Iterator)this.readOperationsInNewTransaction().proceduresGetAll()), (Matcher)Matchers.equalTo(Collections.emptyList()));
    }

    @Test
    public void shouldDropProcedureInSameTransaction() throws Throwable {
        SchemaWriteOperations ops = this.schemaWriteOperationsInNewTransaction();
        ops.procedureCreate(this.signature, "javascript", "emit(1);");
        ops.procedureDrop(this.signature.name());
        Iterator all = ops.proceduresGetAll();
        MatcherAssert.assertThat((Object)IteratorUtil.asCollection((Iterator)all), (Matcher)Matchers.equalTo(Collections.emptyList()));
        this.commit();
        MatcherAssert.assertThat((Object)IteratorUtil.asCollection((Iterator)this.readOperationsInNewTransaction().proceduresGetAll()), (Matcher)Matchers.equalTo(Collections.emptyList()));
    }

    @Test
    public void shouldGetProcedureByName() throws Throwable {
        this.shouldCreateProcedure();
        ProcedureSignature found = this.readOperationsInNewTransaction().procedureGet(new ProcedureSignature.ProcedureName(new String[]{"example"}, "exampleProc")).signature();
        MatcherAssert.assertThat((Object)found, (Matcher)CoreMatchers.equalTo((Object)found));
    }

    @Test
    public void nonexistentProcedureShouldReturnNull() throws Throwable {
        TestCase.assertNull((Object)this.readOperationsInNewTransaction().procedureGet(new ProcedureSignature.ProcedureName(new String[]{"example"}, "exampleProc")));
    }

    @Test
    public void droppingNonExistentProcedureShouldThrow() throws Throwable {
        this.exception.expect(ProcedureConstraintViolation.class);
        this.schemaWriteOperationsInNewTransaction().procedureDrop(new ProcedureSignature.ProcedureName(new String[]{"example"}, "exampleProc"));
    }
}

