/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.graphdb.Direction;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.constraints.RelationshipPropertyConstraint;
import org.neo4j.kernel.api.constraints.RelationshipPropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateVisitor;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.state.TxState;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import org.neo4j.kernel.impl.util.diffsets.ReadableDiffSets;
import org.neo4j.test.RandomizedTestRule;
import org.neo4j.test.RepeatRule;

public class TxStateTest {
    public final RandomizedTestRule random = new RandomizedTestRule();
    private final int labelId1 = 2;
    private final int labelId2 = 5;
    private final int propertyKeyId1 = 3;
    private final int propertyKeyId2 = 4;
    private final IndexDescriptor indexOn_1_1 = new IndexDescriptor(2, 3);
    private final IndexDescriptor indexOn_1_2 = new IndexDescriptor(2, 4);
    private final IndexDescriptor indexOn_2_1 = new IndexDescriptor(5, 3);
    private TransactionState state;

    @Rule
    public final TestRule repeatWithDifferentRandomization() {
        return RuleChain.outerRule((TestRule)new RepeatRule()).around((TestRule)this.random);
    }

    @Test
    public void shouldGetAddedLabels() throws Exception {
        this.state.nodeDoAddLabel(1, 0L);
        this.state.nodeDoAddLabel(1, 1L);
        this.state.nodeDoAddLabel(2, 1L);
        Set addedLabels = this.state.nodeStateLabelDiffSets(1L).getAdded();
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Integer[]{1, 2}), (Object)addedLabels);
    }

    @Test
    public void shouldGetRemovedLabels() throws Exception {
        this.state.nodeDoRemoveLabel(1, 0L);
        this.state.nodeDoRemoveLabel(1, 1L);
        this.state.nodeDoRemoveLabel(2, 1L);
        Set removedLabels = this.state.nodeStateLabelDiffSets(1L).getRemoved();
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Integer[]{1, 2}), (Object)removedLabels);
    }

    @Test
    public void removeAddedLabelShouldRemoveFromAdded() throws Exception {
        this.state.nodeDoAddLabel(1, 0L);
        this.state.nodeDoAddLabel(1, 1L);
        this.state.nodeDoAddLabel(2, 1L);
        this.state.nodeDoRemoveLabel(1, 1L);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Integer[]{2}), (Object)this.state.nodeStateLabelDiffSets(1L).getAdded());
    }

    @Test
    public void addRemovedLabelShouldRemoveFromRemoved() throws Exception {
        this.state.nodeDoRemoveLabel(1, 0L);
        this.state.nodeDoRemoveLabel(1, 1L);
        this.state.nodeDoRemoveLabel(2, 1L);
        this.state.nodeDoAddLabel(1, 1L);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Integer[]{2}), (Object)this.state.nodeStateLabelDiffSets(1L).getRemoved());
    }

    @Test
    public void shouldMapFromRemovedLabelToNodes() throws Exception {
        this.state.nodeDoRemoveLabel(1, 0L);
        this.state.nodeDoRemoveLabel(2, 0L);
        this.state.nodeDoRemoveLabel(1, 1L);
        this.state.nodeDoRemoveLabel(3, 1L);
        this.state.nodeDoRemoveLabel(2, 2L);
        Set nodes = this.state.nodesWithLabelChanged(2).getRemoved();
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{0L, 2L}), (Object)IteratorUtil.asSet((Iterable)nodes));
    }

    @Test
    public void shouldAddAndGetByLabel() throws Exception {
        this.state.indexRuleDoAdd(this.indexOn_1_1);
        this.state.indexRuleDoAdd(this.indexOn_2_1);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new IndexDescriptor[]{this.indexOn_1_1}), (Object)this.state.indexDiffSetsByLabel(2).getAdded());
    }

    @Test
    public void shouldAddAndGetByRuleId() throws Exception {
        this.state.indexRuleDoAdd(this.indexOn_1_1);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new IndexDescriptor[]{this.indexOn_1_1}), (Object)this.state.indexChanges().getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForScanOrSeekOnAnEmptyTxState() throws Exception {
        ReadableDiffSets diffSets = this.state.indexUpdatesForScanOrSeek(this.indexOn_1_1, null);
        Assert.assertTrue((boolean)diffSets.isEmpty());
    }

    @Test
    public void shouldComputeIndexUpdatesForScanWhenThereAreNewNodes() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withDefaultStringProperties(42L, 43L);
        this.addNodesToIndex(this.indexOn_1_2).withDefaultStringProperties(44L);
        ReadableDiffSets diffSets = this.state.indexUpdatesForScanOrSeek(this.indexOn_1_1, null);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{42L, 43L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForSeekWhenThereAreNewNodes() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withDefaultStringProperties(42L, 43L);
        this.addNodesToIndex(this.indexOn_1_2).withDefaultStringProperties(44L);
        ReadableDiffSets diffSets = this.state.indexUpdatesForScanOrSeek(this.indexOn_1_1, (Object)"value43");
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{43L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWhenThereAreNoMatchingNodes() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)550)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)44L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, (Number)660, false, (Number)800, true);
        Assert.assertEquals(Collections.emptySet(), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWhenThereAreNewNodesCreatedInSingleBatch() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)550)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)44L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, (Number)510, true, (Number)600, true);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{43L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWhenThereAreNewNodesCreatedInTwoBatches() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Collections.singletonList(Pair.of((Object)42L, (Object)500)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)44L, (Object)520)));
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Collections.singletonList(Pair.of((Object)43L, (Object)550)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, (Number)510, true, (Number)600, true);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{43L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWithIncludeLowerAndIncludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)510), Pair.of((Object)44L, (Object)520), Pair.of((Object)45L, (Object)530), Pair.of((Object)47L, (Object)540), Pair.of((Object)48L, (Object)550), Pair.of((Object)49L, (Object)560)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)46L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, (Number)510, true, (Number)550, true);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{43L, 44L, 45L, 47L, 48L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWithIncludeLowerAndExcludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)510), Pair.of((Object)44L, (Object)520), Pair.of((Object)45L, (Object)530), Pair.of((Object)47L, (Object)540), Pair.of((Object)48L, (Object)550), Pair.of((Object)49L, (Object)560)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)46L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, (Number)510, true, (Number)550, false);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{43L, 44L, 45L, 47L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWithExcludeLowerAndIncludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)510), Pair.of((Object)44L, (Object)520), Pair.of((Object)45L, (Object)530), Pair.of((Object)47L, (Object)540), Pair.of((Object)48L, (Object)550), Pair.of((Object)49L, (Object)560)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)46L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, (Number)510, false, (Number)550, true);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{44L, 45L, 47L, 48L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWithExcludeLowerAndExcludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)510), Pair.of((Object)44L, (Object)520), Pair.of((Object)45L, (Object)530), Pair.of((Object)47L, (Object)540), Pair.of((Object)48L, (Object)550), Pair.of((Object)49L, (Object)560)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)46L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, (Number)510, false, (Number)550, false);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{44L, 45L, 47L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWithUnboundedLowerExcludeLowerAndIncludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)510), Pair.of((Object)44L, (Object)520), Pair.of((Object)45L, (Object)530), Pair.of((Object)47L, (Object)540), Pair.of((Object)48L, (Object)550), Pair.of((Object)49L, (Object)560)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)46L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, null, false, (Number)550, true);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{42L, 43L, 44L, 45L, 47L, 48L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWithUnboundedLowerIncludeLowerAndIncludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)510), Pair.of((Object)44L, (Object)520), Pair.of((Object)45L, (Object)530), Pair.of((Object)47L, (Object)540), Pair.of((Object)48L, (Object)550), Pair.of((Object)49L, (Object)560)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)46L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, null, true, (Number)550, true);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{42L, 43L, 44L, 45L, 47L, 48L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWithUnboundedLowerExcludeLowerAndExcludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)510), Pair.of((Object)44L, (Object)520), Pair.of((Object)45L, (Object)530), Pair.of((Object)47L, (Object)540), Pair.of((Object)48L, (Object)550), Pair.of((Object)49L, (Object)560)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)46L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, null, false, (Number)550, false);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{42L, 43L, 44L, 45L, 47L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWithUnboundedLowerIncludeLowerAndExcludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)510), Pair.of((Object)44L, (Object)520), Pair.of((Object)45L, (Object)530), Pair.of((Object)47L, (Object)540), Pair.of((Object)48L, (Object)550), Pair.of((Object)49L, (Object)560)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)46L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, null, true, (Number)550, false);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{42L, 43L, 44L, 45L, 47L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWithUnboundedUpperIncludeLowerAndIncludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)510), Pair.of((Object)44L, (Object)520), Pair.of((Object)45L, (Object)530), Pair.of((Object)47L, (Object)540), Pair.of((Object)48L, (Object)550), Pair.of((Object)49L, (Object)560)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)46L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, (Number)540, true, null, true);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{47L, 48L, 49L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWithUnboundedUpperIncludeLowerAndExcludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)510), Pair.of((Object)44L, (Object)520), Pair.of((Object)45L, (Object)530), Pair.of((Object)47L, (Object)540), Pair.of((Object)48L, (Object)550), Pair.of((Object)49L, (Object)560)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)46L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, (Number)540, true, null, false);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{47L, 48L, 49L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWithUnboundedUpperExcludeLowerAndIncludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)510), Pair.of((Object)44L, (Object)520), Pair.of((Object)45L, (Object)530), Pair.of((Object)47L, (Object)540), Pair.of((Object)48L, (Object)550), Pair.of((Object)49L, (Object)560)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)46L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, (Number)540, false, null, true);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{48L, 49L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWithUnboundedUpperExcludeLowerAndExcludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)510), Pair.of((Object)44L, (Object)520), Pair.of((Object)45L, (Object)530), Pair.of((Object)47L, (Object)540), Pair.of((Object)48L, (Object)550), Pair.of((Object)49L, (Object)560)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)46L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, (Number)540, false, null, false);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{48L, 49L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByNumberWithNoBounds() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withNumberProperties(Arrays.asList(Pair.of((Object)42L, (Object)500), Pair.of((Object)43L, (Object)510), Pair.of((Object)44L, (Object)520)));
        this.addNodesToIndex(this.indexOn_1_2).withNumberProperties(Collections.singletonList(Pair.of((Object)46L, (Object)520)));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByNumber(this.indexOn_1_1, null, true, null, true);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{42L, 43L, 44L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWhenThereAreNoMatchingNodes() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Barbara")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)44L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, "Cindy", false, "William", true);
        Assert.assertEquals(Collections.emptySet(), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWhenThereAreNewNodesCreatedInSingleBatch() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Barbara")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)44L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, "Amy", true, "Cathy", true);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{43L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWhenThereAreNewNodesCreatedInTwoBatches() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Collections.singletonList(Pair.of((Object)42L, (Object)"Agatha")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)44L, (Object)"Andreas")));
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Collections.singletonList(Pair.of((Object)43L, (Object)"Barbara")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, "Amy", true, "Cathy", true);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{43L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWithIncludeLowerAndIncludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Amy"), Pair.of((Object)44L, (Object)"Andreas"), Pair.of((Object)45L, (Object)"Aristotle"), Pair.of((Object)47L, (Object)"Arthur"), Pair.of((Object)48L, (Object)"Arwen"), Pair.of((Object)49L, (Object)"Ashley")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)46L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, "Amy", true, "Arwen", true);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{43L, 44L, 45L, 47L, 48L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWithIncludeLowerAndExcludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Amy"), Pair.of((Object)44L, (Object)"Andreas"), Pair.of((Object)45L, (Object)"Aristotle"), Pair.of((Object)47L, (Object)"Arthur"), Pair.of((Object)48L, (Object)"Arwen"), Pair.of((Object)49L, (Object)"Ashley")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)46L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, "Amy", true, "Arwen", false);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{43L, 44L, 45L, 47L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWithExcludeLowerAndIncludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Amy"), Pair.of((Object)44L, (Object)"Andreas"), Pair.of((Object)45L, (Object)"Aristotle"), Pair.of((Object)47L, (Object)"Arthur"), Pair.of((Object)48L, (Object)"Arwen"), Pair.of((Object)49L, (Object)"Ashley")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)46L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, "Amy", false, "Arwen", true);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{44L, 45L, 47L, 48L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWithExcludeLowerAndExcludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Amy"), Pair.of((Object)44L, (Object)"Andreas"), Pair.of((Object)45L, (Object)"Aristotle"), Pair.of((Object)47L, (Object)"Arthur"), Pair.of((Object)48L, (Object)"Arwen"), Pair.of((Object)49L, (Object)"Ashley")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)46L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, "Amy", false, "Arwen", false);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{44L, 45L, 47L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWithUnboundedLowerExcludeLowerAndIncludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Amy"), Pair.of((Object)44L, (Object)"Andreas"), Pair.of((Object)45L, (Object)"Aristotle"), Pair.of((Object)47L, (Object)"Arthur"), Pair.of((Object)48L, (Object)"Arwen"), Pair.of((Object)49L, (Object)"Ashley")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)46L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, null, false, "Arwen", true);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{42L, 43L, 44L, 45L, 47L, 48L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWithUnboundedLowerIncludeLowerAndIncludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Amy"), Pair.of((Object)44L, (Object)"Andreas"), Pair.of((Object)45L, (Object)"Aristotle"), Pair.of((Object)47L, (Object)"Arthur"), Pair.of((Object)48L, (Object)"Arwen"), Pair.of((Object)49L, (Object)"Ashley")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)46L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, null, true, "Arwen", true);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{42L, 43L, 44L, 45L, 47L, 48L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWithUnboundedLowerExcludeLowerAndExcludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Amy"), Pair.of((Object)44L, (Object)"Andreas"), Pair.of((Object)45L, (Object)"Aristotle"), Pair.of((Object)47L, (Object)"Arthur"), Pair.of((Object)48L, (Object)"Arwen"), Pair.of((Object)49L, (Object)"Ashley")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)46L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, null, false, "Arwen", false);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{42L, 43L, 44L, 45L, 47L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWithUnboundedLowerIncludeLowerAndExcludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Amy"), Pair.of((Object)44L, (Object)"Andreas"), Pair.of((Object)45L, (Object)"Aristotle"), Pair.of((Object)47L, (Object)"Arthur"), Pair.of((Object)48L, (Object)"Arwen"), Pair.of((Object)49L, (Object)"Ashley")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)46L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, null, true, "Arwen", false);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{42L, 43L, 44L, 45L, 47L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWithUnboundedUpperIncludeLowerAndIncludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Amy"), Pair.of((Object)44L, (Object)"Andreas"), Pair.of((Object)45L, (Object)"Aristotle"), Pair.of((Object)47L, (Object)"Arthur"), Pair.of((Object)48L, (Object)"Arwen"), Pair.of((Object)49L, (Object)"Ashley")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)46L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, "Arthur", true, null, true);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{47L, 48L, 49L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWithUnboundedUpperIncludeLowerAndExcludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Amy"), Pair.of((Object)44L, (Object)"Andreas"), Pair.of((Object)45L, (Object)"Aristotle"), Pair.of((Object)47L, (Object)"Arthur"), Pair.of((Object)48L, (Object)"Arwen"), Pair.of((Object)49L, (Object)"Ashley")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)46L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, "Arthur", true, null, false);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{47L, 48L, 49L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWithUnboundedUpperExcludeLowerAndIncludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Amy"), Pair.of((Object)44L, (Object)"Andreas"), Pair.of((Object)45L, (Object)"Aristotle"), Pair.of((Object)47L, (Object)"Arthur"), Pair.of((Object)48L, (Object)"Arwen"), Pair.of((Object)49L, (Object)"Ashley")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)46L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, "Arthur", false, null, true);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{48L, 49L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWithUnboundedUpperExcludeLowerAndExcludeUpper() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Amy"), Pair.of((Object)44L, (Object)"Andreas"), Pair.of((Object)45L, (Object)"Aristotle"), Pair.of((Object)47L, (Object)"Arthur"), Pair.of((Object)48L, (Object)"Arwen"), Pair.of((Object)49L, (Object)"Ashley")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)46L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, "Arthur", false, null, false);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{48L, 49L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForBetweenRangeSeekByStringWithNoBounds() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withBooleanProperties(Arrays.asList(Pair.of((Object)39L, (Object)true), Pair.of((Object)38L, (Object)false)));
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)42L, (Object)"Agatha"), Pair.of((Object)43L, (Object)"Amy"), Pair.of((Object)44L, (Object)"Andreas")));
        this.addNodesToIndex(this.indexOn_1_2).withStringProperties(Collections.singletonList(Pair.of((Object)46L, (Object)"Andreas")));
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByString(this.indexOn_1_1, null, true, null, true);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{42L, 43L, 44L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForRangeSeekByPrefixWhenThereAreNoMatchingNodes() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withDefaultStringProperties(42L, 43L);
        this.addNodesToIndex(this.indexOn_1_2).withDefaultStringProperties(44L);
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByPrefix(this.indexOn_1_1, "eulav");
        Assert.assertEquals(Collections.emptySet(), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForRangeSeekByPrefixWhenThereAreNewNodesCreatedInOneBatch() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withDefaultStringProperties(42L, 43L);
        this.addNodesToIndex(this.indexOn_1_2).withDefaultStringProperties(44L);
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByPrefix(this.indexOn_1_1, "value");
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{42L, 43L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForRangeSeekByPrefixWhenThereArePartiallyMatchingNewNodes1() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)40L, (Object)"Aaron"), Pair.of((Object)41L, (Object)"Agatha"), Pair.of((Object)42L, (Object)"Andreas"), Pair.of((Object)43L, (Object)"Andrea"), Pair.of((Object)44L, (Object)"Aristotle"), Pair.of((Object)45L, (Object)"Barbara"), Pair.of((Object)46L, (Object)"Barbarella"), Pair.of((Object)47L, (Object)"Cinderella")));
        this.addNodesToIndex(this.indexOn_1_2).withDefaultStringProperties(44L);
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByPrefix(this.indexOn_1_1, "And");
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{42L, 43L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForRangeSeekByPrefixWhenThereArePartiallyMatchingNewNodes2() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)40L, (Object)"Aaron"), Pair.of((Object)41L, (Object)"Agatha"), Pair.of((Object)42L, (Object)"Andreas"), Pair.of((Object)43L, (Object)"Andrea"), Pair.of((Object)44L, (Object)"Aristotle"), Pair.of((Object)45L, (Object)"Barbara"), Pair.of((Object)46L, (Object)"Barbarella"), Pair.of((Object)47L, (Object)"Cinderella")));
        this.addNodesToIndex(this.indexOn_1_2).withDefaultStringProperties(44L);
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByPrefix(this.indexOn_1_1, "Bar");
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{45L, 46L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForRangeSeekByPrefixWhenThereArePartiallyMatchingLeadingNewNodes() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)40L, (Object)"Aaron"), Pair.of((Object)41L, (Object)"Agatha"), Pair.of((Object)42L, (Object)"Andreas"), Pair.of((Object)43L, (Object)"Andrea"), Pair.of((Object)44L, (Object)"Aristotle"), Pair.of((Object)45L, (Object)"Barbara"), Pair.of((Object)46L, (Object)"Barbarella"), Pair.of((Object)47L, (Object)"Cinderella")));
        this.addNodesToIndex(this.indexOn_1_2).withDefaultStringProperties(44L);
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByPrefix(this.indexOn_1_1, "Aa");
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{40L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForRangeSeekByPrefixWhenThereArePartiallyMatchingTrailingNewNodes() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withStringProperties(Arrays.asList(Pair.of((Object)40L, (Object)"Aaron"), Pair.of((Object)41L, (Object)"Agatha"), Pair.of((Object)42L, (Object)"Andreas"), Pair.of((Object)43L, (Object)"Andrea"), Pair.of((Object)44L, (Object)"Aristotle"), Pair.of((Object)45L, (Object)"Barbara"), Pair.of((Object)46L, (Object)"Barbarella"), Pair.of((Object)47L, (Object)"Cinderella")));
        this.addNodesToIndex(this.indexOn_1_2).withDefaultStringProperties(44L);
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByPrefix(this.indexOn_1_1, "Ci");
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{47L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldComputeIndexUpdatesForRangeSeekByPrefixWhenThereAreNewNodesCreatedInTwoBatches() throws Exception {
        this.addNodesToIndex(this.indexOn_1_1).withDefaultStringProperties(42L);
        this.addNodesToIndex(this.indexOn_1_2).withDefaultStringProperties(44L);
        this.addNodesToIndex(this.indexOn_1_1).withDefaultStringProperties(43L);
        ReadableDiffSets diffSets = this.state.indexUpdatesForRangeSeekByPrefix(this.indexOn_1_1, "value");
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new Long[]{42L, 43L}), (Object)diffSets.getAdded());
    }

    @Test
    public void shouldListNodeAsDeletedIfItIsDeleted() throws Exception {
        long nodeId = 1337L;
        this.state.nodeDoDelete(nodeId);
        Assert.assertThat((Object)IteratorUtil.asSet((Iterable)this.state.addedAndRemovedNodes().getRemoved()), (Matcher)IsEqual.equalTo((Object)IteratorUtil.asSet((Object[])new Long[]{nodeId})));
    }

    @Test
    public void shouldAddUniquenessConstraint() throws Exception {
        UniquenessConstraint constraint = new UniquenessConstraint(1, 17);
        this.state.constraintDoAdd(constraint, 7L);
        ReadableDiffSets diff = this.state.constraintsChangesForLabel(1);
        Assert.assertEquals(Collections.singleton(constraint), (Object)diff.getAdded());
        Assert.assertTrue((boolean)diff.getRemoved().isEmpty());
    }

    @Test
    public void addingUniquenessConstraintShouldBeIdempotent() throws Exception {
        UniquenessConstraint constraint1 = new UniquenessConstraint(1, 17);
        this.state.constraintDoAdd(constraint1, 7L);
        UniquenessConstraint constraint2 = new UniquenessConstraint(1, 17);
        this.state.constraintDoAdd(constraint2, 19L);
        Assert.assertEquals((Object)constraint1, (Object)constraint2);
        Assert.assertEquals(Collections.singleton(constraint1), (Object)this.state.constraintsChangesForLabel(1).getAdded());
    }

    @Test
    public void shouldDifferentiateBetweenUniquenessConstraintsForDifferentLabels() throws Exception {
        UniquenessConstraint constraint1 = new UniquenessConstraint(1, 17);
        this.state.constraintDoAdd(constraint1, 7L);
        UniquenessConstraint constraint2 = new UniquenessConstraint(2, 17);
        this.state.constraintDoAdd(constraint2, 19L);
        Assert.assertEquals(Collections.singleton(constraint1), (Object)this.state.constraintsChangesForLabel(1).getAdded());
        Assert.assertEquals(Collections.singleton(constraint2), (Object)this.state.constraintsChangesForLabel(2).getAdded());
    }

    @Test
    public void shouldAddRelationshipPropertyExistenceConstraint() {
        RelationshipPropertyExistenceConstraint constraint = new RelationshipPropertyExistenceConstraint(1, 42);
        this.state.constraintDoAdd(constraint);
        Assert.assertEquals(Collections.singleton(constraint), (Object)this.state.constraintsChangesForRelationshipType(1).getAdded());
    }

    @Test
    public void addingRelationshipPropertyExistenceConstraintConstraintShouldBeIdempotent() {
        RelationshipPropertyExistenceConstraint constraint1 = new RelationshipPropertyExistenceConstraint(1, 42);
        RelationshipPropertyExistenceConstraint constraint2 = new RelationshipPropertyExistenceConstraint(1, 42);
        this.state.constraintDoAdd(constraint1);
        this.state.constraintDoAdd(constraint2);
        Assert.assertEquals((Object)constraint1, (Object)constraint2);
        Assert.assertEquals(Collections.singleton(constraint1), (Object)this.state.constraintsChangesForRelationshipType(1).getAdded());
    }

    @Test
    public void shouldDropRelationshipPropertyExistenceConstraint() {
        RelationshipPropertyExistenceConstraint constraint = new RelationshipPropertyExistenceConstraint(1, 42);
        this.state.constraintDoAdd(constraint);
        this.state.constraintDoDrop((RelationshipPropertyConstraint)constraint);
        Assert.assertTrue((boolean)this.state.constraintsChangesForRelationshipType(1).isEmpty());
    }

    @Test
    public void shouldDifferentiateRelationshipPropertyExistenceConstraints() throws Exception {
        RelationshipPropertyExistenceConstraint constraint1 = new RelationshipPropertyExistenceConstraint(1, 11);
        RelationshipPropertyExistenceConstraint constraint2 = new RelationshipPropertyExistenceConstraint(1, 22);
        RelationshipPropertyExistenceConstraint constraint3 = new RelationshipPropertyExistenceConstraint(3, 33);
        this.state.constraintDoAdd(constraint1);
        this.state.constraintDoAdd(constraint2);
        this.state.constraintDoAdd(constraint3);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new RelationshipPropertyExistenceConstraint[]{constraint1, constraint2}), (Object)this.state.constraintsChangesForRelationshipType(1).getAdded());
        Assert.assertEquals(Collections.singleton(constraint1), (Object)this.state.constraintsChangesForRelationshipTypeAndProperty(1, 11).getAdded());
        Assert.assertEquals(Collections.singleton(constraint2), (Object)this.state.constraintsChangesForRelationshipTypeAndProperty(1, 22).getAdded());
        Assert.assertEquals(Collections.singleton(constraint3), (Object)this.state.constraintsChangesForRelationshipType(3).getAdded());
        Assert.assertEquals(Collections.singleton(constraint3), (Object)this.state.constraintsChangesForRelationshipTypeAndProperty(3, 33).getAdded());
    }

    @Test
    public void shouldListRelationshipsAsCreatedIfCreated() throws Exception {
        long relId = 10L;
        this.state.relationshipDoCreate(relId, 0, 1L, 2L);
        Assert.assertTrue((boolean)this.state.hasChanges());
        Assert.assertTrue((boolean)this.state.relationshipIsAddedInThisTx(relId));
    }

    @Test
    public void shouldGiveCorrectDegreeWhenAddingAndRemovingRelationships() throws Exception {
        int startNode = 1;
        int endNode = 2;
        int relType = 0;
        this.state.relationshipDoCreate(10L, relType, (long)startNode, (long)endNode);
        this.state.relationshipDoCreate(11L, relType, (long)startNode, (long)endNode);
        this.state.relationshipDoCreate(12L, relType + 1, (long)startNode, (long)endNode);
        this.state.relationshipDoCreate(13L, relType + 1, (long)endNode, (long)startNode);
        this.state.relationshipDoDelete(1337L, relType, (long)startNode, (long)endNode);
        this.state.relationshipDoDelete(1338L, relType + 1, (long)startNode, (long)startNode);
        Assert.assertEquals((long)12L, (long)this.state.augmentNodeDegree((long)startNode, 10, Direction.BOTH));
        Assert.assertEquals((long)10L, (long)this.state.augmentNodeDegree((long)startNode, 10, Direction.INCOMING));
        Assert.assertEquals((long)11L, (long)this.state.augmentNodeDegree((long)startNode, 10, Direction.BOTH, relType));
    }

    @Test
    public void shouldGiveCorrectRelationshipTypesForNode() throws Exception {
        int startNode = 1;
        int endNode = 2;
        int relType = 0;
        long relA = 10L;
        long relB = 11L;
        long relC = 12L;
        this.state.relationshipDoCreate(relA, relType, (long)startNode, (long)endNode);
        this.state.relationshipDoCreate(relB, relType, (long)startNode, (long)endNode);
        this.state.relationshipDoCreate(relC, relType + 1, (long)startNode, (long)endNode);
        this.state.relationshipDoDelete(relB, relType, (long)startNode, (long)endNode);
        this.state.relationshipDoDelete(relC, relType + 1, (long)startNode, (long)endNode);
        Assert.assertThat((Object)IteratorUtil.asList((PrimitiveIntIterator)this.state.nodeRelationshipTypes((long)startNode)), (Matcher)IsEqual.equalTo(Arrays.asList(relType)));
    }

    @Test
    public void shouldNotChangeRecordForCreatedAndDeletedNode() throws Exception {
        this.state.nodeDoCreate(0L);
        this.state.nodeDoDelete(0L);
        this.state.nodeDoCreate(1L);
        this.state.accept((TxStateVisitor)new TxStateVisitor.Adapter(){

            public void visitCreatedNode(long id) {
                Assert.assertEquals((String)"Should not create any other node than 1", (long)1L, (long)id);
            }

            public void visitDeletedNode(long id) {
                Assert.fail((String)"Should not delete any node");
            }
        });
    }

    @Test
    public void shouldVisitDeletedNode() throws Exception {
        this.state.nodeDoDelete(42L);
        this.state.accept((TxStateVisitor)new TxStateVisitor.Adapter(){

            public void visitDeletedNode(long id) {
                Assert.assertEquals((String)"Wrong deleted node id", (long)42L, (long)id);
            }
        });
    }

    @Test
    public void shouldReportDeletedNodeIfItWasCreatedAndDeletedInSameTx() {
        long nodeId = 42L;
        this.state.nodeDoCreate(nodeId);
        this.state.nodeDoDelete(nodeId);
        Assert.assertTrue((boolean)this.state.nodeIsDeletedInThisTx(nodeId));
    }

    @Test
    public void shouldNotReportDeletedNodeIfItIsNotDeleted() {
        long nodeId = 42L;
        this.state.nodeDoCreate(nodeId);
        Assert.assertFalse((boolean)this.state.nodeIsDeletedInThisTx(nodeId));
    }

    @Test
    public void shouldNotChangeRecordForCreatedAndDeletedRelationship() throws Exception {
        this.state.relationshipDoCreate(0L, 0, 1L, 2L);
        this.state.relationshipDoDelete(0L, 0, 1L, 2L);
        this.state.relationshipDoCreate(1L, 0, 2L, 3L);
        this.state.accept((TxStateVisitor)new TxStateVisitor.Adapter(){

            public void visitCreatedRelationship(long id, int type, long startNode, long endNode) {
                Assert.assertEquals((String)"Should not create any other relationship than 1", (long)1L, (long)id);
            }

            public void visitDeletedRelationship(long id) {
                Assert.fail((String)"Should not delete any relationship");
            }
        });
    }

    @Test
    public void shouldVisitDeletedRelationship() throws Exception {
        this.state.relationshipDoDelete(42L, 2, 3L, 4L);
        this.state.accept((TxStateVisitor)new TxStateVisitor.Adapter(){

            public void visitDeletedRelationship(long id) {
                Assert.assertEquals((String)"Wrong deleted relationship id", (long)42L, (long)id);
            }
        });
    }

    @Test
    public void shouldReportDeletedRelationshipIfItWasCreatedAndDeletedInSameTx() {
        long startNodeId = 1L;
        long relationshipId = 2L;
        int relationshipType = 3;
        long endNodeId = 4L;
        this.state.relationshipDoCreate(relationshipId, relationshipType, startNodeId, endNodeId);
        this.state.relationshipDoDelete(relationshipId, relationshipType, startNodeId, endNodeId);
        Assert.assertTrue((boolean)this.state.relationshipIsDeletedInThisTx(relationshipId));
    }

    @Test
    public void shouldNotReportDeletedRelationshipIfItIsNotDeleted() {
        long startNodeId = 1L;
        long relationshipId = 2L;
        int relationshipType = 3;
        long endNodeId = 4L;
        this.state.relationshipDoCreate(relationshipId, relationshipType, startNodeId, endNodeId);
        Assert.assertFalse((boolean)this.state.relationshipIsDeletedInThisTx(relationshipId));
    }

    @Test
    @RepeatRule.Repeat(times=100)
    public void shouldVisitCreatedNodesBeforeDeletedNodes() throws Exception {
        this.state.accept((TxStateVisitor)new VisitationOrder(this.random.nextInt(100)){

            @Override
            void createEarlyState() {
                TxStateTest.this.state.nodeDoCreate((long)TxStateTest.this.random.nextInt(0x100000));
            }

            @Override
            void createLateState() {
                TxStateTest.this.state.nodeDoDelete((long)TxStateTest.this.random.nextInt(0x100000));
            }

            public void visitCreatedNode(long id) {
                this.visitEarly();
            }

            public void visitDeletedNode(long id) {
                this.visitLate();
            }
        });
    }

    @Test
    @RepeatRule.Repeat(times=100)
    public void shouldVisitCreatedNodesBeforeCreatedRelationships() throws Exception {
        this.state.accept((TxStateVisitor)new VisitationOrder(this.random.nextInt(100)){

            @Override
            void createEarlyState() {
                TxStateTest.this.state.nodeDoCreate((long)TxStateTest.this.random.nextInt(0x100000));
            }

            @Override
            void createLateState() {
                TxStateTest.this.state.relationshipDoCreate((long)TxStateTest.this.random.nextInt(0x100000), TxStateTest.this.random.nextInt(128), (long)TxStateTest.this.random.nextInt(0x100000), (long)TxStateTest.this.random.nextInt(0x100000));
            }

            public void visitCreatedNode(long id) {
                this.visitEarly();
            }

            public void visitCreatedRelationship(long id, int type, long startNode, long endNode) {
                this.visitLate();
            }
        });
    }

    @Test
    @RepeatRule.Repeat(times=100)
    public void shouldVisitCreatedRelationshipsBeforeDeletedRelationships() throws Exception {
        this.state.accept((TxStateVisitor)new VisitationOrder(this.random.nextInt(100)){

            @Override
            void createEarlyState() {
                TxStateTest.this.state.relationshipDoCreate((long)TxStateTest.this.random.nextInt(0x100000), TxStateTest.this.random.nextInt(128), (long)TxStateTest.this.random.nextInt(0x100000), (long)TxStateTest.this.random.nextInt(0x100000));
            }

            @Override
            void createLateState() {
                TxStateTest.this.state.relationshipDoDelete((long)TxStateTest.this.random.nextInt(0x100000), TxStateTest.this.random.nextInt(128), (long)TxStateTest.this.random.nextInt(0x100000), (long)TxStateTest.this.random.nextInt(0x100000));
            }

            public void visitCreatedRelationship(long id, int type, long startNode, long endNode) {
                this.visitEarly();
            }

            public void visitDeletedRelationship(long id) {
                this.visitLate();
            }
        });
    }

    @Test
    @RepeatRule.Repeat(times=100)
    public void shouldVisitDeletedNodesAfterDeletedRelationships() throws Exception {
        this.state.accept((TxStateVisitor)new VisitationOrder(this.random.nextInt(100)){

            @Override
            void createEarlyState() {
                TxStateTest.this.state.relationshipDoCreate((long)TxStateTest.this.random.nextInt(0x100000), TxStateTest.this.random.nextInt(128), (long)TxStateTest.this.random.nextInt(0x100000), (long)TxStateTest.this.random.nextInt(0x100000));
            }

            @Override
            void createLateState() {
                TxStateTest.this.state.nodeDoDelete((long)TxStateTest.this.random.nextInt(0x100000));
            }

            public void visitDeletedRelationship(long id) {
                this.visitEarly();
            }

            public void visitDeletedNode(long id) {
                this.visitLate();
            }
        });
    }

    public static RelationshipIterator wrapInRelationshipIterator(final PrimitiveLongIterator iterator) {
        return new RelationshipIterator.BaseIterator(){
            private int cursor;

            public <EXCEPTION extends Exception> boolean relationshipVisit(long relationshipId, RelationshipVisitor<EXCEPTION> visitor) throws EXCEPTION {
                throw new UnsupportedOperationException("Shouldn't be required");
            }

            protected boolean fetchNext() {
                return iterator.hasNext() && this.next(iterator.next());
            }
        };
    }

    @Before
    public void before() throws Exception {
        this.state = new TxState();
    }

    private IndexUpdater addNodesToIndex(final IndexDescriptor descriptor) {
        return new IndexUpdater(){

            @Override
            public void withDefaultStringProperties(long ... nodeIds) {
                ArrayList<Pair<Long, String>> entries = new ArrayList<Pair<Long, String>>(nodeIds.length);
                for (long nodeId : nodeIds) {
                    entries.add((Pair<Long, String>)Pair.of((Object)nodeId, (Object)("value" + nodeId)));
                }
                this.withStringProperties(entries);
            }

            @Override
            public void withStringProperties(Collection<Pair<Long, String>> nodesWithValues) {
                int labelId = descriptor.getLabelId();
                int propertyKeyId = descriptor.getPropertyKeyId();
                for (Pair<Long, String> entry : nodesWithValues) {
                    long nodeId = (Long)entry.first();
                    TxStateTest.this.state.nodeDoCreate(nodeId);
                    TxStateTest.this.state.nodeDoAddLabel(labelId, nodeId);
                    Property propertyBefore = Property.noNodeProperty((long)nodeId, (int)propertyKeyId);
                    DefinedProperty propertyAfter = Property.stringProperty((int)propertyKeyId, (String)((String)entry.other()));
                    TxStateTest.this.state.nodeDoReplaceProperty(nodeId, propertyBefore, propertyAfter);
                    TxStateTest.this.state.indexDoUpdateProperty(descriptor, nodeId, null, propertyAfter);
                }
            }

            @Override
            public <T extends Number> void withNumberProperties(Collection<Pair<Long, T>> nodesWithValues) {
                int labelId = descriptor.getLabelId();
                int propertyKeyId = descriptor.getPropertyKeyId();
                for (Pair<Long, T> entry : nodesWithValues) {
                    long nodeId = (Long)entry.first();
                    TxStateTest.this.state.nodeDoCreate(nodeId);
                    TxStateTest.this.state.nodeDoAddLabel(labelId, nodeId);
                    Property propertyBefore = Property.noNodeProperty((long)nodeId, (int)propertyKeyId);
                    DefinedProperty propertyAfter = Property.numberProperty((int)propertyKeyId, (Number)((Number)entry.other()));
                    TxStateTest.this.state.nodeDoReplaceProperty(nodeId, propertyBefore, propertyAfter);
                    TxStateTest.this.state.indexDoUpdateProperty(descriptor, nodeId, null, propertyAfter);
                }
            }

            @Override
            public void withBooleanProperties(Collection<Pair<Long, Boolean>> nodesWithValues) {
                int labelId = descriptor.getLabelId();
                int propertyKeyId = descriptor.getPropertyKeyId();
                for (Pair<Long, Boolean> entry : nodesWithValues) {
                    long nodeId = (Long)entry.first();
                    TxStateTest.this.state.nodeDoCreate(nodeId);
                    TxStateTest.this.state.nodeDoAddLabel(labelId, nodeId);
                    Property propertyBefore = Property.noNodeProperty((long)nodeId, (int)propertyKeyId);
                    DefinedProperty propertyAfter = Property.booleanProperty((int)propertyKeyId, (boolean)((Boolean)entry.other()));
                    TxStateTest.this.state.nodeDoReplaceProperty(nodeId, propertyBefore, propertyAfter);
                    TxStateTest.this.state.indexDoUpdateProperty(descriptor, nodeId, null, propertyAfter);
                }
            }
        };
    }

    private static interface IndexUpdater {
        public void withDefaultStringProperties(long ... var1);

        public void withStringProperties(Collection<Pair<Long, String>> var1);

        public <T extends Number> void withNumberProperties(Collection<Pair<Long, T>> var1);

        public void withBooleanProperties(Collection<Pair<Long, Boolean>> var1);
    }

    abstract class VisitationOrder
    extends TxStateVisitor.Adapter {
        private final Set<String> visitMethods = new HashSet<String>();
        private boolean late;

        VisitationOrder(int size) {
            for (Method method : ((Object)((Object)this)).getClass().getDeclaredMethods()) {
                if (!method.getName().startsWith("visit")) continue;
                this.visitMethods.add(method.getName());
            }
            Assert.assertEquals((String)"should implement exactly two visit*(...) methods", (long)2L, (long)this.visitMethods.size());
            do {
                if (TxStateTest.this.random.nextBoolean()) {
                    this.createEarlyState();
                    continue;
                }
                this.createLateState();
            } while (size-- > 0);
        }

        abstract void createEarlyState();

        abstract void createLateState();

        final void visitEarly() {
            if (this.late) {
                String early = "the early visit*-method";
                String late = "the late visit*-method";
                for (StackTraceElement trace : Thread.currentThread().getStackTrace()) {
                    if (!this.visitMethods.contains(trace.getMethodName())) continue;
                    early = trace.getMethodName();
                    for (String method : this.visitMethods) {
                        if (method.equals(early)) continue;
                        late = method;
                    }
                    break;
                }
                Assert.fail((String)(early + "(...) should not be invoked after " + late + "(...)"));
            }
        }

        final void visitLate() {
            this.late = true;
        }
    }
}

