/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.HashSet;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestRelationshipGrabSize {
    private static final int GRAB_SIZE = 10;
    private static GraphDatabaseAPI db;
    private Transaction tx;

    @BeforeClass
    public static void doBefore() throws Exception {
        db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.relationship_grab_size, String.valueOf(10)).newGraphDatabase();
    }

    @AfterClass
    public static void doAfter() throws Exception {
        db.shutdown();
    }

    private void beginTx() {
        this.tx = db.beginTx();
    }

    private void finishTx(boolean success) {
        if (success) {
            this.tx.success();
        }
        this.tx.close();
    }

    @Test
    public void deleteRelationshipFromNotFullyLoadedNode() throws Exception {
        this.beginTx();
        Node node1 = db.createNode();
        Node node2 = db.createNode();
        Node node3 = db.createNode();
        DynamicRelationshipType type1 = DynamicRelationshipType.withName((String)"type1");
        DynamicRelationshipType type2 = DynamicRelationshipType.withName((String)"type2");
        node1.createRelationshipTo(node3, (RelationshipType)type1);
        HashSet<Relationship> type2Relationships = new HashSet<Relationship>();
        for (int i = 0; i < 10; ++i) {
            type2Relationships.add(node1.createRelationshipTo(node2, (RelationshipType)type2));
        }
        this.finishTx(true);
        this.beginTx();
        node1 = db.getNodeById(node1.getId());
        node2 = db.getNodeById(node2.getId());
        node3 = db.getNodeById(node3.getId());
        node1.getRelationships().iterator().next();
        ((Relationship)node3.getRelationships().iterator().next()).delete();
        Assert.assertFalse((boolean)node3.getRelationships().iterator().hasNext());
        Assert.assertEquals(type2Relationships, (Object)IteratorUtil.addToCollection((Iterable)node1.getRelationships(), new HashSet()));
        this.finishTx(true);
        this.beginTx();
        Assert.assertEquals(type2Relationships, (Object)IteratorUtil.addToCollection((Iterable)node1.getRelationships(), new HashSet()));
        this.finishTx(false);
    }

    @Test
    public void commitToNotFullyLoadedNode() throws Exception {
        this.beginTx();
        Node node1 = db.createNode();
        Node node2 = db.createNode();
        DynamicRelationshipType type = DynamicRelationshipType.withName((String)"type");
        for (int i = 0; i < 12; ++i) {
            node1.createRelationshipTo(node2, (RelationshipType)type);
        }
        this.finishTx(true);
        this.beginTx();
        ((Relationship)node1.getRelationships().iterator().next()).delete();
        node1.setProperty("foo", (Object)"bar");
        int relCount = 0;
        for (Relationship rel : node2.getRelationships()) {
            ++relCount;
        }
        Assert.assertEquals((long)11L, (long)relCount);
        relCount = 0;
        for (Relationship rel : node1.getRelationships()) {
            ++relCount;
        }
        Assert.assertEquals((long)11L, (long)relCount);
        Assert.assertEquals((Object)"bar", (Object)node1.getProperty("foo"));
        this.finishTx(true);
    }

    @Test
    public void createRelationshipAfterClearedCache() {
        int i;
        this.beginTx();
        Node node1 = db.createNode();
        Node node2 = db.createNode();
        int expectedCount = 0;
        for (i = 0; i < 150; ++i) {
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            ++expectedCount;
        }
        this.finishTx(true);
        this.beginTx();
        for (i = 0; i < 50; ++i) {
            node1.createRelationshipTo(node2, (RelationshipType)MyRelTypes.TEST);
            ++expectedCount;
        }
        Assert.assertEquals((long)expectedCount, (long)IteratorUtil.count((Iterable)node1.getRelationships()));
        this.finishTx(true);
        this.beginTx();
        Assert.assertEquals((long)expectedCount, (long)IteratorUtil.count((Iterable)node1.getRelationships()));
        this.finishTx(false);
    }

    @Test
    public void grabSizeWithTwoTypesDeleteAndCount() {
        Relationship rel;
        int i;
        this.beginTx();
        Node node1 = db.createNode();
        Node node2 = db.createNode();
        int count = 0;
        DynamicRelationshipType type1 = DynamicRelationshipType.withName((String)"type");
        DynamicRelationshipType type2 = DynamicRelationshipType.withName((String)"bar");
        for (i = 0; i < 12; ++i) {
            rel = node1.createRelationshipTo(node2, (RelationshipType)type1);
            ++count;
        }
        for (i = 0; i < 11; ++i) {
            rel = node1.createRelationshipTo(node2, (RelationshipType)type2);
            ++count;
        }
        this.finishTx(true);
        this.clearCacheAndCreateDeleteCount(db, node1, node2, (RelationshipType)type1, (RelationshipType)type2, count);
        this.clearCacheAndCreateDeleteCount(db, node1, node2, (RelationshipType)type2, (RelationshipType)type1, count);
        this.clearCacheAndCreateDeleteCount(db, node1, node2, (RelationshipType)type1, (RelationshipType)type1, count);
        this.clearCacheAndCreateDeleteCount(db, node1, node2, (RelationshipType)type2, (RelationshipType)type2, count);
    }

    private void clearCacheAndCreateDeleteCount(GraphDatabaseAPI db, Node node1, Node node2, RelationshipType createType, RelationshipType deleteType, int expectedCount) {
        try (Transaction tx = db.beginTx();){
            node1.createRelationshipTo(node2, createType);
            ((Relationship)node1.getRelationships(new RelationshipType[]{deleteType}).iterator().next()).delete();
            Assert.assertEquals((long)expectedCount, (long)IteratorUtil.count((Iterable)node1.getRelationships()));
            Assert.assertEquals((long)expectedCount, (long)IteratorUtil.count((Iterable)node2.getRelationships()));
            tx.success();
        }
        tx = db.beginTx();
        var8_8 = null;
        try {
            Assert.assertEquals((long)expectedCount, (long)IteratorUtil.count((Iterable)node1.getRelationships()));
            Assert.assertEquals((long)expectedCount, (long)IteratorUtil.count((Iterable)node2.getRelationships()));
            tx.success();
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var8_8 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable x2) {
                        var8_8.addSuppressed(x2);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }
}

