/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.security;

import java.io.File;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.security.URLAccessRules;
import org.neo4j.kernel.security.URLAccessValidationError;

public class FileURLAccessRuleTest {
    @Test
    public void shouldThrowWhenFileURLContainsAuthority() throws Exception {
        try {
            URLAccessRules.fileAccess().validate((GraphDatabaseAPI)Mockito.mock(GraphDatabaseAPI.class), new URL("file://foo/bar/baz"));
            Assert.fail((String)"expected exception not thrown ");
        }
        catch (URLAccessValidationError error) {
            MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"file URL may not contain an authority section (i.e. it should be 'file:///')"));
        }
    }

    @Test
    public void shouldThrowWhenFileURLContainsQuery() throws Exception {
        try {
            URLAccessRules.fileAccess().validate((GraphDatabaseAPI)Mockito.mock(GraphDatabaseAPI.class), new URL("file:///bar/baz?q=foo"));
            Assert.fail((String)"expected exception not thrown ");
        }
        catch (URLAccessValidationError error) {
            MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"file URL may not contain a query component"));
        }
    }

    @Test
    public void shouldThrowWhenFileAccessIsDisabled() throws Exception {
        URL url = new URL("file:///bar/baz.csv");
        GraphDatabaseAPI gdb = (GraphDatabaseAPI)Mockito.mock(GraphDatabaseAPI.class);
        DependencyResolver mockResolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        Mockito.when((Object)gdb.getDependencyResolver()).thenReturn((Object)mockResolver);
        Config config = new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.allow_file_urls.name(), "false"}));
        Mockito.when((Object)mockResolver.resolveDependency((Class)Matchers.eq(Config.class))).thenReturn((Object)config);
        try {
            URLAccessRules.fileAccess().validate(gdb, url);
            Assert.fail((String)"expected exception not thrown ");
        }
        catch (URLAccessValidationError error) {
            MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"configuration property 'allow_file_urls' is false"));
        }
    }

    @Test
    public void shouldAdjustURLToWithinImportDirectory() throws Exception {
        URL url = new File("/bar/baz.csv").toURI().toURL();
        GraphDatabaseAPI gdb = (GraphDatabaseAPI)Mockito.mock(GraphDatabaseAPI.class);
        DependencyResolver mockResolver = (DependencyResolver)Mockito.mock(DependencyResolver.class);
        Mockito.when((Object)gdb.getDependencyResolver()).thenReturn((Object)mockResolver);
        Config config = new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.load_csv_file_url_root.name(), "/var/lib/neo4j/import"}));
        Mockito.when((Object)mockResolver.resolveDependency((Class)Matchers.eq(Config.class))).thenReturn((Object)config);
        URL accessURL = URLAccessRules.fileAccess().validate(gdb, url);
        URL expected = new File("/var/lib/neo4j/import/bar/baz.csv").toURI().toURL();
        Assert.assertEquals((Object)expected, (Object)accessURL);
    }
}

