/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.graphdb.mockfs.DelegatingFileSystemAbstraction;
import org.neo4j.graphdb.mockfs.DelegatingStoreChannel;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PreAllocatedRecords;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.PageCacheRule;

public class NodeStoreTest {
    @ClassRule
    public static PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public final EphemeralFileSystemRule efs = new EphemeralFileSystemRule();
    private NodeStore nodeStore;
    private NeoStores neoStores;

    @After
    public void tearDown() {
        if (this.neoStores != null) {
            this.neoStores.close();
        }
    }

    @Test
    public void shouldReadFirstFromSingleRecordDynamicLongArray() throws Exception {
        Long expectedId = 12L;
        long[] ids = new long[]{expectedId, 23L, 42L};
        DynamicRecord firstRecord = new DynamicRecord(0L);
        List<DynamicRecord> dynamicRecords = Arrays.asList(firstRecord);
        DynamicArrayStore.allocateFromNumbers(new ArrayList(), (Object)ids, dynamicRecords.iterator(), (DynamicRecordAllocator)new PreAllocatedRecords(60));
        Long firstId = NodeStore.readOwnerFromDynamicLabelsRecord((DynamicRecord)firstRecord);
        Assert.assertEquals((Object)expectedId, (Object)firstId);
    }

    @Test
    public void shouldReadFirstAsNullFromEmptyDynamicLongArray() throws Exception {
        Object expectedId = null;
        long[] ids = new long[]{};
        DynamicRecord firstRecord = new DynamicRecord(0L);
        List<DynamicRecord> dynamicRecords = Arrays.asList(firstRecord);
        DynamicArrayStore.allocateFromNumbers(new ArrayList(), (Object)ids, dynamicRecords.iterator(), (DynamicRecordAllocator)new PreAllocatedRecords(60));
        Long firstId = NodeStore.readOwnerFromDynamicLabelsRecord((DynamicRecord)firstRecord);
        Assert.assertEquals(expectedId, (Object)firstId);
    }

    @Test
    public void shouldReadFirstFromTwoRecordDynamicLongArray() throws Exception {
        Long expectedId = 12L;
        long[] ids = new long[]{expectedId, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L};
        DynamicRecord firstRecord = new DynamicRecord(0L);
        List<DynamicRecord> dynamicRecords = Arrays.asList(firstRecord, new DynamicRecord(1L));
        DynamicArrayStore.allocateFromNumbers(new ArrayList(), (Object)ids, dynamicRecords.iterator(), (DynamicRecordAllocator)new PreAllocatedRecords(8));
        Long firstId = NodeStore.readOwnerFromDynamicLabelsRecord((DynamicRecord)firstRecord);
        Assert.assertEquals((Object)expectedId, (Object)firstId);
    }

    @Test
    public void shouldCombineProperFiveByteLabelField() throws Exception {
        EphemeralFileSystemAbstraction fs = this.efs.get();
        this.nodeStore = this.newNodeStore((FileSystemAbstraction)fs);
        long nodeId = 0L;
        long labels = 0x8000000001L;
        NodeRecord record = new NodeRecord(nodeId, false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_NEXT_PROPERTY.intValue());
        record.setInUse(true);
        record.setLabelField(labels, Collections.emptyList());
        this.nodeStore.updateRecord(record);
        NodeRecord readRecord = this.nodeStore.getRecord(nodeId);
        Assert.assertEquals((long)labels, (long)readRecord.getLabelField());
    }

    @Test
    public void shouldKeepRecordLightWhenSettingLabelFieldWithoutDynamicRecords() throws Exception {
        NodeRecord record = new NodeRecord(0L, false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_NEXT_PROPERTY.intValue());
        record.setLabelField(0L, Collections.emptyList());
        Assert.assertTrue((boolean)record.isLight());
    }

    @Test
    public void shouldMarkRecordHeavyWhenSettingLabelFieldWithDynamicRecords() throws Exception {
        NodeRecord record = new NodeRecord(0L, false, (long)Record.NO_NEXT_RELATIONSHIP.intValue(), (long)Record.NO_NEXT_PROPERTY.intValue());
        DynamicRecord dynamicRecord = new DynamicRecord(1L);
        record.setLabelField(0x8000000001L, Arrays.asList(dynamicRecord));
        Assert.assertFalse((boolean)record.isLight());
    }

    @Test
    public void shouldTellNodeInUse() throws Exception {
        EphemeralFileSystemAbstraction fs = this.efs.get();
        NodeStore store = this.newNodeStore((FileSystemAbstraction)fs);
        long exists = store.nextId();
        store.updateRecord(new NodeRecord(exists, false, 10L, 20L, true));
        long deleted = store.nextId();
        store.updateRecord(new NodeRecord(deleted, false, 10L, 20L, true));
        store.updateRecord(new NodeRecord(deleted, false, 10L, 20L, false));
        Assert.assertTrue((boolean)store.inUse(exists));
        Assert.assertFalse((boolean)store.inUse(deleted));
        Assert.assertFalse((boolean)store.inUse(IdType.NODE.getMaxValue()));
    }

    @Test
    public void scanningRecordsShouldVisitEachInUseRecordOnce() throws IOException {
        EphemeralFileSystemAbstraction fs = this.efs.get();
        this.nodeStore = this.newNodeStore((FileSystemAbstraction)fs);
        ThreadLocalRandom rng = ThreadLocalRandom.current();
        final PrimitiveLongSet nextRelSet = Primitive.longSet();
        for (int i = 0; i < 10000; ++i) {
            int nextRelCandidate = rng.nextInt(0, Integer.MAX_VALUE);
            if (!nextRelSet.add((long)nextRelCandidate)) continue;
            long nodeId = this.nodeStore.nextId();
            NodeRecord record = new NodeRecord(nodeId, false, (long)nextRelCandidate, 20L, true);
            this.nodeStore.updateRecord(record);
            if (rng.nextInt(0, 10) >= 3) continue;
            nextRelSet.remove((long)nextRelCandidate);
            record.setInUse(false);
            this.nodeStore.updateRecord(record);
        }
        Visitor<NodeRecord, IOException> scanner = new Visitor<NodeRecord, IOException>(){

            public boolean visit(NodeRecord record) throws IOException {
                Assert.assertTrue((boolean)nextRelSet.remove(record.getNextRel()));
                return false;
            }
        };
        this.nodeStore.scanAllRecords((Visitor)scanner);
        Assert.assertTrue((boolean)nextRelSet.isEmpty());
    }

    @Test
    public void shouldCloseStoreFileOnFailureToOpen() throws Exception {
        final AtomicBoolean fired = new AtomicBoolean();
        DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction((FileSystemAbstraction)this.efs.get()){

            public StoreChannel open(File fileName, String mode) throws IOException {
                return new DelegatingStoreChannel(super.open(fileName, mode)){

                    public int read(ByteBuffer dst) throws IOException {
                        Exception stack = new Exception();
                        if (Exceptions.containsStackTraceElement((Throwable)stack, (Predicate)Exceptions.forMethod((String)"initGenerator")) && !Exceptions.containsStackTraceElement((Throwable)stack, (Predicate)Exceptions.forMethod((String)"createNodeStore"))) {
                            fired.set(true);
                            throw new IOException("Proving a point here");
                        }
                        return super.read(dst);
                    }
                };
            }
        };
        try (PageCache pageCache = pageCacheRule.getPageCache((FileSystemAbstraction)fs);){
            this.newNodeStore((FileSystemAbstraction)fs);
            Assert.fail((String)"Should fail");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)Exceptions.contains((Throwable)e, (Class[])new Class[]{IOException.class}));
            Assert.assertTrue((boolean)fired.get());
        }
    }

    private NodeStore newNodeStore(FileSystemAbstraction fs) throws IOException {
        return this.newNodeStore(fs, pageCacheRule.getPageCache(fs));
    }

    private NodeStore newNodeStore(FileSystemAbstraction fs, PageCache pageCache) throws IOException {
        File storeDir = new File("dir");
        fs.mkdirs(storeDir);
        DefaultIdGeneratorFactory idGeneratorFactory = new DefaultIdGeneratorFactory(fs);
        StoreFactory factory = new StoreFactory(storeDir, new Config(), (IdGeneratorFactory)idGeneratorFactory, pageCache, fs, (LogProvider)NullLogProvider.getInstance());
        this.neoStores = factory.openAllNeoStores(true);
        this.nodeStore = this.neoStores.getNodeStore();
        return this.nodeStore;
    }
}

