/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.TokenStore;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;

public class PropertyDeduplicatorTestUtil {
    public static Map<String, Integer> indexPropertyKeys(PropertyKeyTokenStore propertyKeyTokenStore) {
        HashMap<String, Integer> propertyKeyIndex = new HashMap<String, Integer>();
        long highestPossibleIdInUse = propertyKeyTokenStore.getHighestPossibleIdInUse();
        int i = 0;
        while ((long)i <= highestPossibleIdInUse) {
            Token token = propertyKeyTokenStore.getToken(i);
            propertyKeyIndex.put(token.name(), token.id());
            ++i;
        }
        return propertyKeyIndex;
    }

    public static Token findTokenFor(TokenStore tokenStore, String key) {
        long highestPossibleIdInUse = tokenStore.getHighestPossibleIdInUse();
        int i = 0;
        while ((long)i <= highestPossibleIdInUse) {
            Token token = tokenStore.getToken(i);
            if (token.name().equals(key)) {
                return token;
            }
            ++i;
        }
        return null;
    }

    public static void replacePropertyKey(PropertyStore propertyStore, PrimitiveRecord record, Token original, Token replacement) {
        long nextProp = record.getNextProp();
        while (nextProp != (long)Record.NO_NEXT_PROPERTY.intValue()) {
            PropertyRecord propertyRecord = propertyStore.getRecord(nextProp);
            for (PropertyBlock propertyBlock : propertyRecord) {
                if (propertyBlock.getKeyIndexId() != original.id()) continue;
                propertyBlock.setKeyIndexId(replacement.id());
            }
            propertyStore.updateRecord(propertyRecord);
            nextProp = propertyRecord.getNextProp();
        }
    }
}

