/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.impl.util.SynchronizedArrayIdOrderingQueue;
import org.neo4j.test.CleanupRule;
import org.neo4j.test.OtherThreadExecutor;

public class SynchronizedArrayIdOrderingQueueTest {
    @Rule
    public final CleanupRule cleanup = new CleanupRule();

    @Test
    public void shouldOfferQueueABunchOfIds() throws Exception {
        int i;
        SynchronizedArrayIdOrderingQueue queue = new SynchronizedArrayIdOrderingQueue(5);
        for (i = 0; i < 7; ++i) {
            queue.offer((long)i);
        }
        for (i = 0; i < 7; ++i) {
            Assert.assertFalse((boolean)queue.isEmpty());
            queue.waitFor((long)i);
            queue.removeChecked((long)i);
        }
        Assert.assertTrue((boolean)queue.isEmpty());
    }

    @Test
    public void shouldOfferAwaitAndRemoveRoundAndRound() throws Exception {
        SynchronizedArrayIdOrderingQueue queue = new SynchronizedArrayIdOrderingQueue(5);
        long offeredId = 0L;
        long awaitedId = 0L;
        queue.offer(offeredId++);
        queue.offer(offeredId++);
        for (int i = 0; i < 20; ++i) {
            queue.waitFor(awaitedId);
            queue.removeChecked(awaitedId++);
            queue.offer(offeredId++);
            Assert.assertFalse((boolean)queue.isEmpty());
        }
        queue.removeChecked(awaitedId++);
        queue.removeChecked(awaitedId++);
        Assert.assertTrue((boolean)queue.isEmpty());
    }

    @Test
    public void shouldHaveOneThreadWaitForARemoval() throws Exception {
        SynchronizedArrayIdOrderingQueue queue = new SynchronizedArrayIdOrderingQueue(5);
        queue.offer(3L);
        queue.offer(5L);
        OtherThreadExecutor<Object> t2 = this.cleanup.add(new OtherThreadExecutor<Object>("T2", null));
        Future<Object> await5 = t2.executeDontWait(this.awaitHead((IdOrderingQueue)queue, 5L));
        t2.waitUntilWaiting();
        queue.removeChecked(3L);
        await5.get();
    }

    @Test
    public void shouldExtendArrayWhenIdsAreWrappingAround() throws Exception {
        int i;
        SynchronizedArrayIdOrderingQueue queue = new SynchronizedArrayIdOrderingQueue(5);
        for (i = 0; i < 3; ++i) {
            queue.offer((long)i);
            queue.removeChecked((long)i);
        }
        for (i = 3; i < 8; ++i) {
            queue.offer((long)i);
        }
        queue.offer(8L);
        for (i = 3; i <= 8; ++i) {
            Assert.assertFalse((boolean)queue.isEmpty());
            queue.removeChecked((long)i);
        }
        Assert.assertTrue((boolean)queue.isEmpty());
    }

    private OtherThreadExecutor.WorkerCommand<Void, Object> awaitHead(final IdOrderingQueue queue, final long id) {
        return new OtherThreadExecutor.WorkerCommand<Void, Object>(){

            @Override
            public Object doWork(Void state) throws Exception {
                queue.waitFor(id);
                return null;
            }
        };
    }
}

