/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.CommandReader;
import org.neo4j.kernel.impl.transaction.log.CommandWriter;
import org.neo4j.kernel.impl.transaction.log.InMemoryLogChannel;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.impl.transaction.log.entry.OnePhaseCommit;

public class LogEntryParserV2_2Test {
    private final LogEntryVersion version = LogEntryVersion.V2_2;
    private final CommandReader commandReader = this.version.newCommandReader();
    private final LogPositionMarker marker = new LogPositionMarker();
    private final LogPosition position = new LogPosition(0L, 29L);

    @Test
    public void shouldParseStartEntry() throws IOException {
        LogEntryStart start = new LogEntryStart(this.version, 1, 2, 3L, 4L, new byte[]{5}, this.position);
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.putInt(start.getMasterId());
        channel.putInt(start.getLocalId());
        channel.putLong(start.getTimeWritten());
        channel.putLong(start.getLastCommittedTxWhenTransactionStarted());
        channel.putInt(start.getAdditionalHeader().length);
        channel.put(start.getAdditionalHeader(), start.getAdditionalHeader().length);
        channel.getCurrentPosition(this.marker);
        LogEntryParser parser = this.version.entryParser((byte)1);
        LogEntry logEntry = parser.parse(this.version, (ReadableLogChannel)channel, this.marker, this.commandReader);
        Assert.assertEquals((Object)start, (Object)logEntry);
        Assert.assertFalse((boolean)parser.skip());
    }

    @Test
    public void shouldParseOnePhaseCommitEntry() throws IOException {
        OnePhaseCommit commit = new OnePhaseCommit(this.version, 42L, 21L);
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.putLong(commit.getTxId());
        channel.putLong(commit.getTimeWritten());
        channel.getCurrentPosition(this.marker);
        LogEntryParser parser = this.version.entryParser((byte)5);
        LogEntry logEntry = parser.parse(this.version, (ReadableLogChannel)channel, this.marker, this.commandReader);
        Assert.assertEquals((Object)commit, (Object)logEntry);
        Assert.assertFalse((boolean)parser.skip());
    }

    @Test
    public void shouldParseCommandsUsingAGivenFactory() throws IOException {
        Command.NodeCommand nodeCommand = new Command.NodeCommand();
        nodeCommand.init(new NodeRecord(0L), new NodeRecord(0L));
        LogEntryCommand command = new LogEntryCommand(this.version, (Command)nodeCommand);
        InMemoryLogChannel channel = new InMemoryLogChannel();
        new CommandWriter((WritableLogChannel)channel).visitNodeCommand(nodeCommand);
        channel.getCurrentPosition(this.marker);
        LogEntryParser parser = this.version.entryParser((byte)3);
        LogEntry logEntry = parser.parse(this.version, (ReadableLogChannel)channel, this.marker, this.commandReader);
        Assert.assertEquals((Object)command, (Object)logEntry);
        Assert.assertFalse((boolean)parser.skip());
    }

    @Test
    public void shouldParseEmptyEntry() throws IOException {
        LogEntryParser parser = this.version.entryParser((byte)0);
        LogEntry logEntry = parser.parse(this.version, (ReadableLogChannel)new InMemoryLogChannel(), this.marker, this.commandReader);
        Assert.assertNull((Object)logEntry);
        Assert.assertFalse((boolean)parser.skip());
    }

    @Test
    public void shouldThrowWhenParsingUnknownEntry() {
        try {
            this.version.entryParser((byte)2);
            Assert.fail((String)"Should have thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

