/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.InMemoryLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;

public class LogHeaderReaderTest {
    private final long expectedLogVersion = 6L;
    private final long expectedTxId = 42L;

    @Test
    public void shouldReadALogHeaderFromALogChannel() throws IOException {
        InMemoryLogChannel channel = new InMemoryLogChannel();
        channel.putLong(LogHeaderWriter.encodeLogVersion((long)6L));
        channel.putLong(42L);
        LogHeader result = LogHeaderReader.readLogHeader((ReadableLogChannel)channel);
        Assert.assertEquals((Object)new LogHeader(6, 6L, 42L), (Object)result);
    }

    @Test
    public void shouldReadALogHeaderFromAByteChannel() throws IOException {
        final ByteBuffer buffer = ByteBuffer.allocate(16);
        ReadableByteChannel channel = (ReadableByteChannel)Mockito.mock(ReadableByteChannel.class);
        Mockito.when((Object)channel.read(buffer)).thenAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock invocation) throws Throwable {
                buffer.putLong(LogHeaderWriter.encodeLogVersion((long)6L));
                buffer.putLong(42L);
                return 16;
            }
        });
        LogHeader result = LogHeaderReader.readLogHeader((ByteBuffer)buffer, (ReadableByteChannel)channel, (boolean)true);
        Assert.assertEquals((Object)new LogHeader(6, 6L, 42L), (Object)result);
    }

    @Test
    public void shouldFailWhenUnableToReadALogHeaderFromAChannel() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        ReadableByteChannel channel = (ReadableByteChannel)Mockito.mock(ReadableByteChannel.class);
        Mockito.when((Object)channel.read(buffer)).thenReturn((Object)1);
        try {
            LogHeaderReader.readLogHeader((ByteBuffer)buffer, (ReadableByteChannel)channel, (boolean)true);
            Assert.fail((String)"should have thrown");
        }
        catch (IOException ex) {
            Assert.assertEquals((Object)"Unable to read log version and last committed tx", (Object)ex.getMessage());
        }
    }

    @Test
    public void shouldReadALogHeaderFromAFile() throws IOException {
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        File file = File.createTempFile("ReadLogHeader", this.getClass().getSimpleName());
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(LogHeaderWriter.encodeLogVersion((long)6L));
        buffer.putLong(42L);
        try (OutputStream stream = fs.openAsOutputStream(file, false);){
            stream.write(buffer.array());
        }
        LogHeader result = LogHeaderReader.readLogHeader((FileSystemAbstraction)fs, (File)file);
        Assert.assertEquals((Object)new LogHeader(6, 6L, 42L), (Object)result);
    }

    @Test
    public void shouldFailWhenUnableToReadALogHeaderFromAFile() throws IOException {
        DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
        File file = File.createTempFile("ReadLogHeaderFail", this.getClass().getSimpleName());
        try {
            LogHeaderReader.readLogHeader((FileSystemAbstraction)fs, (File)file);
            Assert.fail((String)"should have thrown");
        }
        catch (IOException ex) {
            Assert.assertEquals((Object)"Unable to read log version and last committed tx", (Object)ex.getMessage());
        }
    }

    @Test
    public void shouldReadALongString() throws IOException {
        int stringSize = 32769;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < stringSize; ++i) {
            sb.append("x");
        }
        String lengthyString = sb.toString();
        InMemoryLogChannel channel = new InMemoryLogChannel(stringSize + 3);
        IoPrimitiveUtils.write3bLengthAndString((WritableLogChannel)channel, (String)lengthyString);
        String stringFromChannel = IoPrimitiveUtils.read3bLengthAndString((ReadableLogChannel)channel);
        Assert.assertEquals((Object)lengthyString, (Object)stringFromChannel);
    }
}

