/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.exceptions.schema.UniquenessConstraintVerificationFailedKernelException;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.store.record.UniquePropertyConstraintRule;
import org.neo4j.kernel.impl.transaction.state.IntegrityValidator;
import org.powermock.api.mockito.PowerMockito;

public class IntegrityValidatorTest {
    @Test
    public void shouldValidateUniquenessIndexes() throws Exception {
        NeoStores store = (NeoStores)PowerMockito.mock(NeoStores.class);
        IndexingService indexes = (IndexingService)PowerMockito.mock(IndexingService.class);
        IntegrityValidator validator = new IntegrityValidator(store, indexes);
        ((IndexingService)Mockito.doThrow((Throwable)new UniquenessConstraintVerificationFailedKernelException(null, (Throwable)new RuntimeException())).when((Object)indexes)).validateIndex(2L);
        UniquePropertyConstraintRule record = UniquePropertyConstraintRule.uniquenessConstraintRule((long)1L, (int)1, (int)1, (long)2L);
        try {
            validator.validateSchemaRule((SchemaRule)record);
            Assert.fail((String)"Should have thrown integrity error.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void deletingNodeWithRelationshipsIsNotAllowed() throws Exception {
        NeoStores store = (NeoStores)PowerMockito.mock(NeoStores.class);
        IndexingService indexes = (IndexingService)PowerMockito.mock(IndexingService.class);
        IntegrityValidator validator = new IntegrityValidator(store, indexes);
        NodeRecord record = new NodeRecord(1L, false, 1L, -1L);
        record.setInUse(false);
        try {
            validator.validateNodeRecord(record);
            Assert.fail((String)"Should have thrown integrity error.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void transactionsStartedBeforeAConstraintWasCreatedAreDisallowed() throws Exception {
        NeoStores store = (NeoStores)PowerMockito.mock(NeoStores.class);
        MetaDataStore metaDataStore = (MetaDataStore)PowerMockito.mock(MetaDataStore.class);
        Mockito.when((Object)store.getMetaDataStore()).thenReturn((Object)metaDataStore);
        IndexingService indexes = (IndexingService)PowerMockito.mock(IndexingService.class);
        Mockito.when((Object)metaDataStore.getLatestConstraintIntroducingTx()).thenReturn((Object)10L);
        IntegrityValidator validator = new IntegrityValidator(store, indexes);
        try {
            validator.validateTransactionStartKnowledge(1L);
            Assert.fail((String)"Should have thrown integrity error.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

