/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.Test;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.PhysicalLogNeoCommandReaderV2_2;
import org.neo4j.kernel.impl.transaction.log.CommandWriter;
import org.neo4j.kernel.impl.transaction.log.InMemoryLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;

public class RelationshipGroupCommandTest {
    @Test
    public void shouldSerializeAndDeserializeUnusedRecords() throws Exception {
        RelationshipGroupRecord record = new RelationshipGroupRecord(10L, 12);
        record.setInUse(false);
        Command.RelationshipGroupCommand command = new Command.RelationshipGroupCommand();
        command.init(record);
        this.assertSerializationWorksFor(command);
    }

    @Test
    public void shouldSerializeCreatedRecord() throws Exception {
        RelationshipGroupRecord record = new RelationshipGroupRecord(10L, 12);
        record.setCreated();
        record.setInUse(true);
        Command.RelationshipGroupCommand command = new Command.RelationshipGroupCommand();
        command.init(record);
        this.assertSerializationWorksFor(command);
    }

    private void assertSerializationWorksFor(Command.RelationshipGroupCommand cmd) throws IOException {
        InMemoryLogChannel channel = new InMemoryLogChannel();
        CommandWriter commandWriter = new CommandWriter((WritableLogChannel)channel);
        commandWriter.visitRelationshipGroupCommand(cmd);
        PhysicalLogNeoCommandReaderV2_2 commandReader = new PhysicalLogNeoCommandReaderV2_2();
        Command.RelationshipGroupCommand result = (Command.RelationshipGroupCommand)commandReader.read((ReadableLogChannel)channel);
        RelationshipGroupRecord recordBefore = cmd.getRecord();
        RelationshipGroupRecord recordAfter = result.getRecord();
        MatcherAssert.assertThat((Object)recordBefore.getFirstIn(), (Matcher)IsEqual.equalTo((Object)recordAfter.getFirstIn()));
        MatcherAssert.assertThat((Object)recordBefore.getFirstOut(), (Matcher)IsEqual.equalTo((Object)recordAfter.getFirstOut()));
        MatcherAssert.assertThat((Object)recordBefore.getFirstLoop(), (Matcher)IsEqual.equalTo((Object)recordAfter.getFirstLoop()));
        MatcherAssert.assertThat((Object)recordBefore.getNext(), (Matcher)IsEqual.equalTo((Object)recordAfter.getNext()));
        MatcherAssert.assertThat((Object)recordBefore.getOwningNode(), (Matcher)IsEqual.equalTo((Object)recordAfter.getOwningNode()));
        MatcherAssert.assertThat((Object)recordBefore.getPrev(), (Matcher)IsEqual.equalTo((Object)recordAfter.getPrev()));
        MatcherAssert.assertThat((Object)recordBefore.getType(), (Matcher)IsEqual.equalTo((Object)recordAfter.getType()));
    }
}

