/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.function.Predicate;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PathExpanderBuilder;
import org.neo4j.graphdb.PathExpanders;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.BidirectionalTraversalDescription;
import org.neo4j.graphdb.traversal.BranchCollisionDetector;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.InitialBranchState;
import org.neo4j.graphdb.traversal.SideSelectorPolicy;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.SideSelectorPolicies;
import org.neo4j.kernel.StandardBranchCollisionDetector;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.Uniqueness;
import org.neo4j.kernel.impl.traversal.BranchCollisionPolicy;
import org.neo4j.kernel.impl.traversal.TraversalTestBase;

public class TestBidirectionalTraversal
extends TraversalTestBase {
    RelationshipType to = DynamicRelationshipType.withName((String)"TO");
    private Transaction tx;

    @Before
    public void init() {
        this.tx = this.beginTx();
    }

    @After
    public void tearDown() {
        this.tx.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void bothSidesMustHaveSameUniqueness() throws Exception {
        this.createGraph("A TO B");
        IteratorUtil.count((Iterable)Traversal.bidirectionalTraversal().startSide(Traversal.traversal().uniqueness((UniquenessFactory)Uniqueness.NODE_GLOBAL)).endSide(Traversal.traversal().uniqueness((UniquenessFactory)Uniqueness.RELATIONSHIP_GLOBAL)).traverse(this.getNodeWithName("A"), this.getNodeWithName("B")));
    }

    @Test
    public void pathsForOneDirection() throws Exception {
        this.createGraph("a TO b", "b TO c", "c TO d", "d TO e", "e TO f", "f TO a");
        PathExpander expander = Traversal.pathExpanderForTypes((RelationshipType)this.to, (Direction)Direction.OUTGOING);
        this.expectPaths(Traversal.bidirectionalTraversal().mirroredSides(Traversal.traversal().uniqueness((UniquenessFactory)Uniqueness.NODE_PATH).expand(expander)).traverse(this.getNodeWithName("a"), this.getNodeWithName("f")), "a,b,c,d,e,f");
        this.expectPaths(Traversal.bidirectionalTraversal().mirroredSides(Traversal.traversal().uniqueness((UniquenessFactory)Uniqueness.RELATIONSHIP_PATH).expand(expander)).traverse(this.getNodeWithName("a"), this.getNodeWithName("f")), "a,b,c,d,e,f", "a,b,c,d,e,f");
    }

    @Test
    public void collisionEvaluator() throws Exception {
        this.createGraph("a TO b", "a TO c", "c TO b", "a TO d", "d TO e", "e TO b", "e TO f", "f TO b");
        PathExpander expander = PathExpanders.forTypeAndDirection((RelationshipType)this.to, (Direction)Direction.OUTGOING);
        BidirectionalTraversalDescription traversal = Traversal.bidirectionalTraversal().mirroredSides(Traversal.traversal().uniqueness((UniquenessFactory)Uniqueness.NODE_PATH).expand(expander));
        this.expectPaths(traversal.collisionEvaluator(Evaluators.includeIfContainsAll((Node[])new Node[]{this.getNodeWithName("e")})).traverse(this.getNodeWithName("a"), this.getNodeWithName("b")), "a,d,e,b", "a,d,e,f,b");
        this.expectPaths(traversal.collisionEvaluator(Evaluators.includeIfContainsAll((Node[])new Node[]{this.getNodeWithName("e"), this.getNodeWithName("f")})).traverse(this.getNodeWithName("a"), this.getNodeWithName("b")), "a,d,e,f,b");
    }

    @Test
    public void multipleCollisionEvaluators() throws Exception {
        this.createGraph("a TO b", "b TO g", "g TO c", "a TO d", "d TO e", "e TO c", "e TO f", "f TO c");
        this.expectPaths(Traversal.bidirectionalTraversal().mirroredSides(Traversal.traversal().uniqueness((UniquenessFactory)Uniqueness.NODE_PATH)).collisionEvaluator(Evaluators.atDepth((int)3)).collisionEvaluator(Evaluators.includeIfContainsAll((Node[])new Node[]{this.getNodeWithName("e")})).traverse(this.getNodeWithName("a"), this.getNodeWithName("c")), "a,d,e,c");
    }

    @Test
    public void multipleStartAndEndNodes() throws Exception {
        this.createGraph("a TO d", "b TO d", "c TO d", "e TO d", "e TO f", "e TO g");
        PathExpander expander = PathExpanderBuilder.empty().add(this.to).build();
        TraversalDescription side = Traversal.traversal().uniqueness((UniquenessFactory)Uniqueness.NODE_PATH).expand(expander);
        this.expectPaths(Traversal.bidirectionalTraversal().mirroredSides(side).traverse(Arrays.asList(this.getNodeWithName("a"), this.getNodeWithName("b"), this.getNodeWithName("c")), Arrays.asList(this.getNodeWithName("f"), this.getNodeWithName("g"))), "a,d,e,f", "a,d,e,g", "b,d,e,f", "b,d,e,g", "c,d,e,f", "c,d,e,g");
    }

    @Test
    public void ensureCorrectPathEntitiesInShortPath() throws Exception {
        this.createGraph("a TO b");
        Node a = this.getNodeWithName("a");
        Node b = this.getNodeWithName("b");
        Relationship r = a.getSingleRelationship(this.to, Direction.OUTGOING);
        Path path = (Path)IteratorUtil.single((Iterable)Traversal.bidirectionalTraversal().mirroredSides(Traversal.traversal().relationships(this.to, Direction.OUTGOING).uniqueness((UniquenessFactory)Uniqueness.NODE_PATH)).collisionEvaluator(Evaluators.atDepth((int)1)).sideSelector((SideSelectorPolicy)SideSelectorPolicies.LEVEL, 1).traverse(a, b));
        TestBidirectionalTraversal.assertContainsInOrder(path.nodes(), a, b);
        TestBidirectionalTraversal.assertContainsInOrder(path.reverseNodes(), b, a);
        TestBidirectionalTraversal.assertContainsInOrder(path.relationships(), r);
        TestBidirectionalTraversal.assertContainsInOrder(path.reverseRelationships(), r);
        TestBidirectionalTraversal.assertContainsInOrder(path, new PropertyContainer[]{a, r, b});
        Assert.assertEquals((Object)a, (Object)path.startNode());
        Assert.assertEquals((Object)b, (Object)path.endNode());
        Assert.assertEquals((Object)r, (Object)path.lastRelationship());
    }

    @Test
    public void mirroredTraversalReversesInitialState() throws Exception {
        this.createGraph("a TO b", "b TO c", "c TO d");
        BranchCollisionPolicy collisionPolicy = new BranchCollisionPolicy(){

            public BranchCollisionDetector create(Evaluator evaluator) {
                return new StandardBranchCollisionDetector(null, null){

                    protected boolean includePath(Path path, TraversalBranch startPath, TraversalBranch endPath) {
                        Assert.assertEquals((Object)0, (Object)startPath.state());
                        Assert.assertEquals((Object)10, (Object)endPath.state());
                        return true;
                    }
                };
            }

            public BranchCollisionDetector create(Evaluator evaluator, Predicate<Path> pathPredicate) {
                return this.create(evaluator);
            }
        };
        IteratorUtil.count((Iterable)Traversal.bidirectionalTraversal().mirroredSides(Traversal.traversal((UniquenessFactory)Uniqueness.NODE_PATH).expand(PathExpanders.forType((RelationshipType)this.to), (InitialBranchState)new InitialBranchState.State((Object)0, (Object)10))).collisionPolicy(collisionPolicy).traverse(this.getNodeWithName("a"), this.getNodeWithName("d")));
    }
}

